/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.basic;

import db.sql.api.Cmd;
import db.sql.api.Getter;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.IConflictUpdate;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.ConflictUpdateTableField;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.executor.AbstractInsert;
import db.sql.api.impl.cmd.struct.insert.InsertFields;
import db.sql.api.impl.cmd.struct.update.UpdateSets;
import db.sql.api.tookit.CmdUtils;

public class ConflictUpdate<T>
implements IConflictUpdate<T>,
Cmd {
    private final CmdFactory cmdFactory;
    private boolean overwriteAll;
    private UpdateSets updateSets;

    public ConflictUpdate(CmdFactory cmdFactory) {
        this.cmdFactory = cmdFactory;
    }

    public IConflictUpdate<T> set(Getter<T> field, Object value) {
        if (this.updateSets == null) {
            this.updateSets = new UpdateSets();
        }
        this.updateSets.set((TableField)this.cmdFactory.field(field), Methods.cmd(value));
        return this;
    }

    public void overwrite(Getter<T> ... fields) {
        if (this.updateSets == null) {
            this.updateSets = new UpdateSets();
        }
        for (Getter<T> field : fields) {
            TableField tableField = (TableField)this.cmdFactory.field(field);
            this.updateSets.set(tableField, new ConflictUpdateTableField(tableField));
        }
    }

    public void overwriteAll() {
        this.overwriteAll = true;
    }

    public boolean isOverwriteAll() {
        return this.overwriteAll;
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (this.overwriteAll && this.updateSets == null) {
            this.updateSets = new UpdateSets();
            AbstractInsert insert = (AbstractInsert)module;
            InsertFields insertFields = insert.getInsertFields();
            insertFields.getFields().stream().filter(item -> !item.isId()).forEach(item -> this.updateSets.set((TableField)item, new ConflictUpdateTableField((TableField)item)));
        }
        if (this.updateSets == null) {
            throw new IllegalStateException("conflict update not set");
        }
        return this.updateSets.sql(module, this, context, sqlBuilder);
    }

    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, (Cmd)this.updateSets);
    }
}

