/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.basic;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.Getter;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.IConflict;
import db.sql.api.cmd.basic.IConflictAction;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.basic.ConflictAction;
import db.sql.api.impl.cmd.executor.AbstractInsert;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;
import java.util.function.Consumer;

public class Conflict<T>
implements IConflict<T>,
Cmd {
    private final CmdFactory cmdFactory;
    private String[] conflictKeys;
    private final ConflictAction<T> conflictAction;
    private final boolean hasChecked = false;

    public Conflict(CmdFactory cmdFactory) {
        this.cmdFactory = cmdFactory;
        this.conflictAction = new ConflictAction(cmdFactory);
    }

    public IConflict<T> conflictKeys(String[] conflictKeys) {
        if (this.conflictKeys == null) {
            this.conflictKeys = conflictKeys;
        }
        return this;
    }

    public IConflict<T> conflictKeys(Getter<T>[] conflictKeys) {
        if (conflictKeys != null && conflictKeys.length > 0) {
            String[] array = new String[conflictKeys.length];
            for (int i = 0; i < conflictKeys.length; ++i) {
                array[i] = this.cmdFactory.columnName(conflictKeys[i]);
            }
            this.conflictKeys = array;
        }
        return this;
    }

    public void onConflict(Consumer<IConflictAction> action) {
        action.accept(this.conflictAction);
    }

    public final void addDefaultConflictKeys(AbstractInsert insert, DbType dbType) {
        String[] conflictKeys;
        if (this.conflictKeys != null && this.conflictKeys.length > 0) {
            return;
        }
        if (!(dbType != DbType.ORACLE && (dbType != DbType.PGSQL && dbType != DbType.KING_BASE || this.conflictAction.isDoNothing()) && (dbType != DbType.OPEN_GAUSS && dbType != DbType.SQLITE || this.conflictAction.getConflictUpdate() != null) || (conflictKeys = insert.getInsertTable().getTable().getIds()) == null || conflictKeys.length <= 0)) {
            this.conflictKeys = conflictKeys;
        }
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (this.conflictAction == null) {
            throw new IllegalStateException("conflict action not set");
        }
        this.addDefaultConflictKeys((AbstractInsert)module, context.getDbType());
        if (context.getDbType() == DbType.MYSQL || context.getDbType() == DbType.MARIA_DB || context.getDbType() == DbType.H2) {
            if (!this.conflictAction.isDoNothing()) {
                sqlBuilder.append(" ON DUPLICATE KEY");
            }
        } else if (context.getDbType() == DbType.OPEN_GAUSS) {
            sqlBuilder.append(" ON DUPLICATE KEY");
        } else if (context.getDbType() == DbType.PGSQL || context.getDbType() == DbType.KING_BASE || context.getDbType() == DbType.SQLITE) {
            sqlBuilder.append(" ON CONFLICT");
            if (this.conflictKeys != null) {
                sqlBuilder.append(SqlConst.BRACKET_LEFT);
                for (int i = 0; i < this.conflictKeys.length; ++i) {
                    if (i != 0) {
                        sqlBuilder.append(SqlConst.DELIMITER);
                    }
                    sqlBuilder.append(context.getDbType().wrap(this.conflictKeys[i]));
                }
                sqlBuilder.append(SqlConst.BRACKET_RIGHT);
            }
        }
        this.conflictAction.sql(module, this, context, sqlBuilder);
        return sqlBuilder;
    }

    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, this.conflictAction);
    }

    public String[] getConflictKeys() {
        return this.conflictKeys;
    }

    public ConflictAction<T> getConflictAction() {
        return this.conflictAction;
    }
}

