/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.util;

import cn.xbatis.core.mybatis.typeHandler.EnumSupport;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public final class TypeConvertUtil {
    private TypeConvertUtil() {
    }

    public static <T> T convert(Object value, Class<T> targetType) {
        Object newValue;
        if (value == null) {
            return null;
        }
        if (value.getClass() == targetType) {
            return (T)value;
        }
        if (targetType.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (value instanceof String && value.equals("")) {
            return null;
        }
        if (targetType.isEnum()) {
            if (EnumSupport.class.isAssignableFrom(targetType)) {
                for (EnumSupport e : (EnumSupport[])targetType.getEnumConstants()) {
                    if (!e.getCode().toString().equals(value.toString())) continue;
                    return (T)e;
                }
            } else {
                for (Enum e : (Enum[])targetType.getEnumConstants()) {
                    if (!e.name().equals(value.toString())) continue;
                    return (T)e;
                }
            }
            throw new RuntimeException("Can't find default value:" + value + " from enum: " + targetType);
        }
        if (targetType == String.class) {
            newValue = value.toString();
        } else {
            if (targetType == Boolean.class || targetType == Boolean.TYPE) {
                String v = value.toString().trim();
                if (v.equals("1")) {
                    return (T)Boolean.TRUE;
                }
                if (v.equals("0")) {
                    return (T)Boolean.FALSE;
                }
                if (v.equalsIgnoreCase("true")) {
                    return (T)Boolean.TRUE;
                }
                if (v.equalsIgnoreCase("false")) {
                    return (T)Boolean.FALSE;
                }
                throw new RuntimeException("value : " + value + " can't convert to a boolean");
            }
            if (targetType == Byte.class || targetType == Byte.TYPE) {
                newValue = Byte.valueOf(value.toString());
            } else if (targetType == Integer.class || targetType == Integer.TYPE) {
                newValue = Integer.valueOf(value.toString());
            } else if (targetType == Long.class || targetType == Long.TYPE) {
                newValue = Long.valueOf(value.toString());
            } else if (targetType == Double.class || targetType == Double.TYPE) {
                newValue = Double.valueOf(value.toString());
            } else if (targetType == BigDecimal.class) {
                newValue = new BigDecimal(value.toString());
            } else if (targetType == BigInteger.class) {
                newValue = new BigInteger(value.toString());
            } else if (targetType == Character.class) {
                newValue = Character.valueOf(value.toString().charAt(0));
            } else {
                throw new RuntimeException("Inconsistent types value : " + value + " can't convert to a " + targetType);
            }
        }
        return (T)newValue;
    }

    public static void main(String[] args) {
        List list = TypeConvertUtil.convert(new ArrayList(), List.class);
    }
}

