/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.util;

import cn.xbatis.core.XbatisGlobalConfig;
import cn.xbatis.core.mybatis.MappedStatementUtil;
import cn.xbatis.core.mybatis.provider.PagingCountSqlSource;
import cn.xbatis.core.mybatis.provider.PagingListSqlSource;
import cn.xbatis.core.util.GenericUtil;
import cn.xbatis.db.annotations.Paging;
import cn.xbatis.page.IPager;
import cn.xbatis.page.PageUtil;
import cn.xbatis.page.PagerField;
import db.sql.api.DbType;
import db.sql.api.impl.paging.OracleRowNumPagingProcessor;
import db.sql.api.impl.paging.SQLServerRowNumberOverPagingProcessor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;

public final class PagingUtil {
    public static void handleMappedStatement(MappedStatement ms) {
        if (ms.getSqlCommandType() != SqlCommandType.SELECT) {
            return;
        }
        Method mapperMethod = MappedStatementUtil.getMethod(ms);
        if (Objects.isNull(mapperMethod)) {
            return;
        }
        if (mapperMethod.isDefault() || Modifier.isStatic(mapperMethod.getModifiers())) {
            return;
        }
        if (!mapperMethod.isAnnotationPresent(Paging.class)) {
            return;
        }
        Paging paging = mapperMethod.getAnnotation(Paging.class);
        PagingUtil.addPagingCountMappedStatement(ms, paging);
        PagingUtil.addPagingListMappedStatement(ms, mapperMethod);
    }

    private static void addPagingListMappedStatement(MappedStatement ms, Method mapperMethod) {
        String id = ms.getId() + "&list";
        Class returnType = ((ResultMap)ms.getResultMaps().get(0)).getType();
        ResultMap resultMap = IPager.class.isAssignableFrom(returnType) ? new ResultMap.Builder(ms.getConfiguration(), id + "-inline", GenericUtil.getGenericParameterTypes(mapperMethod).get(0), Collections.emptyList()).build() : (ResultMap)ms.getResultMaps().get(0);
        PagingListSqlSource sqlSource = new PagingListSqlSource(ms.getConfiguration(), ms.getSqlSource());
        MappedStatement.Builder msBuilder = new MappedStatement.Builder(ms.getConfiguration(), id, (SqlSource)sqlSource, ms.getSqlCommandType()).resource(ms.getResource()).resultMaps(Collections.singletonList(resultMap)).parameterMap(ms.getParameterMap()).keyGenerator(ms.getKeyGenerator()).fetchSize(ms.getFetchSize()).statementType(ms.getStatementType()).lang(ms.getLang()).timeout(ms.getTimeout()).useCache(ms.isUseCache()).cache(ms.getCache());
        MappedStatement newMappedStatement = msBuilder.build();
        try {
            ms.getConfiguration().addMappedStatement(newMappedStatement);
        }
        catch (IllegalArgumentException e) {
            ms.getStatementLog().warn(e.getMessage());
        }
    }

    private static void addPagingCountMappedStatement(MappedStatement ms, Paging paging) {
        String id = ms.getId() + "&count";
        ResultMap resultMap = new ResultMap.Builder(ms.getConfiguration(), id + "-inline", Integer.class, Collections.emptyList()).build();
        List<ResultMap> resultMaps = Collections.singletonList(resultMap);
        PagingCountSqlSource sqlSource = new PagingCountSqlSource(ms.getConfiguration(), ms.getSqlSource(), paging.optimize());
        MappedStatement.Builder msBuilder = new MappedStatement.Builder(ms.getConfiguration(), id, (SqlSource)sqlSource, ms.getSqlCommandType()).resource(ms.getResource()).resultMaps(resultMaps).parameterMap(ms.getParameterMap()).keyGenerator(ms.getKeyGenerator()).fetchSize(ms.getFetchSize()).statementType(ms.getStatementType()).lang(ms.getLang()).timeout(ms.getTimeout()).useCache(ms.isUseCache()).cache(ms.getCache());
        MappedStatement newMappedStatement = msBuilder.build();
        try {
            ms.getConfiguration().addMappedStatement(newMappedStatement);
        }
        catch (IllegalArgumentException e) {
            ms.getStatementLog().warn(e.getMessage());
        }
    }

    public static String getLimitedSQL(DbType dbType, IPager<?> pager, String sql) {
        Integer number = (Integer)pager.get(PagerField.NUMBER);
        Integer size = (Integer)pager.get(PagerField.SIZE);
        if (size < 0) {
            return sql;
        }
        int offset = PageUtil.getOffset((int)number, (int)size);
        if (dbType == DbType.ORACLE && XbatisGlobalConfig.getPagingProcessor(dbType) instanceof OracleRowNumPagingProcessor) {
            return PagingUtil.getOracleRowNumLimitedSQL(size, offset, sql);
        }
        if (dbType == DbType.SQL_SERVER && XbatisGlobalConfig.getPagingProcessor(dbType) instanceof SQLServerRowNumberOverPagingProcessor) {
            return PagingUtil.getSQLServerRowNumLimitedSQL(size, offset, sql);
        }
        if (dbType == DbType.SQL_SERVER) {
            return sql + " OFFSET " + offset + " ROWS FETCH NEXT " + size + " ROWS ONLY";
        }
        StringBuilder sqlBuilder = new StringBuilder("SELECT * FROM (");
        sqlBuilder.append(sql).append(") T ");
        if (dbType == DbType.ORACLE) {
            sqlBuilder.append(" OFFSET ").append(offset).append(" ROWS FETCH NEXT ").append(size).append(" ROWS ONLY");
            return sqlBuilder.toString();
        }
        sqlBuilder.append(" LIMIT ").append(size).append(" OFFSET ").append(offset);
        return sqlBuilder.toString();
    }

    private static String getOracleRowNumLimitedSQL(Integer size, int offset, String sql) {
        return "SELECT *  FROM ( SELECT IT.*,ROWNUM R$N FROM (" + sql + ") IT WHERE ROWNUM <= " + (size + offset) + ") NT WHERE NT.R$N  >" + offset;
    }

    private static String getSQLServerRowNumLimitedSQL(Integer size, int offset, String sql) {
        String orderBy;
        String upperCaseSql = sql.toUpperCase();
        int formIndex = upperCaseSql.toUpperCase().indexOf("FROM");
        String selectSql = sql.substring(0, formIndex) + ",ROW_NUMBER() OVER(";
        String middleSql = sql.substring(formIndex, upperCaseSql.length());
        int orderByIndex = middleSql.toUpperCase().lastIndexOf("ORDER BY");
        if (orderByIndex != -1) {
            orderBy = middleSql.substring(orderByIndex);
            middleSql = middleSql.substring(0, orderByIndex);
        } else {
            orderBy = " ORDER BY CURRENT_TIMESTAMP";
        }
        selectSql = selectSql + orderBy + ") R$N ";
        return "SELECT TOP " + size + " * FROM  ( " + selectSql + middleSql + " ) T WHERE R$N > " + offset;
    }

    private static String removeOrderBy(String sql, boolean optimize) {
        String upperCaseSql;
        int orderByIndex;
        if (optimize && (orderByIndex = (upperCaseSql = sql.toUpperCase()).lastIndexOf("ORDER BY")) > 0) {
            if (upperCaseSql.indexOf("OFFSET", orderByIndex + 1) > 0 || upperCaseSql.indexOf("LIMIT", orderByIndex + 1) > 0) {
                return sql;
            }
            Stack<Character> stack = new Stack<Character>();
            for (int i = orderByIndex + "ORDER BY".length() + 1; i < sql.length(); ++i) {
                char ch = sql.charAt(i);
                if (ch == '(') {
                    stack.push(Character.valueOf('('));
                    continue;
                }
                if (ch != ')' || !stack.isEmpty() && ((Character)stack.pop()).charValue() == '(') continue;
                return sql;
            }
            if (!stack.isEmpty()) {
                return sql;
            }
            sql = sql.substring(0, orderByIndex + (sql.length() - upperCaseSql.length()));
        }
        return sql;
    }

    public static String getCountSQL(DbType dbType, String sql, boolean optimize) {
        if (dbType == DbType.SQL_SERVER) {
            optimize = true;
        }
        return "SELECT COUNT(*) FROM (" + PagingUtil.removeOrderBy(sql, optimize) + ") T";
    }
}

