/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.util;

import cn.xbatis.db.annotations.Ignore;
import cn.xbatis.db.annotations.Ignores;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.ibatis.reflection.TypeParameterResolver;

public final class FieldUtil {
    public static boolean isResultMappingField(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        return !field.isAnnotationPresent(Ignore.class);
    }

    private static boolean isIgnoreField(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        return field.isAnnotationPresent(Ignore.class);
    }

    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashSet<String> fieldNameSet = new HashSet<String>();
        HashSet<String> ignoreFieldNameSet = new HashSet<String>();
        for (Class<?> parseClass = clazz; parseClass != null; parseClass = parseClass.getSuperclass()) {
            Field[] fields;
            Ignores ignores = parseClass.getAnnotation(Ignores.class);
            if (ignores != null) {
                Collections.addAll(fieldNameSet, ignores.value());
            }
            for (Field field : fields = parseClass.getDeclaredFields()) {
                boolean isIgnore = ignoreFieldNameSet.contains(field.getName());
                if (isIgnore) continue;
                if (FieldUtil.isResultMappingField(field)) {
                    if (fieldNameSet.contains(field.getName()) || ignoreFieldNameSet.contains(field.getName())) continue;
                    fieldNameSet.add(field.getName());
                    fieldList.add(field);
                    continue;
                }
                if (!FieldUtil.isIgnoreField(field)) continue;
                ignoreFieldNameSet.add(field.getName());
            }
        }
        return fieldList;
    }

    public static Class<?> getFieldType(Class clazz, Field field) {
        Type type = TypeParameterResolver.resolveFieldType((Field)field, (Type)clazz);
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        return (Class)type;
    }

    public static Class<?> getFieldFinalType(Class clazz, Field field) {
        return FieldUtil.getFieldFinalType(TypeParameterResolver.resolveFieldType((Field)field, (Type)clazz), clazz, field);
    }

    private static Class<?> getFieldFinalType(Type type, Class clazz, Field field) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type t = parameterizedType.getActualTypeArguments()[0];
            if (t instanceof Class) {
                return (Class)t;
            }
            if (t instanceof ParameterizedType && (parameterizedType = (ParameterizedType)t).getRawType() instanceof Class) {
                return (Class)parameterizedType.getRawType();
            }
            return Object.class;
        }
        return field.getType();
    }
}

