/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.util;

import cn.xbatis.core.XbatisGlobalConfig;
import db.sql.api.DbType;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.ibatis.session.Configuration;

public final class DbTypeUtil {
    public static DbType getDbType(Configuration configuration) {
        try {
            return DbTypeUtil.getDbType(configuration.getDatabaseId(), configuration.getEnvironment().getDataSource());
        }
        catch (DbTypeParseException e) {
            if (XbatisGlobalConfig.getDefaultDbType() != null) {
                return XbatisGlobalConfig.getDefaultDbType();
            }
            throw e;
        }
    }

    public static DbType getDbType(String databaseId, DataSource dataSource) {
        if (Objects.isNull(databaseId) || databaseId.isEmpty()) {
            return DbTypeUtil.getDbType(dataSource);
        }
        return DbType.getByName((String)databaseId);
    }

    public static DbType getDbType(DataSource dataSource) {
        return DbTypeUtil.getDbType(DbTypeUtil.getJdbcUrl(dataSource));
    }

    public static DbType getDbType(String jdbcUrl) {
        if ((jdbcUrl = jdbcUrl.toLowerCase()).contains(":mysql:") || jdbcUrl.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (jdbcUrl.contains(":mariadb:")) {
            return DbType.MARIA_DB;
        }
        if (jdbcUrl.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        if (jdbcUrl.contains(":postgresql:")) {
            return DbType.PGSQL;
        }
        if (jdbcUrl.contains(":sqlserver:")) {
            return DbType.SQL_SERVER;
        }
        if (jdbcUrl.contains(":h2:")) {
            return DbType.H2;
        }
        if (jdbcUrl.contains(":dm:")) {
            return DbType.DM;
        }
        if (jdbcUrl.contains(":db2:")) {
            return DbType.DB2;
        }
        if (jdbcUrl.contains(":kingbase8:")) {
            return DbType.KING_BASE;
        }
        if (jdbcUrl.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (jdbcUrl.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        }
        if (jdbcUrl.contains(":opengauss:")) {
            return DbType.OPEN_GAUSS;
        }
        throw new DbTypeParseException("Unrecognized database type:" + jdbcUrl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJdbcUrl(DataSource dataSource) {
        String[] methodNames;
        for (String methodName : methodNames = new String[]{"getUrl", "getJdbcUrl"}) {
            try {
                Method method = dataSource.getClass().getMethod(methodName, new Class[0]);
                return (String)method.invoke((Object)dataSource, new Object[0]);
            }
            catch (Exception exception) {
            }
        }
        try (Connection connection = dataSource.getConnection();){
            String string = DbTypeUtil.getJdbcUrl(connection);
            return string;
        }
        catch (Exception e) {
            throw new DbTypeParseException("\u65e0\u6cd5\u89e3\u6790\u5230 \u6570\u636e\u5e93\u7684url", e);
        }
    }

    public static String getJdbcUrl(Connection connection) {
        try {
            return connection.getMetaData().getURL();
        }
        catch (Exception e) {
            throw new DbTypeParseException("\u65e0\u6cd5\u89e3\u6790\u5230 \u6570\u636e\u5e93\u7684url", e);
        }
    }

    public static DbType getDbType(Connection connection) {
        return DbTypeUtil.getDbType(DbTypeUtil.getJdbcUrl(connection));
    }

    public static class DbTypeParseException
    extends RuntimeException {
        public DbTypeParseException(String message) {
            super(message);
        }

        public DbTypeParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

