/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.sql.util;

import cn.xbatis.core.db.reflect.NestedResultInfo;
import cn.xbatis.core.db.reflect.ResultFieldInfo;
import cn.xbatis.core.db.reflect.ResultInfo;
import cn.xbatis.core.db.reflect.ResultInfos;
import cn.xbatis.core.db.reflect.ResultTableFieldInfo;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.db.annotations.ResultEntity;
import cn.xbatis.db.annotations.Table;
import db.sql.api.Cmd;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.struct.query.Returning;
import java.util.ArrayList;
import java.util.List;

public final class ReturningClassUtil {
    private static void buildReturning(CmdFactory cmdFactory, Returning returning, List<ResultFieldInfo> resultFieldInfos, List<Cmd> cmdList) {
        resultFieldInfos.stream().filter(item -> item instanceof ResultTableFieldInfo).forEach(item -> {
            ResultTableFieldInfo resultTableFieldInfo = (ResultTableFieldInfo)item;
            TableField tableField = cmdFactory.field(resultTableFieldInfo.getTableInfo().getType(), resultTableFieldInfo.getTableFieldInfo().getField().getName(), resultTableFieldInfo.getStorey());
            if (!cmdList.contains(tableField)) {
                cmdList.add((Cmd)tableField);
            }
        });
    }

    private static void buildNestedReturning(CmdFactory cmdFactory, Returning returning, List<NestedResultInfo> nestedResultInfos, List<Cmd> cmdList) {
        nestedResultInfos.forEach(item -> {
            ReturningClassUtil.buildReturning(cmdFactory, returning, item.getResultFieldInfos(), cmdList);
            ReturningClassUtil.buildNestedReturning(cmdFactory, returning, item.getNestedResultInfos(), cmdList);
        });
    }

    private static List<Cmd> buildReturning(CmdFactory cmdFactory, Returning returning, Class clazz, int storey, List<Cmd> cmdList) {
        if (clazz.isAnnotationPresent(ResultEntity.class)) {
            ResultInfo resultInfo = ResultInfos.get(clazz);
            ReturningClassUtil.buildReturning(cmdFactory, returning, resultInfo.getResultFieldInfos(), cmdList);
            ReturningClassUtil.buildNestedReturning(cmdFactory, returning, resultInfo.getNestedResultInfos(), cmdList);
        } else if (clazz.isAnnotationPresent(Table.class)) {
            TableInfo tableInfo = Tables.get(clazz);
            for (int i = 0; i < tableInfo.getFieldSize(); ++i) {
                TableFieldInfo tableFieldInfo = tableInfo.getTableFieldInfos().get(i);
                if (!tableFieldInfo.getTableFieldAnnotation().select()) continue;
                cmdList.add((Cmd)cmdFactory.field(clazz, tableFieldInfo.getField().getName(), storey));
            }
        }
        return cmdList;
    }

    public static boolean returning(CmdFactory cmdFactory, Returning returning, Class clazz) {
        return ReturningClassUtil.returning(cmdFactory, returning, clazz, 1);
    }

    public static boolean returning(CmdFactory cmdFactory, Returning returning, Class clazz, int storey) {
        ArrayList<Cmd> list = new ArrayList<Cmd>();
        returning.returning(ReturningClassUtil.buildReturning(cmdFactory, returning, clazz, storey, list));
        return !list.isEmpty();
    }

    public static void returning(CmdFactory cmdFactory, Returning returning, int storey, Class[] entities) {
        ArrayList<Cmd> list = new ArrayList<Cmd>();
        for (Class entity : entities) {
            ReturningClassUtil.buildReturning(cmdFactory, returning, entity, storey, list);
        }
        returning.returning(list);
    }
}

