/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.sql.executor;

import cn.xbatis.core.sql.executor.BaseQuery;
import cn.xbatis.core.sql.executor.XmlScript;
import cn.xbatis.core.sql.executor.XmlScriptType;
import cn.xbatis.core.sql.executor.XmlScriptUtil;
import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.impl.cmd.struct.Where;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Query<T>
extends BaseQuery<Query<T>, T> {
    private final Map<XmlScriptType, XmlScript> xmlScriptMap = new HashMap<XmlScriptType, XmlScript>();
    private DbType dbType;
    private String mybatisParamNamespace;

    public Query() {
    }

    public Query(Where where) {
        super(where);
    }

    public static <T> Query<T> create() {
        return new Query<T>();
    }

    public static <T> Query<T> create(Where where) {
        if (where == null) {
            return Query.create();
        }
        return new Query<T>(where);
    }

    public <R> Query<R> returnType(Class<R> returnType) {
        return (Query)super.setReturnType(returnType);
    }

    public <R> Query<R> returnType(Class<R> returnType, Consumer<R> consumer) {
        return (Query)super.setReturnType(returnType, consumer);
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public void setMybatisParamName(String mybatisParamName) {
        if (mybatisParamName != null || !mybatisParamName.isEmpty()) {
            this.mybatisParamNamespace = mybatisParamName + ".";
        }
    }

    public List<Object> getQueryScriptParams() {
        return this.xmlScriptMap.get((Object)XmlScriptType.QUERY).getScriptParams();
    }

    public String getQueryScript() {
        return this.xmlScriptMap.computeIfAbsent(XmlScriptType.QUERY, key -> XmlScriptUtil.buildXmlScript(this.mybatisParamNamespace, "queryScriptParams", (Cmd)this, this.dbType)).getSql();
    }

    public List<Object> getSelectScriptParams() {
        return this.xmlScriptMap.get((Object)XmlScriptType.SELECT).getScriptParams();
    }

    public String getSelectScript() {
        return this.xmlScriptMap.computeIfAbsent(XmlScriptType.SELECT, key -> XmlScriptUtil.buildXmlScript(this.mybatisParamNamespace, "selectScriptParams", (Cmd)this.getSelect(), this.dbType, "SELECT")).getSql();
    }

    public List<Object> getFromScriptParams() {
        return this.xmlScriptMap.get((Object)XmlScriptType.FROM).getScriptParams();
    }

    public String getFromScript() {
        return this.xmlScriptMap.computeIfAbsent(XmlScriptType.FROM, key -> XmlScriptUtil.buildXmlScript(this.mybatisParamNamespace, "fromScriptParams", (Cmd)this.getFrom(), this.dbType, "FROM")).getSql();
    }

    public List<Object> getWhereScriptParams() {
        return this.xmlScriptMap.get((Object)XmlScriptType.WHERE).getScriptParams();
    }

    public String getWhereScript() {
        return this.xmlScriptMap.computeIfAbsent(XmlScriptType.WHERE, key -> XmlScriptUtil.buildXmlScript(this.mybatisParamNamespace, "whereScriptParams", (Cmd)this.getWhere(), this.dbType, "WHERE")).getSql();
    }

    public List<Object> getOrderByScriptParams() {
        return this.xmlScriptMap.get((Object)XmlScriptType.ORDER_BY).getScriptParams();
    }

    public String getOrderByScript() {
        return this.xmlScriptMap.computeIfAbsent(XmlScriptType.ORDER_BY, key -> XmlScriptUtil.buildXmlScript(this.mybatisParamNamespace, "orderByScriptParams", (Cmd)this.getOrderBy(), this.dbType)).getSql();
    }

    public List<Object> getGroupByScriptParams() {
        return this.xmlScriptMap.get((Object)XmlScriptType.GROUP_BY).getScriptParams();
    }

    public String getGroupByScript() {
        return this.xmlScriptMap.computeIfAbsent(XmlScriptType.GROUP_BY, key -> XmlScriptUtil.buildXmlScript(this.mybatisParamNamespace, "groupByScriptParams", (Cmd)this.getGroupBy(), this.dbType)).getSql();
    }

    public List<Object> getHavingScriptParams() {
        return this.xmlScriptMap.get((Object)XmlScriptType.HAVING).getScriptParams();
    }

    public String getHavingScript() {
        return this.xmlScriptMap.computeIfAbsent(XmlScriptType.HAVING, key -> XmlScriptUtil.buildXmlScript(this.mybatisParamNamespace, "havingScriptParams", (Cmd)this.getHaving(), this.dbType)).getSql();
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        return super.sql(module, parent, context, sqlBuilder);
    }
}

