/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.sql.executor;

import cn.xbatis.core.XbatisGlobalConfig;
import cn.xbatis.core.mybatis.executor.statement.Timeoutable;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.TableSplitUtil;
import cn.xbatis.core.sql.executor.MpTable;
import cn.xbatis.core.sql.executor.MpTableField;
import db.sql.api.Cmd;
import db.sql.api.Getter;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.IConflictAction;
import db.sql.api.cmd.basic.ITableField;
import db.sql.api.cmd.listener.SQLListener;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.executor.AbstractInsert;
import java.util.List;
import java.util.function.Consumer;

public abstract class BaseInsert<T extends BaseInsert<T>>
extends AbstractInsert<T, MybatisCmdFactory>
implements Timeoutable<T> {
    protected Integer timeout;

    public BaseInsert() {
        super((CmdFactory)new MybatisCmdFactory());
    }

    @Override
    public T timeout(Integer timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @SafeVarargs
    public final <T2> T fields(Getter<T2> ... fields) {
        return (T)((BaseInsert)super.fields(fields));
    }

    public List<SQLListener> getSQLListeners() {
        return XbatisGlobalConfig.getSQLListeners();
    }

    public <T1> T onConflict(Consumer<IConflictAction<T1>> action) {
        return (T)((BaseInsert)super.onConflict(action));
    }

    @SafeVarargs
    public final T fields(TableField ... fields) {
        return (T)((BaseInsert)super.fields((ITableField[])fields));
    }

    private void splitTableHandle(MpTable table) {
        if (!table.getTableInfo().isSplitTable()) {
            return;
        }
        if (!table.getTableInfo().getTableName().equals(table.getName())) {
            return;
        }
        List insertFields = this.getInsertFields().getFields();
        int splitTableKeyIndex = -1;
        for (int i = 0; i < insertFields.size(); ++i) {
            TableField item = (TableField)insertFields.get(i);
            MpTableField tableField = (MpTableField)item;
            if (!tableField.getTableFieldInfo().isTableSplitKey()) continue;
            splitTableKeyIndex = i;
        }
        if (splitTableKeyIndex == -1) {
            throw new RuntimeException("Not found the split field in insert fields");
        }
        if (this.getInsertValues() == null) {
            List selectValues = this.getInsertSelect().getSelectQuery().getSelect().getSelectField();
            TableSplitUtil.splitHandle(table, selectValues.get(splitTableKeyIndex));
        } else {
            List insertValuesList = this.getInsertValues().getValues();
            for (List cmdList : insertValuesList) {
                TableSplitUtil.splitHandle(table, cmdList.get(splitTableKeyIndex));
                if (table.getTableInfo().getTableName().equals(table.getName())) continue;
                break;
            }
        }
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        this.selectorExecute(context.getDbType());
        if (this.getInsertTable().getTable() instanceof MpTable) {
            MpTable table = (MpTable)this.getInsertTable().getTable();
            this.splitTableHandle(table);
        }
        return super.sql(module, parent, context, sqlBuilder);
    }
}

