/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.sql;

import cn.xbatis.core.db.reflect.ModelInfo;
import cn.xbatis.core.db.reflect.Models;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.core.sql.executor.MpDatasetField;
import cn.xbatis.core.sql.executor.MpTable;
import cn.xbatis.core.sql.executor.MpTableField;
import cn.xbatis.core.sql.executor.MybatisConditionFactory;
import cn.xbatis.core.sql.executor.SubQuery;
import cn.xbatis.db.Model;
import db.sql.api.Getter;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.cmd.basic.IDatasetField;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.ConditionFactory;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.tookit.LambdaUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.util.MapUtil;

public class MybatisCmdFactory
extends CmdFactory {
    protected final Map<Class<?>, TableInfo> tableInfoCache = new HashMap(5);

    public MybatisCmdFactory() {
    }

    public MybatisCmdFactory(String tableAsPrefix) {
        super(tableAsPrefix);
    }

    public TableInfo getTableInfo(Class<?> entityClass) {
        return this.tableInfoCache.computeIfAbsent(entityClass, key -> Tables.get(entityClass));
    }

    public void cacheTableInfo(TableInfo tableInfo) {
        this.tableInfoCache.put(tableInfo.getType(), tableInfo);
    }

    public ConditionFactory createConditionFactory() {
        return new MybatisConditionFactory(this);
    }

    public MpTable table(Class entity, int storey) {
        if (storey > 1 && this.cacheTable(entity, storey - 1) == null) {
            for (int i = 1; i < storey; ++i) {
                this.table(entity, i);
            }
        }
        return (MpTable)((Object)MapUtil.computeIfAbsent((Map)this.tableCache, (Object)(storey + entity.getName()), key -> {
            TableInfo tableInfo = this.getTableInfo(entity);
            return new MpTable(tableInfo, this.tableAs(storey, ++this.tableNums));
        }));
    }

    public <T> TableField field(Getter<T> column, int storey) {
        LambdaUtil.LambdaFieldInfo fieldInfo = LambdaUtil.getFieldInfo(column);
        if (Model.class.isAssignableFrom(fieldInfo.getType())) {
            ModelInfo modelInfo = Models.get(fieldInfo.getType());
            this.cacheTableInfo(modelInfo.getTableInfo());
            return this.field(modelInfo.getEntityType(), modelInfo.getFieldInfo(fieldInfo.getName()).getTableFieldInfo().getField().getName(), storey);
        }
        return this.field(fieldInfo.getType(), fieldInfo.getName(), storey);
    }

    public <T> String columnName(Getter<T> column) {
        LambdaUtil.LambdaFieldInfo fieldInfo = LambdaUtil.getFieldInfo(column);
        if (Model.class.isAssignableFrom(fieldInfo.getType())) {
            ModelInfo modelInfo = Models.get(fieldInfo.getType());
            this.cacheTableInfo(modelInfo.getTableInfo());
            return modelInfo.getFieldInfo(fieldInfo.getName()).getTableFieldInfo().getColumnName();
        }
        TableInfo tableInfo = this.getTableInfo(fieldInfo.getType());
        this.cacheTableInfo(tableInfo);
        return tableInfo.getFieldInfo(fieldInfo.getName()).getColumnName();
    }

    public TableField field(Class entity, String filedName, int storey) {
        MpTable table = this.table(entity, storey);
        TableFieldInfo tableFieldInfo = table.getTableInfo().getFieldInfo(filedName);
        if (Objects.isNull(tableFieldInfo)) {
            throw new RuntimeException("property " + filedName + " is not a column");
        }
        return new MpTableField(table, tableFieldInfo);
    }

    public <T> TableField[] fields(int storey, Getter<T> ... columns) {
        TableField[] tableFields = new TableField[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            tableFields[i] = this.field(columns[i], storey);
        }
        return tableFields;
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> DATASET_FIELD field(IDataset<DATASET, DATASET_FIELD> dataset, Getter<T> column) {
        LambdaUtil.LambdaFieldInfo fieldInfo = LambdaUtil.getFieldInfo(column);
        TableInfo tableInfo = this.getTableInfo(fieldInfo.getType());
        TableFieldInfo tableFieldInfo = tableInfo.getFieldInfo(fieldInfo.getName());
        if (dataset instanceof MpTable) {
            return (DATASET_FIELD)((Object)new MpTableField((MpTable)dataset, tableFieldInfo));
        }
        if (dataset instanceof Table) {
            return (DATASET_FIELD)new TableField((Table)dataset, tableFieldInfo.getColumnName(), tableFieldInfo.isTableId());
        }
        return (DATASET_FIELD)((Object)new MpDatasetField(dataset, tableFieldInfo.getColumnName(), tableFieldInfo.getFieldInfo(), tableFieldInfo.getTypeHandler(), tableFieldInfo.getTableFieldAnnotation().jdbcType()));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> DATASET_FIELD field(IDataset<DATASET, DATASET_FIELD> dataset, String columnName) {
        if (dataset instanceof MpTable) {
            MpTable mpTable = (MpTable)dataset;
            return (DATASET_FIELD)mpTable.$(columnName);
        }
        return (DATASET_FIELD)super.field(dataset, columnName);
    }

    public SubQuery createSubQuery() {
        return new SubQuery();
    }
}

