/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapping;

import cn.xbatis.core.db.reflect.FieldInfo;
import cn.xbatis.core.db.reflect.NestedResultInfo;
import cn.xbatis.core.db.reflect.ResultFieldInfo;
import cn.xbatis.core.db.reflect.ResultInfo;
import cn.xbatis.core.db.reflect.ResultInfos;
import cn.xbatis.core.db.reflect.ResultTableFieldInfo;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.core.mybatis.configuration.MybatisConfiguration;
import cn.xbatis.core.mybatis.executor.MybatisIdUtil;
import cn.xbatis.core.util.FieldUtil;
import cn.xbatis.core.util.GenericUtil;
import cn.xbatis.db.annotations.ResultEntity;
import cn.xbatis.db.annotations.ResultField;
import cn.xbatis.db.annotations.Table;
import cn.xbatis.db.annotations.TypeHandler;
import db.sql.api.impl.tookit.SqlUtil;
import db.sql.api.tookit.PropertyNamer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.UnknownTypeHandler;

public final class ResultMapUtils {
    private ResultMapUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultMap getResultMap(MybatisConfiguration configuration, Class clazz) {
        String id = "mp-" + MybatisIdUtil.convertIdPath(clazz.getName());
        if (configuration.hasResultMap(id)) {
            return configuration.getResultMap(id);
        }
        Class clazz2 = clazz;
        synchronized (clazz2) {
            if (configuration.hasResultMap(id)) {
                return configuration.getResultMap(id);
            }
            List<ResultMapping> resultMappings = null;
            if (clazz.isAnnotationPresent(Table.class)) {
                resultMappings = ResultMapUtils.getEntityResultMappings(configuration, clazz);
            } else if (clazz.isAnnotationPresent(ResultEntity.class)) {
                resultMappings = ResultMapUtils.getResultEntityResultMappings(configuration, clazz);
            }
            ResultMap resultMap = null;
            if (Objects.nonNull(resultMappings)) {
                resultMap = new ResultMap.Builder((Configuration)configuration, id, clazz, resultMappings, Boolean.valueOf(false)).build();
                configuration.addResultMap(resultMap);
            } else if (Map.class.isAssignableFrom(clazz)) {
                resultMap = new ResultMap.Builder((Configuration)configuration, id, clazz, Collections.emptyList(), Boolean.valueOf(true)).build();
                configuration.addResultMap(resultMap);
            } else if (Objects.nonNull(clazz.getPackage()) && !clazz.getPackage().getName().startsWith("java")) {
                resultMap = new ResultMap.Builder((Configuration)configuration, id, clazz, ResultMapUtils.getNormalResultMappings(configuration, clazz), Boolean.valueOf(true)).build();
                configuration.addResultMap(resultMap);
            }
            return resultMap;
        }
    }

    private static List<ResultMapping> createResultMapping(MybatisConfiguration configuration, boolean isTableId, FieldInfo fieldInfo, String columnName, JdbcType jdbcType, Class<? extends org.apache.ibatis.type.TypeHandler<?>> typeHandler) {
        return Arrays.asList(configuration.buildResultMapping(isTableId, fieldInfo, columnName, jdbcType, typeHandler), configuration.buildResultMapping(isTableId, fieldInfo, SqlUtil.getAsName(fieldInfo.getClazz(), (Field)fieldInfo.getField()), jdbcType, typeHandler));
    }

    private static List<ResultMapping> getEntityResultMappings(MybatisConfiguration configuration, Class entity) {
        TableInfo tableInfo = Tables.get(entity);
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>(tableInfo.getTableFieldInfos().size() * 2);
        for (TableFieldInfo tableFieldInfo : tableInfo.getTableFieldInfos()) {
            resultMappings.addAll(ResultMapUtils.createResultMapping(configuration, tableFieldInfo.isTableId(), tableFieldInfo.getFieldInfo(), tableFieldInfo.getColumnName(), tableFieldInfo.getTableFieldAnnotation().jdbcType(), tableFieldInfo.getTableFieldAnnotation().typeHandler()));
        }
        return Collections.unmodifiableList(resultMappings);
    }

    private static List<ResultMapping> getNormalResultMappings(MybatisConfiguration configuration, Class clazz) {
        List<Field> list = FieldUtil.getFields(clazz);
        ArrayList resultMappings = new ArrayList(list.size() * 4);
        list.forEach(field -> {
            Class typeHandler = UnknownTypeHandler.class;
            FieldInfo fieldInfo = new FieldInfo(clazz, (Field)field);
            if (field.isAnnotationPresent(TypeHandler.class)) {
                TypeHandler th = field.getAnnotation(TypeHandler.class);
                typeHandler = th.value();
            }
            JdbcType jdbcType = JdbcType.UNDEFINED;
            if (field.isAnnotationPresent(ResultField.class)) {
                ResultField resultField = field.getAnnotation(ResultField.class);
                jdbcType = resultField.jdbcType();
                typeHandler = resultField.typeHandler();
                if (!resultField.value().isEmpty()) {
                    resultMappings.add(configuration.buildResultMapping(false, fieldInfo, resultField.value(), jdbcType, typeHandler));
                    resultMappings.add(configuration.buildResultMapping(false, fieldInfo, field.getName(), jdbcType, typeHandler));
                    resultMappings.add(configuration.buildResultMapping(false, fieldInfo, SqlUtil.getAsName((Class)clazz, (Field)field), jdbcType, typeHandler));
                    return;
                }
            }
            resultMappings.add(configuration.buildResultMapping(false, fieldInfo, field.getName(), jdbcType, typeHandler));
            resultMappings.add(configuration.buildResultMapping(false, fieldInfo, PropertyNamer.camelToUnderscore((String)field.getName()), jdbcType, typeHandler));
            resultMappings.add(configuration.buildResultMapping(false, fieldInfo, SqlUtil.getAsName((Class)clazz, (Field)field), jdbcType, typeHandler));
        });
        return Collections.unmodifiableList(resultMappings);
    }

    private static List<ResultMapping> getResultEntityResultMappings(MybatisConfiguration configuration, Class clazz) {
        ResultInfo resultInfo = ResultInfos.get(clazz);
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        resultMappings.addAll(ResultMapUtils.createResultMapping(configuration, resultInfo.getResultFieldInfos()));
        resultMappings.addAll(ResultMapUtils.createNestedResultMapping(configuration, resultInfo.getNestedResultInfos(), "mp-" + MybatisIdUtil.convertIdPath(clazz.getName())));
        return Collections.unmodifiableList(resultMappings);
    }

    private static List<ResultMapping> createNestedResultMapping(MybatisConfiguration configuration, List<NestedResultInfo> nestedResultInfos, String path) {
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        nestedResultInfos.forEach(item -> resultMappings.add(ResultMapUtils.createNestedResultMapping(configuration, item, path)));
        return resultMappings;
    }

    private static ResultMapping createNestedResultMapping(MybatisConfiguration configuration, NestedResultInfo nestedResultInfo, String parentPath) {
        List<Class<?>> types;
        String nestedPath = parentPath + "-" + nestedResultInfo.getField().getName();
        ArrayList<ResultMapping> nestedMappings = new ArrayList<ResultMapping>();
        nestedMappings.addAll(ResultMapUtils.createResultMapping(configuration, nestedResultInfo.getResultFieldInfos()));
        nestedMappings.addAll(ResultMapUtils.createNestedResultMapping(configuration, nestedResultInfo.getNestedResultInfos(), nestedPath));
        Class<?> targetType = nestedResultInfo.getFieldInfo().getTypeClass();
        if (Collection.class.isAssignableFrom(targetType) && Objects.nonNull(types = GenericUtil.getGeneric(nestedResultInfo.getField().getGenericType())) && !types.isEmpty()) {
            targetType = types.get(0);
        }
        ResultMap resultMap = new ResultMap.Builder((Configuration)configuration, nestedPath, targetType, nestedMappings, Boolean.valueOf(false)).build();
        configuration.addResultMap(resultMap);
        return new ResultMapping.Builder((Configuration)configuration, nestedResultInfo.getField().getName()).javaType(nestedResultInfo.getFieldInfo().getTypeClass()).jdbcType(JdbcType.UNDEFINED).nestedResultMapId(nestedPath).build();
    }

    private static List<ResultMapping> createResultMapping(MybatisConfiguration configuration, List<ResultFieldInfo> resultFieldInfos) {
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        resultFieldInfos.stream().filter(ResultFieldInfo::isResultMapping).forEach(item -> {
            if (item instanceof ResultTableFieldInfo) {
                ResultTableFieldInfo resultTableFieldInfo = (ResultTableFieldInfo)item;
                resultMappings.addAll(ResultMapUtils.createResultMapping(configuration, resultTableFieldInfo));
            } else {
                resultMappings.addAll(ResultMapUtils.createResultMapping(configuration, item));
            }
        });
        return resultMappings;
    }

    private static List<ResultMapping> createResultMapping(MybatisConfiguration configuration, ResultFieldInfo resultFieldInfo) {
        ArrayList<ResultMapping> resultMappingList = new ArrayList<ResultMapping>(5);
        ResultMapping resultMapping = configuration.buildResultMapping(false, resultFieldInfo.getFieldInfo(), resultFieldInfo.getMappingColumnName(), resultFieldInfo.getJdbcType(), resultFieldInfo.getTypeHandler());
        resultMappingList.add(resultMapping);
        if (!SqlUtil.isAsName(resultFieldInfo.getFieldInfo().getClazz(), (Field)resultFieldInfo.getFieldInfo().getField(), (String)resultFieldInfo.getMappingColumnName())) {
            String asName = SqlUtil.getAsName(resultFieldInfo.getFieldInfo().getClazz(), (Field)resultFieldInfo.getFieldInfo().getField());
            resultMapping = configuration.buildResultMapping(false, resultFieldInfo.getFieldInfo(), asName, resultFieldInfo.getJdbcType(), resultFieldInfo.getTypeHandler());
            resultMappingList.add(resultMapping);
        }
        return resultMappingList;
    }

    private static List<ResultMapping> createResultMapping(MybatisConfiguration configuration, ResultTableFieldInfo resultTableFieldInfo) {
        return ResultMapUtils.createResultMapping(configuration, resultTableFieldInfo.getTableFieldInfo().isTableId(), resultTableFieldInfo.getFieldInfo(), resultTableFieldInfo.getMappingColumnName(), resultTableFieldInfo.getJdbcType(), resultTableFieldInfo.getTypeHandler());
    }
}

