/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.mappers.utils;

import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.core.mybatis.mapper.BasicMapper;
import cn.xbatis.core.mybatis.mapper.context.EntityUpdateContext;
import cn.xbatis.core.mybatis.mapper.context.strategy.UpdateStrategy;
import cn.xbatis.core.mybatis.mapper.mappers.utils.DefaultValueContextUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public final class UpdateMethodUtil {
    public static <T> UpdateStrategy<T> createUpdateStrategy() {
        return new UpdateStrategy();
    }

    public static <T> int update(BasicMapper basicMapper, T entity, UpdateStrategy<T> updateStrategy) {
        return UpdateMethodUtil.update(basicMapper, Tables.get(entity.getClass()), entity, updateStrategy);
    }

    public static <T> int update(BasicMapper basicMapper, TableInfo tableInfo, T entity) {
        return UpdateMethodUtil.update(basicMapper, tableInfo, entity, UpdateMethodUtil.createUpdateStrategy());
    }

    public static <T> int update(BasicMapper basicMapper, TableInfo tableInfo, T entity, UpdateStrategy<T> updateStrategy) {
        return UpdateMethodUtil.update(basicMapper, tableInfo, entity, updateStrategy, new HashMap<String, Object>());
    }

    public static <T> int update(BasicMapper basicMapper, TableInfo tableInfo, T entity, UpdateStrategy<T> updateStrategy, Map<String, Object> defaultValueContext) {
        return basicMapper.$update(new EntityUpdateContext<T>(tableInfo, entity, updateStrategy, defaultValueContext));
    }

    public static <T> int update(BasicMapper basicMapper, TableInfo tableInfo, T entity, Consumer<UpdateStrategy<T>> updateStrategy) {
        UpdateStrategy<T> strategy = UpdateMethodUtil.createUpdateStrategy();
        updateStrategy.accept(strategy);
        return UpdateMethodUtil.update(basicMapper, tableInfo, entity, strategy);
    }

    public static <T> int update(BasicMapper basicMapper, T entity, Consumer<UpdateStrategy<T>> updateStrategy) {
        return UpdateMethodUtil.update(basicMapper, Tables.get(entity.getClass()), entity, updateStrategy);
    }

    public static <T> int updateList(BasicMapper basicMapper, Collection<T> list, Consumer<UpdateStrategy<T>> updateStrategy) {
        UpdateStrategy<T> strategy = UpdateMethodUtil.createUpdateStrategy();
        updateStrategy.accept(strategy);
        return UpdateMethodUtil.updateList(basicMapper, list, strategy);
    }

    public static <T> int updateList(BasicMapper basicMapper, Collection<T> list, UpdateStrategy<T> updateStrategy) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return 0;
        }
        TableInfo tableInfo = Tables.get(list.stream().findFirst().get().getClass());
        return UpdateMethodUtil.updateList(basicMapper, tableInfo, list, updateStrategy);
    }

    public static <T> int updateList(BasicMapper basicMapper, TableInfo tableInfo, Collection<T> list, Consumer<UpdateStrategy<T>> updateStrategy) {
        UpdateStrategy<T> strategy = UpdateMethodUtil.createUpdateStrategy();
        updateStrategy.accept(strategy);
        return UpdateMethodUtil.updateList(basicMapper, tableInfo, list, strategy);
    }

    public static <T> int updateList(BasicMapper basicMapper, TableInfo tableInfo, Collection<T> list, UpdateStrategy<T> updateStrategy) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return 0;
        }
        int cnt = 0;
        HashMap<String, Object> defaultValueContext = new HashMap<String, Object>();
        for (T entity : list) {
            cnt += UpdateMethodUtil.update(basicMapper, tableInfo, entity, updateStrategy, defaultValueContext);
            DefaultValueContextUtil.removeNonSameLevelData(defaultValueContext);
        }
        return cnt;
    }
}

