/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.mappers.utils;

import cn.xbatis.core.db.reflect.ModelInfo;
import cn.xbatis.core.db.reflect.Models;
import cn.xbatis.core.logicDelete.LogicDeleteUtil;
import cn.xbatis.core.mybatis.mapper.BasicMapper;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveOrUpdateStrategy;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveStrategy;
import cn.xbatis.core.mybatis.mapper.context.strategy.UpdateStrategy;
import cn.xbatis.core.mybatis.mapper.mappers.utils.DefaultValueContextUtil;
import cn.xbatis.core.mybatis.mapper.mappers.utils.SaveModelMethodUtil;
import cn.xbatis.core.mybatis.mapper.mappers.utils.UpdateModelMethodUtil;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.Query;
import cn.xbatis.core.sql.util.WhereUtil;
import cn.xbatis.core.util.ModelInfoUtil;
import cn.xbatis.core.util.TableInfoUtil;
import cn.xbatis.db.Model;
import db.sql.api.Cmd;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.struct.Where;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SaveOrUpdateModelMethodUtil {
    public static <M extends Model<T>, T> int saveOrUpdate(BasicMapper basicMapper, M model, SaveOrUpdateStrategy saveOrUpdateStrategy) {
        return SaveOrUpdateModelMethodUtil.saveOrUpdate(basicMapper, model, saveOrUpdateStrategy, new HashMap<String, Object>());
    }

    public static <M extends Model<T>, T> int saveOrUpdate(BasicMapper basicMapper, M model, SaveOrUpdateStrategy saveOrUpdateStrategy, Map<String, Object> defaultValueContext) {
        return SaveOrUpdateModelMethodUtil.saveOrUpdate(basicMapper, Models.get(model.getClass()), model, saveOrUpdateStrategy, defaultValueContext);
    }

    public static <M extends Model<T>, T> int saveOrUpdate(BasicMapper basicMapper, ModelInfo modelInfo, M model, SaveOrUpdateStrategy saveOrUpdateStrategy, Map<String, Object> defaultValueContext) {
        boolean checkById = true;
        if (saveOrUpdateStrategy.getOn() != null) {
            checkById = false;
        }
        Where checkWhere = WhereUtil.create(modelInfo.getTableInfo());
        if (checkById) {
            Object id;
            if (modelInfo.getIdFieldInfos().isEmpty()) {
                throw new RuntimeException(modelInfo.getType().getName() + " has no id");
            }
            try {
                id = modelInfo.getIdFieldInfos().get(0).getReadFieldInvoker().invoke(model, null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (Objects.isNull(id)) {
                SaveStrategy saveStrategy = new SaveStrategy().allFieldSave(saveOrUpdateStrategy.isAllField()).forceFields(saveOrUpdateStrategy.getForceFields());
                return SaveModelMethodUtil.save(basicMapper, model, saveStrategy, defaultValueContext);
            }
            WhereUtil.appendIdWhereWithModel(checkWhere, modelInfo, model);
        } else {
            saveOrUpdateStrategy.getOn().accept(checkWhere);
        }
        Query query = new Query(checkWhere);
        ((MybatisCmdFactory)query.$()).cacheTableInfo(modelInfo.getTableInfo());
        Table table = query.$(modelInfo.getEntityType());
        if (saveOrUpdateStrategy.isIgnoreLogicDeleteWhenCheck()) {
            LogicDeleteUtil.execute(false, () -> ((Query)query.from((IDataset)table)).returnType(modelInfo.getEntityType()));
        } else {
            ((Query)query.from((IDataset)table)).returnType(modelInfo.getEntityType());
        }
        for (String c : modelInfo.getTableInfo().getIdColumnNames()) {
            query.select((Cmd)table.$(c));
        }
        Object obj = basicMapper.get(query);
        if (obj == null) {
            SaveStrategy saveStrategy = new SaveStrategy().allFieldSave(saveOrUpdateStrategy.isAllField()).forceFields(saveOrUpdateStrategy.getForceFields());
            return SaveModelMethodUtil.save(basicMapper, model, saveStrategy, defaultValueContext);
        }
        UpdateStrategy updateStrategy = new UpdateStrategy();
        if (modelInfo.getIdFieldInfos().isEmpty()) {
            updateStrategy.on(query.$where());
        } else {
            modelInfo.getIdFieldInfos().stream().forEach(item -> ModelInfoUtil.setValue(item, model, TableInfoUtil.getEntityFieldValue(item.getTableFieldInfo(), obj)));
        }
        updateStrategy.allFieldUpdate(saveOrUpdateStrategy.isAllField());
        updateStrategy.forceFields(saveOrUpdateStrategy.getForceFields());
        return UpdateModelMethodUtil.update(basicMapper, model, updateStrategy, defaultValueContext);
    }

    public static <M extends Model> int saveOrUpdate(BasicMapper basicMapper, Collection<M> list, SaveOrUpdateStrategy saveOrUpdateStrategy) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return 0;
        }
        Model first = (Model)list.stream().findFirst().get();
        ModelInfo modelInfo = Models.get(first.getClass());
        int cnt = 0;
        HashMap<String, Object> defaultValueContext = new HashMap<String, Object>();
        for (Model model : list) {
            cnt += SaveOrUpdateModelMethodUtil.saveOrUpdate(basicMapper, modelInfo, model, saveOrUpdateStrategy, defaultValueContext);
            DefaultValueContextUtil.removeNonSameLevelData(defaultValueContext);
        }
        return cnt;
    }
}

