/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.mappers.utils;

import cn.xbatis.core.XbatisGlobalConfig;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.logicDelete.LogicDeleteUtil;
import cn.xbatis.core.mybatis.mapper.BasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.utils.DefaultValueContextUtil;
import cn.xbatis.core.sql.executor.Delete;
import cn.xbatis.core.sql.executor.MpTable;
import cn.xbatis.core.sql.util.WhereUtil;
import db.sql.api.DbType;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.cmd.basic.SQL1;
import db.sql.api.impl.cmd.struct.Where;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public final class DeleteMethodUtil {
    public static int deleteById(BasicMapper basicMapper, TableInfo tableInfo, Serializable id) {
        return DeleteMethodUtil.delete(basicMapper, tableInfo, WhereUtil.create(tableInfo, w -> WhereUtil.appendIdWhere(w, tableInfo, id)));
    }

    public static int deleteByIds(BasicMapper basicMapper, TableInfo tableInfo, Serializable[] ids) {
        return DeleteMethodUtil.delete(basicMapper, tableInfo, WhereUtil.create(tableInfo, w -> WhereUtil.appendIdsWhere(w, tableInfo, ids)));
    }

    public static <ID extends Serializable> int deleteByIds(BasicMapper basicMapper, TableInfo tableInfo, Collection<ID> ids) {
        return DeleteMethodUtil.delete(basicMapper, tableInfo, WhereUtil.create(tableInfo, w -> WhereUtil.appendIdsWhere(w, tableInfo, ids)));
    }

    public static <E> int delete(BasicMapper basicMapper, TableInfo tableInfo, E entity) {
        return DeleteMethodUtil.delete(basicMapper, tableInfo, entity, new HashMap<String, Object>());
    }

    public static <E> int delete(BasicMapper basicMapper, TableInfo tableInfo, E entity, Map<String, Object> defaultValueContext) {
        if (Objects.isNull(entity)) {
            return 0;
        }
        if (tableInfo.getIdFieldInfos().isEmpty()) {
            throw new RuntimeException(tableInfo.getType().getName() + " has no id");
        }
        if (tableInfo.getType() != entity.getClass()) {
            throw new IllegalArgumentException();
        }
        return DeleteMethodUtil.delete(basicMapper, tableInfo, WhereUtil.create(tableInfo, w -> {
            WhereUtil.appendIdWhereWithEntity(w, tableInfo, entity);
            WhereUtil.appendVersionWhere(w, tableInfo, entity);
        }), defaultValueContext);
    }

    public static <E> int delete(BasicMapper basicMapper, TableInfo tableInfo, Collection<E> list) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return 0;
        }
        int cnt = 0;
        HashMap<String, Object> defaultValueContext = new HashMap<String, Object>();
        for (E entity : list) {
            cnt += DeleteMethodUtil.delete(basicMapper, tableInfo, entity, defaultValueContext);
            DefaultValueContextUtil.removeNonSameLevelData(defaultValueContext);
        }
        return cnt;
    }

    public static int delete(BasicMapper basicMapper, TableInfo tableInfo, Consumer<Where> consumer) {
        return DeleteMethodUtil.delete(basicMapper, tableInfo, WhereUtil.create(tableInfo, consumer));
    }

    public static int delete(BasicMapper basicMapper, TableInfo tableInfo, Where where) {
        return DeleteMethodUtil.delete(basicMapper, tableInfo, where, new HashMap<String, Object>());
    }

    public static int delete(BasicMapper basicMapper, TableInfo tableInfo, Where where, Map<String, Object> defaultValueContext) {
        if (!where.hasContent()) {
            throw new RuntimeException("delete has no where condition content ");
        }
        if (LogicDeleteUtil.isNeedLogicDelete(tableInfo)) {
            return LogicDeleteUtil.logicDelete(basicMapper, tableInfo, where, defaultValueContext);
        }
        Delete delete = new Delete(where);
        delete.delete(new Class[]{tableInfo.getType()});
        delete.from(new Class[]{tableInfo.getType()});
        return basicMapper.delete(delete);
    }

    public static int deleteAll(BasicMapper basicMapper, TableInfo tableInfo) {
        return DeleteMethodUtil.delete(basicMapper, tableInfo, (Where where) -> {
            Where cfr_ignored_0 = (Where)where.eq((Object)SQL1.INSTANCE, (Object)1);
        });
    }

    public static int truncate(BasicMapper basicMapper, TableInfo tableInfo) {
        MpTable mpTable = new MpTable(tableInfo);
        XbatisGlobalConfig.getSQLListeners().stream().filter(Objects::nonNull).forEach(listener -> listener.onTruncate((IDataset)mpTable));
        return (Integer)basicMapper.dbAdapt(selectorCall -> selectorCall.when(DbType.DB2, dbType -> basicMapper.execute("TRUNCATE TABLE " + mpTable.getName(dbType) + " IMMEDIATE", new Object[0])).when(DbType.SQLITE, dbType -> {
            int cnt = basicMapper.execute("DELETE FROM " + mpTable.getName(dbType), new Object[0]);
            basicMapper.execute("UPDATE SQLITE_SEQUENCE SET SEQ = 0 WHERE name = '" + mpTable.getName() + "'", new Object[0]);
            return cnt;
        }).otherwise(dbType -> basicMapper.execute("TRUNCATE TABLE " + mpTable.getName(dbType), new Object[0])));
    }
}

