/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.ModelFieldInfo;
import cn.xbatis.core.db.reflect.ModelInfo;
import cn.xbatis.core.db.reflect.OnListenerUtil;
import cn.xbatis.core.mybatis.mapper.context.CmdParamUtil;
import cn.xbatis.core.mybatis.mapper.context.strategy.UpdateStrategy;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.Update;
import cn.xbatis.core.sql.util.WhereUtil;
import cn.xbatis.core.tenant.TenantUtil;
import cn.xbatis.core.util.DefaultValueUtil;
import cn.xbatis.core.util.ModelInfoUtil;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.Model;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.NULL;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.tookit.LambdaUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ModelUpdateCreateUtil {
    public static <M extends Model<T>, T> void initUpdateValue(ModelInfo modelInfo, ModelFieldInfo modelFieldInfo, M insertData, Set<String> forceFields, Map<String, Object> defaultValueContext) {
        if (modelFieldInfo.getTableFieldInfo().isTenantId()) {
            Object value;
            boolean isForceUpdate;
            boolean bl = isForceUpdate = Objects.nonNull(forceFields) && forceFields.contains(modelFieldInfo.getField().getName());
            if (isForceUpdate && Objects.isNull(value = modelFieldInfo.getValue(insertData))) {
                value = TenantUtil.getTenantId();
                if (Objects.isNull(value)) {
                    return;
                }
                TenantUtil.setTenantId(modelFieldInfo, insertData, value);
            }
            return;
        }
        if (!"".equals(modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation().updateDefaultValue())) {
            Object value = modelFieldInfo.getValue(insertData);
            if (value != null) {
                return;
            }
            DefaultValueUtil.getAndSetUpdateDefaultValue(insertData, modelFieldInfo, defaultValueContext);
            return;
        }
        throw new RuntimeException("\u672a\u5904\u7406");
    }

    private static <M extends Model<T>, T> void doBefore(ModelInfo modelInfo, M insertData, Set<String> forceFields, Map<String, Object> defaultValueContext) {
        for (ModelFieldInfo modelFieldInfo : modelInfo.getUpdateDoBeforeModelFieldInfos()) {
            ModelUpdateCreateUtil.initUpdateValue(modelInfo, modelFieldInfo, insertData, forceFields, defaultValueContext);
        }
        OnListenerUtil.notifyUpdate(insertData);
    }

    public static <M extends Model<T>, T> Update create(ModelInfo modelInfo, M model, UpdateStrategy<M> updateStrategy, Map<String, Object> defaultValueContext) {
        Where where = updateStrategy.getWhere();
        if (where == null) {
            where = WhereUtil.create(modelInfo.getTableInfo());
        }
        Update update = new Update(where);
        if (updateStrategy.getOn() != null) {
            updateStrategy.getOn().accept(where);
        }
        boolean hasPutConditionBefore = where.hasContent();
        MybatisCmdFactory $ = (MybatisCmdFactory)update.$();
        Table table = (Table)$.table(modelInfo.getEntityType());
        boolean hasIdCondition = false;
        Set forceFields = LambdaUtil.getFieldNames(updateStrategy.getForceFields());
        ModelUpdateCreateUtil.doBefore(modelInfo, model, forceFields, defaultValueContext);
        for (ModelFieldInfo modelFieldInfo : modelInfo.getModelFieldInfos()) {
            boolean isForceUpdate = Objects.nonNull(forceFields) && forceFields.contains(modelFieldInfo.getField().getName());
            Object value = modelFieldInfo.getValue(model);
            if (modelFieldInfo.getTableFieldInfo().isTableId()) {
                if (!Objects.nonNull(value)) continue;
                if (update.$where().hasContent()) {
                    update.$where().extConditionChain().eq($.field(table, modelFieldInfo.getTableFieldInfo().getColumnName()), (Object)Methods.cmd((Object)value));
                } else {
                    update.$where().conditionChain().eq($.field(table, modelFieldInfo.getTableFieldInfo().getColumnName()), (Object)Methods.cmd((Object)value));
                }
                hasIdCondition = true;
                continue;
            }
            if (modelFieldInfo.getTableFieldInfo().isTenantId()) {
                if (!isForceUpdate || Objects.isNull(value)) {
                    continue;
                }
            } else if (modelFieldInfo.getTableFieldInfo().isVersion()) {
                if (Objects.isNull(value)) continue;
                Object version = TypeConvertUtil.convert(Long.valueOf(1L) + 1L, modelFieldInfo.getField().getType());
                update.set((TableField)$.field(table, modelFieldInfo.getTableFieldInfo().getColumnName()), Methods.cmd(version));
                update.$where().extConditionChain().eq($.field(table, modelFieldInfo.getTableFieldInfo().getColumnName()), (Object)Methods.cmd((Object)value));
                ModelInfoUtil.setValue(modelFieldInfo, model, version);
                continue;
            }
            if (!isForceUpdate && !modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation().update()) continue;
            if ((isForceUpdate || updateStrategy.isAllFieldUpdate()) && Objects.isNull(value)) {
                update.set((TableField)$.field(table, modelFieldInfo.getTableFieldInfo().getColumnName()), NULL.NULL);
                continue;
            }
            if (!Objects.nonNull(value)) continue;
            update.set((TableField)$.field(table, modelFieldInfo.getTableFieldInfo().getColumnName()), CmdParamUtil.build(modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation(), value));
        }
        if (!hasIdCondition && !hasPutConditionBefore) {
            throw new RuntimeException("update has no where condition content ");
        }
        update.update((ITable[])new Table[]{table});
        return update;
    }
}

