/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.ModelFieldInfo;
import cn.xbatis.core.db.reflect.ModelInfo;
import cn.xbatis.core.db.reflect.OnListenerUtil;
import cn.xbatis.core.db.reflect.TableIds;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.incrementer.IdentifierGenerator;
import cn.xbatis.core.incrementer.IdentifierGeneratorFactory;
import cn.xbatis.core.mybatis.mapper.context.CmdParamUtil;
import cn.xbatis.core.mybatis.mapper.context.IdUtil;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveStrategy;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.BaseInsert;
import cn.xbatis.core.sql.executor.Insert;
import cn.xbatis.core.sql.executor.MpTable;
import cn.xbatis.core.sql.executor.MpTableField;
import cn.xbatis.core.tenant.TenantUtil;
import cn.xbatis.core.util.DefaultValueUtil;
import cn.xbatis.core.util.ModelInfoUtil;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.IdAutoType;
import cn.xbatis.db.Model;
import cn.xbatis.db.annotations.TableId;
import db.sql.api.DbType;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.impl.cmd.basic.NULL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class ModelInsertCreateUtil {
    public static <M extends Model<T>, T> void initInsertValue(ModelInfo modelInfo, ModelFieldInfo modelFieldInfo, M insertData, DbType dbType, Map<String, Object> defaultValueContext) {
        if (modelFieldInfo.getTableFieldInfo().isTableId()) {
            TableId tableId;
            Object value = modelFieldInfo.getValue(insertData);
            if (value != null && IdUtil.isIdExists(insertData, modelFieldInfo)) {
                return;
            }
            if (!IdUtil.isIdValueExists(value) && (tableId = TableIds.get(modelInfo.getEntityType(), dbType)).value() == IdAutoType.GENERATOR) {
                IdentifierGenerator identifierGenerator = IdentifierGeneratorFactory.getIdentifierGenerator(tableId.generatorName());
                Object id = identifierGenerator.nextId(modelInfo.getTableInfo().getType());
                IdUtil.setId(insertData, modelFieldInfo, id);
            }
            return;
        }
        if (modelFieldInfo.getTableFieldInfo().isLogicDelete()) {
            Object value = modelFieldInfo.getValue(insertData);
            if (value != null) {
                return;
            }
            value = modelFieldInfo.getTableFieldInfo().getLogicDeleteInitValue();
            if (value != null) {
                ModelInfoUtil.setValue(modelFieldInfo, insertData, value);
            } else if (!"".equals(modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation().defaultValue())) {
                DefaultValueUtil.getAndSetDefaultValue(insertData, modelFieldInfo, defaultValueContext);
            }
            return;
        }
        if (!"".equals(modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation().defaultValue())) {
            Object value = modelFieldInfo.getValue(insertData);
            if (value != null) {
                return;
            }
            DefaultValueUtil.getAndSetDefaultValue(insertData, modelFieldInfo, defaultValueContext);
            return;
        }
        if (modelFieldInfo.getTableFieldInfo().isVersion()) {
            Object value = modelFieldInfo.getValue(insertData);
            if (value != null) {
                return;
            }
            value = TypeConvertUtil.convert(1, modelFieldInfo.getField().getType());
            ModelInfoUtil.setValue(modelFieldInfo, insertData, value);
            return;
        }
        throw new RuntimeException("\u672a\u5904\u7406");
    }

    private static <M extends Model<T>, T> void doBefore(ModelInfo modelInfo, M insertData, SaveStrategy<T> saveStrategy, DbType dbType, Map<String, Object> defaultValueContext) {
        TenantUtil.setTenantId(insertData);
        for (ModelFieldInfo modelFieldInfo : modelInfo.getInsertDoBeforeModelFieldInfos()) {
            ModelInsertCreateUtil.initInsertValue(modelInfo, modelFieldInfo, insertData, dbType, defaultValueContext);
        }
        OnListenerUtil.notifyInsert(insertData);
    }

    public static <M extends Model<T>, T> BaseInsert<?> create(BaseInsert<?> insert, ModelInfo modelInfo, M insertData, SaveStrategy<T> saveStrategy, DbType dbType, Map<String, Object> defaultValueContext) {
        ModelInsertCreateUtil.doBefore(modelInfo, insertData, saveStrategy, dbType, defaultValueContext);
        insert = insert == null ? new Insert() : insert;
        TableInfo tableInfo = modelInfo.getTableInfo();
        ((MybatisCmdFactory)insert.$()).cacheTableInfo(tableInfo);
        MpTable table = (MpTable)((MybatisCmdFactory)insert.$()).table(tableInfo.getType());
        insert.insert((ITable)table);
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < modelInfo.getFieldSize(); ++i) {
            ModelFieldInfo modelFieldInfo = modelInfo.getModelFieldInfos().get(i);
            boolean isNeedInsert = false;
            Object value = modelFieldInfo.getValue(insertData);
            if (Objects.nonNull(value)) {
                isNeedInsert = true;
            }
            if (!isNeedInsert && (saveStrategy.isAllFieldSave() || Objects.nonNull(saveStrategy.getForceFields()) && saveStrategy.getForceFields().contains(modelFieldInfo.getField().getName()))) {
                isNeedInsert = true;
                if (modelFieldInfo.getTableFieldInfo().isTableId() && value == null) {
                    isNeedInsert = false;
                }
            }
            if (!isNeedInsert) continue;
            insert.fields(new MpTableField(table, modelFieldInfo.getTableFieldInfo()));
            if (Objects.isNull(value)) {
                values.add(NULL.NULL);
                continue;
            }
            values.add(CmdParamUtil.build(modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation(), value));
        }
        insert.values(values);
        if (saveStrategy.getConflictAction() != null) {
            insert.conflictKeys(saveStrategy.getConflictKeys());
            insert.conflictKeys(saveStrategy.getConflictColumns());
            insert.onConflict(saveStrategy.getConflictAction());
        }
        return insert;
    }
}

