/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.ModelInfo;
import cn.xbatis.core.db.reflect.Models;
import cn.xbatis.core.mybatis.mapper.context.IdUtil;
import cn.xbatis.core.mybatis.mapper.context.ModelInsertCreateUtil;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdInsertContext;
import cn.xbatis.core.mybatis.mapper.context.SetIdMethod;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveStrategy;
import cn.xbatis.core.sql.executor.BaseInsert;
import cn.xbatis.db.Model;
import db.sql.api.DbType;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;

public class ModelInsertContext<T extends Model>
extends SQLCmdInsertContext<BaseInsert, T>
implements SetIdMethod {
    private final BaseInsert<?> insert;
    private final T model;
    private final ModelInfo modelInfo;
    private final SaveStrategy strategy;
    private final boolean idHasValue;
    private final Map<String, Object> defaultValueContext;

    public ModelInsertContext(BaseInsert<?> insert, T model, SaveStrategy strategy, Map<String, Object> defaultValueContext) {
        this.insert = insert;
        this.model = model;
        this.strategy = strategy;
        this.modelInfo = Models.get(model.getClass());
        this.entityType = this.modelInfo.getEntityType();
        this.idHasValue = IdUtil.isIdExists(model, this.modelInfo.getIdFieldInfo());
        this.defaultValueContext = defaultValueContext;
    }

    @Override
    public void init(DbType dbType) {
        super.init(dbType);
        if (Objects.isNull(this.execution)) {
            this.execution = this.createCmd(dbType);
        }
    }

    private BaseInsert createCmd(DbType dbType) {
        return ModelInsertCreateUtil.create(this.insert, this.modelInfo, this.model, this.strategy, dbType, this.defaultValueContext);
    }

    @Override
    public void setId(Object id, int index) {
        IdUtil.setId(this.model, this.modelInfo.getSingleIdFieldInfo(true), id);
    }

    @Override
    public boolean idHasValue() {
        return this.idHasValue;
    }

    @Override
    public int getInsertSize() {
        return 1;
    }

    @Override
    public Object getInsertData(int index) {
        return this.model;
    }

    @Override
    public TypeHandler<?> getIdTypeHandler(Configuration configuration) {
        TypeHandler<?> typeHandler;
        if (Objects.nonNull(this.modelInfo.getIdFieldInfo()) && Objects.isNull(typeHandler = this.modelInfo.getIdFieldInfo().getTableFieldInfo().getTypeHandler())) {
            return configuration.getTypeHandlerRegistry().getTypeHandler(this.modelInfo.getIdFieldInfo().getTableFieldInfo().getFieldInfo().getTypeClass());
        }
        return null;
    }

    @Override
    public String getIdColumnName() {
        return this.modelInfo.getTableInfo().getIdFieldInfo().getColumnName();
    }
}

