/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.OnListenerUtil;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.mybatis.mapper.context.CmdParamUtil;
import cn.xbatis.core.mybatis.mapper.context.strategy.UpdateStrategy;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.Update;
import cn.xbatis.core.sql.util.WhereUtil;
import cn.xbatis.core.tenant.TenantUtil;
import cn.xbatis.core.util.DefaultValueUtil;
import cn.xbatis.core.util.TableInfoUtil;
import cn.xbatis.core.util.TypeConvertUtil;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.NULL;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.tookit.LambdaUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class EntityUpdateCreateUtil {
    public static void initUpdateValue(TableInfo tableInfo, TableFieldInfo tableFieldInfo, Object insertData, Set<String> forceFields, Map<String, Object> defaultValueContext) {
        if (tableFieldInfo.isTenantId()) {
            boolean isForceUpdate = Objects.nonNull(forceFields) && forceFields.contains(tableFieldInfo.getField().getName());
            Object value = tableFieldInfo.getValue(insertData);
            if (isForceUpdate && Objects.isNull(value)) {
                value = TenantUtil.getTenantId();
                if (Objects.isNull(value)) {
                    return;
                }
                TenantUtil.setTenantId(tableFieldInfo, insertData, value);
            }
            return;
        }
        if (!"".equals(tableFieldInfo.getTableFieldAnnotation().updateDefaultValue())) {
            Object value = tableFieldInfo.getValue(insertData);
            if (value != null) {
                return;
            }
            DefaultValueUtil.getAndSetUpdateDefaultValue(insertData, tableFieldInfo, defaultValueContext);
            return;
        }
        throw new RuntimeException("\u672a\u5904\u7406");
    }

    private static void doBefore(TableInfo tableInfo, Object insertData, Set<String> forceFields, Map<String, Object> defaultValueContext) {
        for (TableFieldInfo tableFieldInfo : tableInfo.getUpdateDoBeforeTableFieldInfos()) {
            EntityUpdateCreateUtil.initUpdateValue(tableInfo, tableFieldInfo, insertData, forceFields, defaultValueContext);
        }
        OnListenerUtil.notifyUpdate(insertData);
    }

    public static Update create(TableInfo tableInfo, Object entity, UpdateStrategy<?> updateStrategy, Map<String, Object> defaultValueContext) {
        Where where = updateStrategy.getWhere();
        if (where == null) {
            where = WhereUtil.create(tableInfo);
        }
        Update update = new Update(where);
        if (updateStrategy.getOn() != null) {
            updateStrategy.getOn().accept(where);
        }
        boolean hasPutConditionBefore = where.hasContent();
        MybatisCmdFactory $ = (MybatisCmdFactory)update.$();
        Table table = (Table)$.table(entity.getClass());
        boolean hasIdCondition = false;
        Set forceFields = LambdaUtil.getFieldNames(updateStrategy.getForceFields());
        EntityUpdateCreateUtil.doBefore(tableInfo, entity, forceFields, defaultValueContext);
        for (TableFieldInfo tableFieldInfo : tableInfo.getTableFieldInfos()) {
            boolean isForceUpdate;
            Object value = tableFieldInfo.getValue(entity);
            boolean bl = isForceUpdate = Objects.nonNull(forceFields) && forceFields.contains(tableFieldInfo.getField().getName());
            if (tableFieldInfo.isTableId()) {
                if (!Objects.nonNull(value)) continue;
                if (update.$where().hasContent()) {
                    update.$where().extConditionChain().eq($.field(table, tableFieldInfo.getColumnName()), (Object)Methods.cmd((Object)value));
                } else {
                    update.$where().conditionChain().eq($.field(table, tableFieldInfo.getColumnName()), (Object)Methods.cmd((Object)value));
                }
                hasIdCondition = true;
                continue;
            }
            if (tableFieldInfo.isTenantId()) {
                if (!isForceUpdate || Objects.isNull(value)) {
                    continue;
                }
            } else if (tableFieldInfo.isVersion()) {
                if (Objects.isNull(value)) continue;
                Object version = TypeConvertUtil.convert(Long.valueOf(1L) + 1L, tableFieldInfo.getField().getType());
                update.set((TableField)$.field(table, tableFieldInfo.getColumnName()), Methods.cmd(version));
                update.$where().extConditionChain().eq($.field(table, tableFieldInfo.getColumnName()), (Object)Methods.cmd((Object)value));
                TableInfoUtil.setValue(tableFieldInfo, entity, version);
                continue;
            }
            if (!isForceUpdate && !tableFieldInfo.getTableFieldAnnotation().update()) continue;
            if ((isForceUpdate || updateStrategy.isAllFieldUpdate()) && Objects.isNull(value)) {
                update.set((TableField)$.field(table, tableFieldInfo.getColumnName()), NULL.NULL);
                continue;
            }
            if (!Objects.nonNull(value)) continue;
            cn.xbatis.db.annotations.TableField tableField = tableFieldInfo.getTableFieldAnnotation();
            update.set((TableField)$.field(table, tableFieldInfo.getColumnName()), CmdParamUtil.build(tableField, value));
        }
        if (!hasIdCondition && !hasPutConditionBefore) {
            throw new RuntimeException("update has no where condition content ");
        }
        update.update((ITable[])new Table[]{table});
        return update;
    }
}

