/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.OnListenerUtil;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableIds;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.incrementer.IdentifierGenerator;
import cn.xbatis.core.incrementer.IdentifierGeneratorFactory;
import cn.xbatis.core.mybatis.mapper.context.CmdParamUtil;
import cn.xbatis.core.mybatis.mapper.context.IdUtil;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveStrategy;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.BaseInsert;
import cn.xbatis.core.sql.executor.Insert;
import cn.xbatis.core.sql.executor.MpTable;
import cn.xbatis.core.sql.executor.MpTableField;
import cn.xbatis.core.tenant.TenantUtil;
import cn.xbatis.core.util.DefaultValueUtil;
import cn.xbatis.core.util.TableInfoUtil;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.IdAutoType;
import cn.xbatis.db.annotations.TableId;
import db.sql.api.DbType;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.impl.cmd.basic.NULL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class EntityInsertCreateUtil {
    public static void initInsertValue(TableInfo tableInfo, TableFieldInfo tableFieldInfo, Object insertData, DbType dbType, Map<String, Object> defaultValueContext) {
        if (tableFieldInfo.isTableId()) {
            TableId tableId;
            Object value = tableFieldInfo.getValue(insertData);
            if (value != null && IdUtil.isIdExists(insertData, tableFieldInfo)) {
                return;
            }
            if (!IdUtil.isIdValueExists(value) && (tableId = TableIds.get(insertData.getClass(), dbType)).value() == IdAutoType.GENERATOR) {
                IdentifierGenerator identifierGenerator = IdentifierGeneratorFactory.getIdentifierGenerator(tableId.generatorName());
                Object id = identifierGenerator.nextId(tableInfo.getType());
                IdUtil.setId(insertData, tableFieldInfo, id);
            }
            return;
        }
        if (tableFieldInfo.isLogicDelete()) {
            Object value = tableFieldInfo.getValue(insertData);
            if (value != null) {
                return;
            }
            value = tableFieldInfo.getLogicDeleteInitValue();
            if (value != null) {
                TableInfoUtil.setValue(tableFieldInfo, insertData, value);
            } else if (!"".equals(tableFieldInfo.getTableFieldAnnotation().defaultValue())) {
                DefaultValueUtil.getAndSetDefaultValue(insertData, tableFieldInfo, defaultValueContext);
            }
            return;
        }
        if (!"".equals(tableFieldInfo.getTableFieldAnnotation().defaultValue())) {
            Object value = tableFieldInfo.getValue(insertData);
            if (value != null) {
                return;
            }
            DefaultValueUtil.getAndSetDefaultValue(insertData, tableFieldInfo, defaultValueContext);
            return;
        }
        if (tableFieldInfo.isVersion()) {
            Object value = tableFieldInfo.getValue(insertData);
            if (value != null) {
                return;
            }
            value = TypeConvertUtil.convert(1, tableFieldInfo.getField().getType());
            TableInfoUtil.setValue(tableFieldInfo, insertData, value);
            return;
        }
        throw new RuntimeException("\u672a\u5904\u7406");
    }

    private static <T> void doBefore(TableInfo tableInfo, T insertData, SaveStrategy<T> saveStrategy, DbType dbType, Map<String, Object> defaultValueContext) {
        TenantUtil.setTenantId(tableInfo, insertData);
        for (TableFieldInfo tableFieldInfo : tableInfo.getInsertDoBeforeTableFieldInfos()) {
            EntityInsertCreateUtil.initInsertValue(tableInfo, tableFieldInfo, insertData, dbType, defaultValueContext);
        }
        OnListenerUtil.notifyInsert(insertData);
    }

    public static <T> BaseInsert<?> create(BaseInsert<?> insert, TableInfo tableInfo, T insertData, SaveStrategy<T> saveStrategy, DbType dbType, Map<String, Object> defaultValueContext) {
        EntityInsertCreateUtil.doBefore(tableInfo, insertData, saveStrategy, dbType, defaultValueContext);
        insert = insert == null ? new Insert() : insert;
        ((MybatisCmdFactory)insert.$()).cacheTableInfo(tableInfo);
        MpTable table = (MpTable)((MybatisCmdFactory)insert.$()).table(tableInfo.getType());
        insert.insert((ITable)table);
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < tableInfo.getFieldSize(); ++i) {
            TableFieldInfo tableFieldInfo = tableInfo.getTableFieldInfos().get(i);
            if (!tableFieldInfo.getTableFieldAnnotation().insert()) continue;
            boolean isNeedInsert = false;
            Object value = tableFieldInfo.getValue(insertData);
            if (Objects.nonNull(value)) {
                isNeedInsert = true;
            }
            if (!isNeedInsert && (saveStrategy.isAllFieldSave() || Objects.nonNull(saveStrategy.getForceFields()) && saveStrategy.getForceFields().contains(tableFieldInfo.getField().getName()))) {
                isNeedInsert = true;
                if (tableFieldInfo.isTableId() && value == null) {
                    isNeedInsert = false;
                }
            }
            if (!isNeedInsert) continue;
            insert.fields(new MpTableField(table, tableFieldInfo));
            if (Objects.isNull(value)) {
                values.add(NULL.NULL);
                continue;
            }
            values.add(CmdParamUtil.build(tableFieldInfo.getTableFieldAnnotation(), value));
        }
        insert.values(values);
        if (saveStrategy.getConflictAction() != null) {
            insert.conflictKeys(saveStrategy.getConflictKeys());
            insert.conflictKeys(saveStrategy.getConflictColumns());
            insert.onConflict(saveStrategy.getConflictAction());
        }
        return insert;
    }
}

