/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.OnListenerUtil;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableIds;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.mybatis.mapper.context.CmdParamUtil;
import cn.xbatis.core.mybatis.mapper.context.EntityInsertCreateUtil;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveBatchStrategy;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.BaseInsert;
import cn.xbatis.core.sql.executor.Insert;
import cn.xbatis.core.tenant.TenantUtil;
import cn.xbatis.core.util.TableInfoUtil;
import cn.xbatis.db.IdAutoType;
import cn.xbatis.db.annotations.TableField;
import cn.xbatis.db.annotations.TableId;
import db.sql.api.DbType;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.impl.cmd.basic.NULL;
import db.sql.api.impl.cmd.basic.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EntityBatchInsertCreateUtil {
    private static Set<String> getAllSaveField(TableInfo tableInfo, DbType dbType, Object entity) {
        HashSet<String> saveFieldSet = new HashSet<String>();
        for (TableFieldInfo tableFieldInfo : tableInfo.getTableFieldInfos()) {
            if (!tableFieldInfo.getTableFieldAnnotation().insert()) continue;
            if (tableFieldInfo.isTableId()) {
                TableId tableId = TableInfoUtil.getTableIdAnnotation(tableFieldInfo.getField(), dbType);
                Objects.requireNonNull(tableId.value());
                if (tableId.value() == IdAutoType.AUTO) {
                    Object id;
                    try {
                        id = tableFieldInfo.getReadFieldInvoker().invoke(entity, null);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    if (Objects.isNull(id)) continue;
                }
            }
            saveFieldSet.add(tableFieldInfo.getField().getName());
        }
        return saveFieldSet;
    }

    private static <T> void doBefore(TableInfo tableInfo, List<TableFieldInfo> saveFieldInfoSet, T insertData, DbType dbType, Map<String, Object> defaultValueContext) {
        TenantUtil.setTenantId(tableInfo, insertData);
        for (TableFieldInfo tableFieldInfo : tableInfo.getInsertDoBeforeTableFieldInfos()) {
            if (!saveFieldInfoSet.contains(tableFieldInfo)) continue;
            EntityInsertCreateUtil.initInsertValue(tableInfo, tableFieldInfo, insertData, dbType, defaultValueContext);
        }
        OnListenerUtil.notifyInsert(insertData);
    }

    public static <T> BaseInsert<?> create(BaseInsert<?> insert, TableInfo tableInfo, T[] insertData, SaveBatchStrategy<T> saveBatchStrategy, DbType dbType, boolean useBatchExecutor, Map<String, Object> defaultValueContext) {
        insert = insert == null ? new Insert() : insert;
        ((MybatisCmdFactory)insert.$()).cacheTableInfo(tableInfo);
        Table table = (Table)((MybatisCmdFactory)insert.$()).table(tableInfo.getType());
        insert.insert((ITable)table);
        Set<String> saveFieldSet = saveBatchStrategy.getForceFields() == null || saveBatchStrategy.getForceFields().isEmpty() ? EntityBatchInsertCreateUtil.getAllSaveField(tableInfo, dbType, insertData[0]) : saveBatchStrategy.getForceFields();
        List<TableFieldInfo> saveFieldInfoSet = saveFieldSet.stream().map(tableInfo::getFieldInfo).collect(Collectors.toList());
        if (!tableInfo.getIdFieldInfos().isEmpty()) {
            tableInfo.getIdFieldInfos().forEach(idFieldInfo -> {
                TableId tableId = TableInfoUtil.getTableIdAnnotation(idFieldInfo.getField(), dbType);
                if (!(tableId.value() != IdAutoType.GENERATOR && tableId.value() != IdAutoType.SQL || saveFieldInfoSet.contains(idFieldInfo))) {
                    saveFieldInfoSet.add((TableFieldInfo)idFieldInfo);
                }
            });
        }
        if (Objects.nonNull(tableInfo.getTenantIdFieldInfo()) && !saveFieldInfoSet.contains(tableInfo.getTenantIdFieldInfo())) {
            saveFieldInfoSet.add(tableInfo.getTenantIdFieldInfo());
        }
        if (Objects.nonNull(tableInfo.getVersionFieldInfo()) && !saveFieldInfoSet.contains(tableInfo.getVersionFieldInfo())) {
            saveFieldInfoSet.add(tableInfo.getVersionFieldInfo());
        }
        if (Objects.nonNull(tableInfo.getLogicDeleteFieldInfo()) && !saveFieldInfoSet.contains(tableInfo.getLogicDeleteFieldInfo())) {
            saveFieldInfoSet.add(tableInfo.getLogicDeleteFieldInfo());
        }
        for (TableFieldInfo tableFieldInfo : saveFieldInfoSet) {
            insert.fields(((MybatisCmdFactory)insert.$()).field(table, tableFieldInfo.getColumnName(), tableFieldInfo.isTableId()));
        }
        int fieldSize = saveFieldInfoSet.size();
        boolean containId = false;
        for (T t : insertData) {
            EntityBatchInsertCreateUtil.doBefore(tableInfo, saveFieldInfoSet, t, dbType, defaultValueContext);
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < fieldSize; ++i) {
                TableFieldInfo tableFieldInfo = saveFieldInfoSet.get(i);
                Object value = tableFieldInfo.getValue(t);
                if (tableFieldInfo.isTableId()) {
                    containId = true;
                }
                TableField tableField = tableFieldInfo.getTableFieldAnnotation();
                if (Objects.isNull(value)) {
                    values.add(NULL.NULL);
                    continue;
                }
                values.add(CmdParamUtil.build(tableField, value));
            }
            insert.values(values);
        }
        if (dbType == DbType.SQL_SERVER && insert.getInsertValues().getValues().size() > 0) {
            TableId tableId = TableIds.get(tableInfo.getType(), dbType);
            if (!useBatchExecutor && !containId && Objects.nonNull(tableId) && tableId.value() == IdAutoType.AUTO) {
                insert.getInsertFields().setOutput("OUTPUT INSERTED." + tableInfo.getIdFieldInfo().getColumnName());
            }
        }
        if (saveBatchStrategy.getConflictAction() != null) {
            insert.conflictKeys(saveBatchStrategy.getConflictKeys());
            insert.conflictKeys(saveBatchStrategy.getConflictColumns());
            insert.onConflict(saveBatchStrategy.getConflictAction());
        }
        return insert;
    }
}

