/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.mybatis.mapper.context.EntityBatchInsertCreateUtil;
import cn.xbatis.core.mybatis.mapper.context.IdUtil;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdInsertContext;
import cn.xbatis.core.mybatis.mapper.context.SetIdMethod;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveBatchStrategy;
import cn.xbatis.core.sql.executor.BaseInsert;
import db.sql.api.DbType;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;

public class EntityBatchInsertContext<T>
extends SQLCmdInsertContext<BaseInsert, T[]>
implements SetIdMethod {
    private final SaveBatchStrategy<T> saveBatchStrategy;
    private final TableInfo tableInfo;
    private final boolean idHasValue;
    private final BaseInsert<?> insert;
    private final Map<String, Object> defaultValueContext;

    public EntityBatchInsertContext(BaseInsert<?> insert, TableInfo tableInfo, Collection<T> list, SaveBatchStrategy<T> saveBatchStrategy, Map<String, Object> defaultValueContext) {
        super(list.toArray(new Object[0]));
        this.insert = insert;
        this.tableInfo = tableInfo;
        this.saveBatchStrategy = saveBatchStrategy;
        this.entityType = tableInfo.getType();
        this.idHasValue = IdUtil.isIdExists(((Object[])this.getInsertData())[0], tableInfo.getIdFieldInfo());
        this.defaultValueContext = defaultValueContext;
    }

    @Override
    public void init(DbType dbType) {
        super.init(dbType);
        if (Objects.isNull(this.execution)) {
            this.execution = EntityBatchInsertCreateUtil.create(this.insert, this.tableInfo, (Object[])this.getInsertData(), this.saveBatchStrategy, dbType, this.useBatchExecutor, this.defaultValueContext);
        }
    }

    @Override
    public void setId(Object id, int index) {
        IdUtil.setId(((Object[])this.getInsertData())[index], this.tableInfo.getSingleIdFieldInfo(true), id);
    }

    @Override
    public boolean idHasValue() {
        return this.idHasValue;
    }

    @Override
    public int getInsertSize() {
        return ((Object[])this.getInsertData()).length;
    }

    @Override
    public Object getInsertData(int index) {
        return ((Object[])this.getInsertData())[index];
    }

    @Override
    public TypeHandler<?> getIdTypeHandler(Configuration configuration) {
        TypeHandler<?> typeHandler;
        if (Objects.nonNull(this.tableInfo.getIdFieldInfo()) && Objects.isNull(typeHandler = this.tableInfo.getIdFieldInfo().getTypeHandler())) {
            return configuration.getTypeHandlerRegistry().getTypeHandler(this.tableInfo.getIdFieldInfo().getFieldInfo().getTypeClass());
        }
        return null;
    }

    @Override
    public String getIdColumnName() {
        return this.tableInfo.getIdFieldInfo().getColumnName();
    }
}

