/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.executor.resultset;

import cn.xbatis.core.db.reflect.CreatedEventInfo;
import cn.xbatis.core.db.reflect.FetchInfo;
import cn.xbatis.core.db.reflect.PutEnumValueInfo;
import cn.xbatis.core.db.reflect.PutValueInfo;
import cn.xbatis.core.db.reflect.ResultInfo;
import cn.xbatis.core.db.reflect.ResultInfos;
import cn.xbatis.core.mybatis.executor.BasicMapperThreadLocalUtil;
import cn.xbatis.core.mybatis.executor.resultset.DefaultResultSetHandler;
import cn.xbatis.core.mybatis.executor.resultset.FetchObject;
import cn.xbatis.core.mybatis.executor.resultset.FetchTargetValue;
import cn.xbatis.core.mybatis.mapper.BasicMapper;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdCountFromQueryContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdQueryContext;
import cn.xbatis.core.sql.executor.BaseQuery;
import cn.xbatis.core.sql.executor.Query;
import cn.xbatis.core.util.CreatedEventUtil;
import cn.xbatis.core.util.PutEnumValueUtil;
import cn.xbatis.core.util.PutValueUtil;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.annotations.ResultEntity;
import db.sql.api.Cmd;
import db.sql.api.cmd.basic.IOrderByDirection;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.OrderByDirection;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.impl.tookit.OptimizeOptions;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetWrapper;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.util.MapUtil;

public class MybatisDefaultResultSetHandler
extends DefaultResultSetHandler {
    private final Map<FetchInfo, Map<Object, List<Object>>> singleFetchCache = new HashMap<FetchInfo, Map<Object, List<Object>>>();
    private final Map<Method, Map> createdEventContextMap = new HashMap<Method, Map>();
    private final String FETCH_MATCH_COLUMN = "m$v";
    private final List<Object> rowValues = new ArrayList<Object>();
    private BasicMapper basicMapper;
    private Map<FetchInfo, List<FetchObject>> needFetchValuesMap;
    private Map<Class, List<FetchInfo>> fetchInfosMap;
    private Map<String, Consumer<Where>> fetchFilters;
    private Map<String, Boolean> fetchEnables;
    private Consumer onRowEvent;
    private Class<?> returnType;
    private Map<Class, List<PutEnumValueInfo>> putEnumValueInfoMap;
    private Map<Class, List<PutValueInfo>> putValueInfoMap;
    private Map<String, Object> putValueSessionCache;
    private Map<Class, List<CreatedEventInfo>> createdEventInfos;
    private Map<String, Object> defaultValueContext = new HashMap<String, Object>();
    private Boolean hasFetchMatchColumn;

    public MybatisDefaultResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler<?> resultHandler, BoundSql boundSql, RowBounds rowBounds) {
        super(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds);
        if (mappedStatement.getResultMaps().size() == 1) {
            Class returnType = ((ResultMap)mappedStatement.getResultMaps().get(0)).getType();
            if (!(boundSql.getParameterObject() instanceof SQLCmdCountFromQueryContext) && returnType.isAnnotationPresent(ResultEntity.class)) {
                ResultInfo resultInfo = ResultInfos.get(returnType);
                this.fetchInfosMap = resultInfo.getFetchInfoMap();
                if (Objects.nonNull(this.fetchInfosMap) && !this.fetchInfosMap.isEmpty()) {
                    this.needFetchValuesMap = new HashMap<FetchInfo, List<FetchObject>>();
                    this.basicMapper = BasicMapperThreadLocalUtil.get();
                }
                if (boundSql.getParameterObject() instanceof SQLCmdQueryContext) {
                    BaseQuery baseQuery = (BaseQuery)((SQLCmdQueryContext)boundSql.getParameterObject()).getExecution();
                    this.fetchFilters = baseQuery.getFetchFilters();
                    this.fetchEnables = baseQuery.getFetchEnables();
                    this.putEnumValueInfoMap = resultInfo.getPutEnumValueInfoMap();
                    this.putValueInfoMap = resultInfo.getPutValueInfoMap();
                    this.createdEventInfos = resultInfo.getCreatedEventInfos();
                }
            }
            if (boundSql.getParameterObject() instanceof SQLCmdQueryContext) {
                BaseQuery baseQuery = (BaseQuery)((SQLCmdQueryContext)boundSql.getParameterObject()).getExecution();
                this.returnType = baseQuery.getReturnType();
                if (!(boundSql.getParameterObject() instanceof SQLCmdCountFromQueryContext)) {
                    this.onRowEvent = baseQuery.getOnRowEvent();
                }
            }
        }
    }

    private void clearObjects() {
        this.singleFetchCache.clear();
        this.createdEventContextMap.clear();
        this.defaultValueContext.clear();
        if (this.putValueSessionCache != null) {
            this.putValueSessionCache.clear();
        }
        this.rowValues.clear();
        this.singleFetchCache.entrySet().stream().forEach(i -> {
            if (i.getValue() == null) {
                return;
            }
            ((Map)i.getValue()).entrySet().stream().forEach(i2 -> {
                if (i2.getValue() != null) {
                    ((List)i2.getValue()).clear();
                }
            });
            ((Map)i.getValue()).clear();
        });
        if (this.needFetchValuesMap != null) {
            this.needFetchValuesMap.entrySet().stream().forEach(i -> {
                if (i.getValue() != null) {
                    ((List)i.getValue()).clear();
                }
            });
            this.needFetchValuesMap.clear();
        }
    }

    private void onRowEvent(Object rowValue) {
        if (Objects.isNull(this.onRowEvent)) {
            return;
        }
        if (Objects.isNull(rowValue)) {
            return;
        }
        if (!rowValue.getClass().isAssignableFrom(this.returnType)) {
            return;
        }
        this.onRowEvent.accept(rowValue);
    }

    private void putEnumValue(Object rowValue, ResultSet resultSet) {
        if (Objects.isNull(this.putEnumValueInfoMap)) {
            return;
        }
        if (Objects.isNull(rowValue)) {
            return;
        }
        List<PutEnumValueInfo> putEnumValueInfos = this.putEnumValueInfoMap.get(rowValue.getClass());
        if (Objects.isNull(putEnumValueInfos) || putEnumValueInfos.isEmpty()) {
            return;
        }
        putEnumValueInfos.forEach(item -> {
            Object codeValue;
            try {
                TypeHandler typeHandler = item.getValueTypeHandler();
                if (Objects.isNull(typeHandler)) {
                    typeHandler = this.mappedStatement.getConfiguration().getTypeHandlerRegistry().getTypeHandler(item.getValueType());
                }
                codeValue = Objects.nonNull(typeHandler) ? typeHandler.getResult(resultSet, item.getValueColumn()) : resultSet.getObject(item.getValueColumn());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            Object targetValue = PutEnumValueUtil.getEnumValue(codeValue, item);
            if (Objects.isNull(targetValue)) {
                return;
            }
            try {
                item.getWriteFieldInvoker().invoke(rowValue, new Object[]{targetValue});
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Map<String, Object> getPutValueSessionCache() {
        if (this.putValueSessionCache == null) {
            this.putValueSessionCache = new HashMap<String, Object>();
        }
        return this.putValueSessionCache;
    }

    private void putValue(Object rowValue, ResultSet resultSet) {
        if (Objects.isNull(this.putValueInfoMap)) {
            return;
        }
        if (Objects.isNull(rowValue)) {
            return;
        }
        List<PutValueInfo> putValueInfos = this.putValueInfoMap.get(rowValue.getClass());
        if (Objects.isNull(putValueInfos) || putValueInfos.isEmpty()) {
            return;
        }
        putValueInfos.forEach(item -> {
            Object[] values = new Object[item.getValuesColumn().length];
            for (int i = 0; i < item.getValuesColumn().length; ++i) {
                try {
                    TypeHandler typeHandler = item.getValuesTypeHandler()[i];
                    if (Objects.isNull(typeHandler)) {
                        typeHandler = this.mappedStatement.getConfiguration().getTypeHandlerRegistry().getTypeHandler(item.getValueTypes()[i]);
                    }
                    if (Objects.nonNull(typeHandler)) {
                        values[i] = typeHandler.getResult(resultSet, item.getValuesColumn()[i]);
                        continue;
                    }
                    values[i] = resultSet.getObject(item.getValuesColumn()[i]);
                    continue;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            Object targetValue = PutValueUtil.getPutValue(values, item, this.getPutValueSessionCache());
            if (Objects.isNull(targetValue)) {
                return;
            }
            try {
                item.getWriteFieldInvoker().invoke(rowValue, new Object[]{targetValue});
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void onCreatedEvent(Object rowValue) {
        if (Objects.isNull(this.createdEventInfos) || this.createdEventInfos.isEmpty()) {
            return;
        }
        if (Objects.isNull(rowValue)) {
            return;
        }
        List<CreatedEventInfo> list = this.createdEventInfos.get(rowValue.getClass());
        if (Objects.isNull(list) || list.isEmpty()) {
            return;
        }
        Map context = null;
        for (CreatedEventInfo item : this.createdEventInfos.get(rowValue.getClass())) {
            context = item.isHasContextParam() && Objects.isNull(context) ? this.createdEventContextMap.computeIfAbsent(item.getMethod(), k -> new HashMap()) : null;
            CreatedEventUtil.onCreated(rowValue, context, item);
        }
    }

    @Override
    protected Object getRowValue(ResultSetWrapper rsw, ResultMap resultMap, String columnPrefix) throws SQLException {
        Object rowValue = super.getRowValue(rsw, resultMap, columnPrefix);
        List<FetchInfo> fetchInfos = this.getFetchInfo(this.returnType);
        boolean hasFetch = false;
        if (!Objects.isNull(fetchInfos) && !fetchInfos.isEmpty()) {
            hasFetch = true;
            rowValue = this.loadFetchValue(resultMap.getType(), fetchInfos, rowValue, rsw.getResultSet());
        }
        this.putEnumValue(rowValue, rsw.getResultSet());
        this.putValue(rowValue, rsw.getResultSet());
        if (!hasFetch) {
            this.onCreatedEvent(rowValue);
            this.onRowEvent(rowValue);
        } else {
            this.rowValues.add(rowValue);
        }
        if (rowValue != null) {
            if (this.hasFetchMatchColumn == null) {
                List columns = rsw.getColumnNames();
                this.hasFetchMatchColumn = columns.contains("m$v");
                if (!this.hasFetchMatchColumn.booleanValue()) {
                    this.hasFetchMatchColumn = columns.contains("m$v".toUpperCase());
                }
            }
            if (this.hasFetchMatchColumn.booleanValue()) {
                return new FetchTargetValue(rsw.getResultSet().getString("m$v"), rowValue);
            }
        }
        return rowValue;
    }

    @Override
    protected Object getRowValue(ResultSetWrapper rsw, ResultMap resultMap, CacheKey combinedKey, String columnPrefix, Object partialObject) throws SQLException {
        Object rowValue = super.getRowValue(rsw, resultMap, combinedKey, columnPrefix, partialObject);
        List<FetchInfo> fetchInfos = this.getFetchInfo(resultMap.getType());
        boolean hasFetch = false;
        if (!Objects.isNull(fetchInfos) && !fetchInfos.isEmpty()) {
            hasFetch = true;
            rowValue = this.loadFetchValue(resultMap.getType(), fetchInfos, rowValue, rsw.getResultSet());
        }
        this.putEnumValue(rowValue, rsw.getResultSet());
        this.putValue(rowValue, rsw.getResultSet());
        if (!hasFetch) {
            this.onCreatedEvent(rowValue);
            this.onRowEvent(rowValue);
        } else {
            this.rowValues.add(rowValue);
        }
        return rowValue;
    }

    @Override
    public void handleRowValues(ResultSetWrapper rsw, ResultMap resultMap, ResultHandler<?> resultHandler, RowBounds rowBounds, ResultMapping parentMapping) throws SQLException {
        super.handleRowValues(rsw, resultMap, resultHandler, rowBounds, parentMapping);
        this.handleFetch();
        for (Object obj : this.rowValues) {
            this.onCreatedEvent(obj);
            this.onRowEvent(obj);
        }
        this.clearObjects();
    }

    private List<FetchInfo> getFetchInfo(Class<?> resultType) {
        if (Objects.isNull(this.fetchInfosMap) || this.fetchInfosMap.isEmpty()) {
            return null;
        }
        return this.fetchInfosMap.get(resultType);
    }

    public Object loadFetchValue(Class<?> resultType, List<FetchInfo> fetchInfos, Object rowValue, ResultSet resultSet) {
        for (FetchInfo fetchInfo : fetchInfos) {
            Object onValue;
            String fetchKey = fetchInfo.getFieldInfo().getClazz().getName() + "." + fetchInfo.getFieldInfo().getField().getName();
            Boolean fetchEnable = Objects.isNull(this.fetchEnables) || !this.fetchEnables.containsKey(fetchKey) || this.fetchEnables.get(fetchKey) != false;
            if (!(fetchEnable = Boolean.valueOf(fetchEnable == null || fetchEnable != false)).booleanValue()) {
                if (fetchInfo.getFieldInfo().getTypeClass().isAssignableFrom(Collections.class)) {
                    try {
                        fetchInfo.getWriteFieldInvoker().invoke(rowValue, new Object[]{new ArrayList()});
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                return rowValue;
            }
            try {
                if (Objects.nonNull(fetchInfo.getValueTypeHandler())) {
                    onValue = fetchInfo.getValueTypeHandler().getResult(resultSet, fetchInfo.getValueColumn());
                } else {
                    onValue = resultSet.getObject(fetchInfo.getValueColumn());
                    if (!(onValue instanceof Number)) {
                        onValue = resultSet.getString(fetchInfo.getValueColumn());
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            if (Objects.isNull(onValue)) continue;
            if (Objects.isNull(rowValue)) {
                rowValue = this.configuration.getObjectFactory().create(resultType);
            }
            if (fetchInfo.isSingleFetch()) {
                this.singleConditionFetch(rowValue, fetchInfo, onValue);
                continue;
            }
            ((List)MapUtil.computeIfAbsent(this.needFetchValuesMap, (Object)fetchInfo, key -> new ArrayList())).add(new FetchObject(onValue, onValue.toString(), rowValue));
        }
        return rowValue;
    }

    public void handleFetch() {
        if (Objects.isNull(this.needFetchValuesMap) || this.needFetchValuesMap.isEmpty()) {
            return;
        }
        for (Map.Entry<FetchInfo, List<FetchObject>> entry : this.needFetchValuesMap.entrySet()) {
            FetchInfo fetchInfo = entry.getKey();
            List<FetchObject> fetchObjects = entry.getValue();
            List<Object> list = this.fetchData(fetchInfo, fetchObjects.stream().map(item -> item.getSourceKey()).distinct().collect(Collectors.toList()), false);
            this.fillFetchData(fetchInfo, fetchObjects, list);
        }
    }

    private List<Object> fetchData(FetchInfo fetchInfo, Query<?> query, List<Serializable> queryValueList) {
        if (queryValueList.isEmpty()) {
            return Collections.emptyList();
        }
        if (Objects.nonNull(query.$where().getConditionChain())) {
            query.$where().getConditionChain().getConditionBlocks().clear();
        }
        if (queryValueList.size() == 1) {
            if (fetchInfo.getFetch().limit() > 0) {
                query.limit(fetchInfo.getFetch().limit());
            }
            if (fetchInfo.getMiddleTableInfo() != null) {
                query.eq(query.$(fetchInfo.getFetch().middle()).$(fetchInfo.getMiddleSourceTableFieldInfo().getColumnName()), queryValueList.get(0));
            } else {
                query.eq(query.$(fetchInfo.getFetch().target()).$(fetchInfo.getTargetTableFieldInfo().getColumnName()), queryValueList.get(0));
            }
        } else if (fetchInfo.getMiddleTableInfo() != null) {
            query.in(query.$(fetchInfo.getFetch().middle()).$(fetchInfo.getMiddleSourceTableFieldInfo().getColumnName()), queryValueList);
        } else {
            query.in(query.$(fetchInfo.getFetch().target()).$(fetchInfo.getTargetTableFieldInfo().getColumnName()), queryValueList);
        }
        String fetchKey = fetchInfo.getFieldInfo().getClazz().getName() + "." + fetchInfo.getFieldInfo().getField().getName();
        boolean hasFetchFilter = !Objects.isNull(this.fetchFilters) && this.fetchFilters.containsKey(fetchKey);
        query.setFetchEnables(this.fetchEnables);
        query.setFetchFilters(this.fetchFilters);
        if (hasFetchFilter) {
            this.fetchFilters.get(fetchKey).accept(query.$where());
        }
        query.optimizeOptions(OptimizeOptions::disableAll);
        if (Objects.nonNull(fetchInfo.getOtherConditions()) && !"".equals(fetchInfo.getOtherConditions())) {
            query.and(q -> Methods.cTpl((String)fetchInfo.getOtherConditions(), (Object[])new Object[0]));
        }
        return this.basicMapper.list(query);
    }

    public void fillFetchData(FetchInfo fetchInfo, List<FetchObject> values, List<?> fetchData) {
        if (Objects.isNull(fetchData) || fetchData.isEmpty()) {
            values.stream().forEach(i -> this.setValue(i.getValue(), null, fetchInfo));
            return;
        }
        HashMap map = new HashMap();
        fetchData.forEach(item -> {
            List conditionValues;
            Object eqValue;
            try {
                eqValue = fetchInfo.isSourceTargetMatchFieldInReturnType() ? fetchInfo.getSourceTargetMatchFieldGetter().invoke(item, null) : (fetchInfo.getMiddleTableInfo() != null || !fetchInfo.isSourceTargetMatchFieldInReturnType() ? ((FetchTargetValue)item).getMatchFieldValue() : item);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (Objects.nonNull(eqValue) && !(conditionValues = (List)MapUtil.computeIfAbsent((Map)map, (Object)eqValue.toString(), key -> new ArrayList())).contains(item)) {
                conditionValues.add(item);
            }
        });
        values.forEach(item -> {
            List matchValues = (List)map.get(item.getMatchKey());
            this.setValue(item.getValue(), matchValues, fetchInfo);
        });
    }

    protected List<Object> fetchData(FetchInfo fetchInfo, List conditionList, boolean single) {
        if (conditionList.isEmpty()) {
            return Collections.emptyList();
        }
        int batchSize = 100;
        ArrayList<Serializable> queryValueList = new ArrayList<Serializable>(100);
        Query<?> query = Query.create().returnType(fetchInfo.getReturnType());
        if (fetchInfo.getMiddleTableInfo() != null) {
            query.from(new Class[]{fetchInfo.getFetch().middle()});
            query.innerJoin(fetchInfo.getFetch().middle(), fetchInfo.getFetch().target(), on -> {
                on.getJoin().getMainTable().as("middle");
                on.getJoin().getSecondTable().as("target");
                on.eq((Object)query.$(fetchInfo.getFetch().middle(), fetchInfo.getFetch().middleTargetProperty()), (Object)query.$(fetchInfo.getFetch().target(), fetchInfo.getFetch().targetProperty()));
            });
        } else {
            query.from(new Class[]{fetchInfo.getTargetTableInfo().getType()});
        }
        if (fetchInfo.getTargetSelect() == null) {
            query.select(fetchInfo.getReturnType());
        } else {
            query.select(fetchInfo.getTargetSelect());
        }
        if (!single) {
            if (fetchInfo.getMiddleTableInfo() != null) {
                query.select((Cmd)query.$(fetchInfo.getFetch().middle(), fetchInfo.getFetch().middleSourceProperty()).as("m$v"));
            } else if (!fetchInfo.isSourceTargetMatchFieldInReturnType()) {
                query.select((Cmd)query.$(fetchInfo.getFetch().target(), fetchInfo.getFetch().targetProperty()).as("m$v"));
            }
        }
        if (fetchInfo.isGroup()) {
            if (fetchInfo.getMiddleTableInfo() != null) {
                query.groupBy((Cmd)query.$(fetchInfo.getFetch().middle(), fetchInfo.getFetch().middleSourceProperty()));
            } else {
                query.groupBy((Cmd)query.$(fetchInfo.getFetch().target(), fetchInfo.getFetch().targetProperty()));
            }
        }
        if (Objects.nonNull(fetchInfo.getTargetOrderBy()) && !"".equals(fetchInfo.getTargetOrderBy())) {
            query.orderBy((IOrderByDirection)OrderByDirection.NONE, fetchInfo.getTargetOrderBy());
        }
        ArrayList<Object> resultList = new ArrayList<Object>(conditionList.size());
        int size = conditionList.size();
        for (int i = 0; i < size; ++i) {
            queryValueList.add((Serializable)conditionList.get(i));
            if (i == 0 || i % batchSize != 0) continue;
            resultList.addAll(this.fetchData(fetchInfo, query, queryValueList));
        }
        if (size == 1 || (size - 1) % batchSize != 0) {
            List<Object> list = this.fetchData(fetchInfo, query, queryValueList);
            if (resultList.isEmpty()) {
                return list;
            }
            resultList.addAll(list);
        }
        return resultList;
    }

    public void singleConditionFetch(Object rowValue, FetchInfo fetchInfo, Object onValue) {
        List list = Objects.nonNull(onValue) ? this.singleFetchCache.computeIfAbsent(fetchInfo, key -> new HashMap()).computeIfAbsent(onValue, key2 -> this.fetchData(fetchInfo, Collections.singletonList(onValue), true)) : new ArrayList();
        this.setValue(rowValue, list, fetchInfo);
    }

    protected void setValue(Object rowValue, List<?> matchValues, FetchInfo fetchInfo) {
        if (fetchInfo.isMultiple()) {
            ArrayList arrayList = matchValues = Objects.isNull(matchValues) ? new ArrayList() : matchValues;
            if (matchValues.isEmpty()) {
                fetchInfo.setValue(rowValue, matchValues, this.defaultValueContext);
                return;
            }
            if (matchValues.get(0) instanceof FetchTargetValue) {
                matchValues = matchValues.stream().map(m -> TypeConvertUtil.convert(m.getTarget(), fetchInfo.getFieldInfo().getFinalClass())).collect(Collectors.toList());
            }
            fetchInfo.setValue(rowValue, matchValues, this.defaultValueContext);
        } else {
            if (Objects.isNull(matchValues) || matchValues.isEmpty()) {
                fetchInfo.setValue(rowValue, null, this.defaultValueContext);
                return;
            }
            if (matchValues.size() > 1 && !fetchInfo.getFetch().multiValueErrorIgnore()) {
                throw new TooManyResultsException("fetch action found more than 1 record");
            }
            Object value = matchValues.get(0) instanceof FetchTargetValue ? matchValues.stream().map(m -> TypeConvertUtil.convert(m.getTarget(), fetchInfo.getFieldInfo().getFinalClass())).findFirst().get() : matchValues.get(0);
            fetchInfo.setValue(rowValue, value, this.defaultValueContext);
        }
    }
}

