/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.executor.keygen;

import cn.xbatis.core.mybatis.mapper.context.BaseSQLCmdContext;
import cn.xbatis.core.mybatis.mapper.context.SetIdMethod;
import db.sql.api.DbType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;

public class MybatisJdbc3KeyGenerator
extends Jdbc3KeyGenerator {
    public static final MybatisJdbc3KeyGenerator INSTANCE = new MybatisJdbc3KeyGenerator();

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        if (parameter instanceof SetIdMethod) {
            Throwable throwable;
            ResultSet rs;
            String[] keyProperties = ms.getKeyProperties();
            if (keyProperties == null || keyProperties.length == 0) {
                return;
            }
            SetIdMethod setIdMethod = (SetIdMethod)parameter;
            if (setIdMethod.idHasValue()) {
                return;
            }
            Configuration configuration = ms.getConfiguration();
            BaseSQLCmdContext insertContext = (BaseSQLCmdContext)parameter;
            if (setIdMethod.getInsertSize() > 1 && insertContext.getDbType() == DbType.SQL_SERVER && insertContext.sql(insertContext.getDbType()).contains("OUTPUT INSERTED")) {
                try {
                    rs = stmt.getResultSet();
                    throwable = null;
                    try {
                        if (rs != null) {
                            this.assignSQLServerKeys(configuration, rs, setIdMethod);
                            return;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new ExecutorException("Error getting generated key or setting result to parameter object. Cause: " + e, (Throwable)e);
                }
            }
            try {
                rs = stmt.getGeneratedKeys();
                throwable = null;
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    if (rsmd.getColumnCount() < keyProperties.length) {
                    } else {
                        this.assignKeys(configuration, rs, setIdMethod);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ExecutorException("Error getting generated key or setting result to parameter object. Cause: " + e, (Throwable)e);
            }
            return;
        }
        super.processAfter(executor, ms, stmt, parameter);
    }

    private void assignSQLServerKeys(Configuration configuration, ResultSet rs, SetIdMethod setIdMethod) throws SQLException {
        int i;
        int insertSize = setIdMethod.getInsertSize();
        ArrayList<Object> genIds = new ArrayList<Object>(insertSize);
        for (i = 0; i < insertSize; ++i) {
            if (!rs.next()) {
                return;
            }
            genIds.add(setIdMethod.getIdTypeHandler(configuration).getResult(rs, setIdMethod.getIdColumnName()));
        }
        if (genIds.size() == insertSize) {
            for (i = 0; i < insertSize; ++i) {
                setIdMethod.setId(genIds.get(i), i);
            }
        }
    }

    private void assignKeys(Configuration configuration, ResultSet rs, SetIdMethod setIdMethod) throws SQLException {
        int i;
        int insertSize = setIdMethod.getInsertSize();
        ArrayList<Object> genIds = new ArrayList<Object>(insertSize);
        for (i = 0; i < insertSize; ++i) {
            if (!rs.next()) {
                return;
            }
            TypeHandler<?> typeHandler = setIdMethod.getIdTypeHandler(configuration);
            if (typeHandler == null) {
                genIds.add(rs.getObject(1));
                continue;
            }
            genIds.add(typeHandler.getResult(rs, 1));
        }
        if (genIds.size() == insertSize) {
            for (i = 0; i < insertSize; ++i) {
                setIdMethod.setId(genIds.get(i), i);
            }
        }
    }
}

