/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.executor;

import cn.xbatis.core.db.reflect.TableIds;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.core.exception.NotTableClassException;
import cn.xbatis.core.mybatis.executor.keygen.MybatisJdbc3KeyGenerator;
import cn.xbatis.core.mybatis.executor.keygen.MybatisSelectKeyGenerator;
import cn.xbatis.core.mybatis.provider.SQLCmdSqlSource;
import cn.xbatis.core.util.GenericUtil;
import cn.xbatis.db.annotations.Table;
import cn.xbatis.db.annotations.TableId;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;

public class TableIdGeneratorWrapper {
    private static String getMapperName(MappedStatement ms) {
        return ms.getId().substring(0, ms.getId().lastIndexOf("."));
    }

    private static Class getEntityClass(MappedStatement ms) {
        try {
            Class<?> clazz = Class.forName(TableIdGeneratorWrapper.getMapperName(ms), false, Thread.currentThread().getContextClassLoader());
            List<Class<?>> list = GenericUtil.getGenericInterfaceClass(clazz);
            if (Objects.isNull(list) || list.isEmpty()) {
                return null;
            }
            return list.stream().filter(item -> item.isAnnotationPresent(Table.class)).findFirst().orElse(null);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntityKeyGenerator(MappedStatement ms, Class entityClass) {
        String selectKeyId = ms.getId() + "!selectKey";
        if (ms.getConfiguration().hasKeyGenerator(selectKeyId)) {
            return;
        }
        String string = selectKeyId.intern();
        synchronized (string) {
            if (ms.getConfiguration().hasKeyGenerator(selectKeyId)) {
                return;
            }
            try {
                TableInfo tableInfo = Tables.get(entityClass);
                if (tableInfo.getIdFieldInfos().size() == 1) {
                    TableIdGeneratorWrapper.addEntityKeyGenerator(ms, selectKeyId, tableInfo);
                }
            }
            catch (NotTableClassException notTableClassException) {
                // empty catch block
            }
        }
    }

    public static void addEntityKeyGenerator(MappedStatement ms, String selectKeyId, TableInfo tableInfo) {
        Object keyGenerator;
        SQLCmdSqlSource sqlCmdSqlSource = (SQLCmdSqlSource)ms.getSqlSource();
        TableId tableId = TableIds.get(tableInfo.getType(), sqlCmdSqlSource.getDbType());
        switch (tableId.value()) {
            case AUTO: {
                keyGenerator = MybatisJdbc3KeyGenerator.INSTANCE;
                break;
            }
            case NONE: 
            case GENERATOR: {
                keyGenerator = NoKeyGenerator.INSTANCE;
                break;
            }
            case SQL: {
                StaticSqlSource sqlSource = new StaticSqlSource(ms.getConfiguration(), tableId.sql());
                ResultMap selectKeyResultMap = new ResultMap.Builder(ms.getConfiguration(), selectKeyId, tableInfo.getSingleIdFieldInfo(true).getFieldInfo().getTypeClass(), Collections.emptyList(), Boolean.valueOf(false)).build();
                MappedStatement selectKeyMappedStatement = new MappedStatement.Builder(ms.getConfiguration(), selectKeyId, (SqlSource)sqlSource, SqlCommandType.SELECT).keyProperty("id").resultMaps(Collections.singletonList(selectKeyResultMap)).keyGenerator((KeyGenerator)NoKeyGenerator.INSTANCE).useCache(false).flushCacheRequired(true).build();
                keyGenerator = new MybatisSelectKeyGenerator(selectKeyMappedStatement, true);
                break;
            }
            default: {
                throw new RuntimeException("Not supported");
            }
        }
        if (keyGenerator != NoKeyGenerator.INSTANCE) {
            MetaObject msMetaObject = ms.getConfiguration().newMetaObject((Object)ms);
            msMetaObject.setValue("keyGenerator", keyGenerator);
            msMetaObject.setValue("keyProperties", (Object)new String[]{"id"});
            msMetaObject.setValue("keyColumns", (Object)new String[]{tableInfo.getSingleIdFieldInfo(true).getColumnName()});
        }
        if (!ms.getConfiguration().hasKeyGenerator(selectKeyId)) {
            ms.getConfiguration().addKeyGenerator(selectKeyId, (KeyGenerator)keyGenerator);
        }
    }
}

