/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.executor;

import cn.xbatis.core.mybatis.mapper.context.ExecuteAndSelectPreparedContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdDeleteContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdInsertContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdQueryContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdUpdateContext;
import cn.xbatis.core.mybatis.mapper.context.SelectPreparedContext;
import cn.xbatis.core.sql.executor.BaseQuery;
import cn.xbatis.core.sql.executor.chain.DeleteChain;
import cn.xbatis.core.sql.executor.chain.UpdateChain;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.BatchExecutor;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;

public class MybatisExecutor
implements Executor {
    private final Executor delegate;

    public MybatisExecutor(Executor delegate) {
        this.delegate = delegate;
        delegate.setExecutorWrapper((Executor)this);
    }

    public boolean isBatchExecutor() {
        return this.delegate instanceof BatchExecutor;
    }

    public int update(MappedStatement ms, Object parameter) throws SQLException {
        if (parameter instanceof SQLCmdInsertContext) {
            SQLCmdInsertContext sqlCmdInsertContext = (SQLCmdInsertContext)parameter;
            sqlCmdInsertContext.setUseBatchExecutor(this.isBatchExecutor());
        }
        return this.delegate.update(ms, parameter);
    }

    public <E> List<E> query(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, CacheKey cacheKey, BoundSql boundSql) throws SQLException {
        return this.delegate.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
    }

    public <E> List<E> query(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler) throws SQLException {
        return this.delegate.query(ms, parameter, rowBounds, resultHandler);
    }

    public <E> Cursor<E> queryCursor(MappedStatement ms, Object parameter, RowBounds rowBounds) throws SQLException {
        return this.delegate.queryCursor(ms, parameter, rowBounds);
    }

    public List<BatchResult> flushStatements() throws SQLException {
        return this.delegate.flushStatements();
    }

    public void commit(boolean required) throws SQLException {
        this.delegate.commit(required);
    }

    public void rollback(boolean required) throws SQLException {
        this.delegate.rollback(required);
    }

    public CacheKey createCacheKey(MappedStatement ms, Object parameterObject, RowBounds rowBounds, BoundSql boundSql) {
        CacheKey cacheKey = this.delegate.createCacheKey(ms, parameterObject, rowBounds, boundSql);
        if (parameterObject instanceof SQLCmdQueryContext) {
            SQLCmdQueryContext context = (SQLCmdQueryContext)parameterObject;
            cacheKey.updateAll(context.getParameters());
            cacheKey.update((Object)((BaseQuery)context.getExecution()).getReturnType().getName());
        } else if (parameterObject instanceof ExecuteAndSelectPreparedContext) {
            ExecuteAndSelectPreparedContext context = (ExecuteAndSelectPreparedContext)parameterObject;
            cacheKey.updateAll(context.getParameters());
            cacheKey.update((Object)context.getReturnType().getName());
            cacheKey.update((Object)System.currentTimeMillis());
        } else if (parameterObject instanceof SelectPreparedContext) {
            SelectPreparedContext context = (SelectPreparedContext)parameterObject;
            cacheKey.updateAll(context.getParameters());
            cacheKey.update((Object)context.getReturnType().getName());
        } else if (parameterObject instanceof SQLCmdUpdateContext) {
            UpdateChain updateChain;
            SQLCmdUpdateContext context = (SQLCmdUpdateContext)parameterObject;
            cacheKey.updateAll(context.getParameters());
            if (context.getExecution() instanceof UpdateChain && (updateChain = (UpdateChain)context.getExecution()).getReturnType() != null) {
                cacheKey.update((Object)updateChain.getReturnType().getName());
            }
            cacheKey.update((Object)System.currentTimeMillis());
        } else if (parameterObject instanceof SQLCmdDeleteContext) {
            DeleteChain deleteChain;
            SQLCmdDeleteContext context = (SQLCmdDeleteContext)parameterObject;
            cacheKey.updateAll(context.getParameters());
            if (context.getExecution() instanceof DeleteChain && (deleteChain = (DeleteChain)context.getExecution()).getReturnType() != null) {
                cacheKey.update((Object)deleteChain.getReturnType().getName());
            }
            cacheKey.update((Object)System.currentTimeMillis());
        }
        return cacheKey;
    }

    public boolean isCached(MappedStatement ms, CacheKey key) {
        return this.delegate.isCached(ms, key);
    }

    public void clearLocalCache() {
        this.delegate.clearLocalCache();
    }

    public void deferLoad(MappedStatement ms, MetaObject resultObject, String property, CacheKey key, Class<?> targetType) {
        this.delegate.deferLoad(ms, resultObject, property, key, targetType);
    }

    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    public void close(boolean forceRollback) {
        this.delegate.close(forceRollback);
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public void setExecutorWrapper(Executor executor) {
        this.delegate.setExecutorWrapper(executor);
    }
}

