/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis;

import cn.xbatis.core.XbatisGlobalConfig;
import cn.xbatis.core.mybatis.mapper.MybatisMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public final class MybatisBatchUtil {
    public static <M extends MybatisMapper<T>, T> int batchSave(SqlSessionFactory sqlSessionFactory, Class<M> mapperType, Collection<T> list) {
        return MybatisBatchUtil.batchSave(sqlSessionFactory, mapperType, list, XbatisGlobalConfig.getDefaultBatchSize());
    }

    public static <M extends MybatisMapper<T>, T> int batchSave(SqlSessionFactory sqlSessionFactory, Class<M> mapperType, Collection<T> list, int batchSize) {
        return MybatisBatchUtil.batch(sqlSessionFactory, mapperType, list, batchSize, (session, mapper, data) -> mapper.save(data));
    }

    public static <M extends MybatisMapper<T>, T> int batchUpdate(SqlSessionFactory sqlSessionFactory, Class<M> mapperType, Collection<T> list) {
        return MybatisBatchUtil.batchUpdate(sqlSessionFactory, mapperType, list, XbatisGlobalConfig.getDefaultBatchSize());
    }

    public static <M extends MybatisMapper<T>, T> int batchUpdate(SqlSessionFactory sqlSessionFactory, Class<M> mapperType, Collection<T> list, int batchSize) {
        return MybatisBatchUtil.batch(sqlSessionFactory, mapperType, list, batchSize, (session, mapper, data) -> mapper.update(data));
    }

    public static <M, T> int batch(SqlSessionFactory sqlSessionFactory, Class<M> mapperType, Collection<T> list, int batchSize, MybatisBatchBiConsumer<SqlSession, M, T> batchFunction) {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        try (SqlSession session = sqlSessionFactory.openSession(ExecutorType.BATCH, true);){
            Object mapper = session.getMapper(mapperType);
            int updateCnt = 0;
            int optTimes = 0;
            for (T entity : list) {
                batchFunction.accept(session, mapper, entity);
                if (++optTimes != batchSize) continue;
                updateCnt += MybatisBatchUtil.getEffectCnt(session.flushStatements());
                optTimes = 0;
            }
            if (optTimes != 0) {
                updateCnt += MybatisBatchUtil.getEffectCnt(session.flushStatements());
            }
            int n = updateCnt;
            return n;
        }
    }

    public static <M, T> int batchMulti(SqlSessionFactory sqlSessionFactory, Class<M> mapperType, Collection<T> list, int batchSize, int subBatchSize, MybatisBatchBiConsumer<SqlSession, M, List<T>> batchFunction) {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        try (SqlSession session = sqlSessionFactory.openSession(ExecutorType.BATCH, true);){
            Object mapper = session.getMapper(mapperType);
            int updateCnt = 0;
            int optTimes = 0;
            int counter = 0;
            ArrayList<T> subList = new ArrayList<T>();
            for (T entity : list) {
                subList.add(entity);
                if (++counter == subBatchSize) {
                    batchFunction.accept(session, mapper, subList);
                    counter = 0;
                    ++optTimes;
                    subList.clear();
                }
                if (optTimes != batchSize) continue;
                updateCnt += MybatisBatchUtil.getEffectCnt(session.flushStatements());
                optTimes = 0;
            }
            if (counter != 0) {
                ++optTimes;
                batchFunction.accept(session, mapper, subList);
            }
            if (optTimes != 0) {
                updateCnt += MybatisBatchUtil.getEffectCnt(session.flushStatements());
            }
            int n = updateCnt;
            return n;
        }
    }

    public static int batch(SqlSessionFactory sqlSessionFactory, Function<SqlSession, Integer> batchFunction) {
        try (SqlSession session = sqlSessionFactory.openSession(ExecutorType.BATCH, true);){
            int n = batchFunction.apply(session);
            return n;
        }
    }

    public static int getEffectCnt(List<BatchResult> batchResultList) {
        int updateCnt = 0;
        for (BatchResult batchResult : batchResultList) {
            for (int i : batchResult.getUpdateCounts()) {
                updateCnt += i;
            }
        }
        return updateCnt;
    }

    public static interface MybatisBatchBiConsumer<S extends SqlSession, M, T> {
        public void accept(S var1, M var2, T var3);

        default public MybatisBatchBiConsumer<S, M, T> andThen(MybatisBatchBiConsumer<? super S, ? super M, ? super T> after) {
            Objects.requireNonNull(after);
            return (l, r, t) -> {
                this.accept(l, r, t);
                after.accept(l, r, t);
            };
        }
    }
}

