/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.db.reflect;

import cn.xbatis.core.db.reflect.CreatedEventInfo;
import cn.xbatis.core.db.reflect.FetchInfo;
import cn.xbatis.core.db.reflect.FieldInfo;
import cn.xbatis.core.db.reflect.NestedResultInfo;
import cn.xbatis.core.db.reflect.PutEnumValueInfo;
import cn.xbatis.core.db.reflect.PutValueInfo;
import cn.xbatis.core.db.reflect.ResultFieldInfo;
import cn.xbatis.core.db.reflect.ResultTableFieldInfo;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.core.exception.NotTableClassException;
import cn.xbatis.core.exception.NotTableFieldException;
import cn.xbatis.core.util.FieldUtil;
import cn.xbatis.core.util.GenericUtil;
import cn.xbatis.db.annotations.CreatedEvent;
import cn.xbatis.db.annotations.Fetch;
import cn.xbatis.db.annotations.NestedResultEntity;
import cn.xbatis.db.annotations.NestedResultEntityField;
import cn.xbatis.db.annotations.PutEnumValue;
import cn.xbatis.db.annotations.PutValue;
import cn.xbatis.db.annotations.ResultEntity;
import cn.xbatis.db.annotations.ResultEntityField;
import cn.xbatis.db.annotations.ResultField;
import cn.xbatis.db.annotations.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.ibatis.type.TypeHandler;

public class ResultInfo {
    private final Map<Class, List<FetchInfo>> fetchInfoMap;
    private final Map<Class, List<PutValueInfo>> putValueInfoMap;
    private final Map<Class, List<PutEnumValueInfo>> putEnumValueInfoMap;
    private final List<ResultFieldInfo> resultFieldInfos;
    private final List<NestedResultInfo> nestedResultInfos;
    private final Map<Class, Map<Integer, String>> tablePrefixes;
    private final Map<Class, List<CreatedEventInfo>> createdEventInfos;

    public ResultInfo(Class<?> clazz) {
        ParseResult parseResult = ResultInfo.parse(clazz);
        this.fetchInfoMap = Collections.unmodifiableMap(parseResult.fetchInfoMap);
        this.putValueInfoMap = Collections.unmodifiableMap(parseResult.putValueInfoMap);
        this.putEnumValueInfoMap = Collections.unmodifiableMap(parseResult.putEnumValueInfoMap);
        this.resultFieldInfos = Collections.unmodifiableList(parseResult.resultFieldInfos);
        this.tablePrefixes = Collections.unmodifiableMap(parseResult.tablePrefixes);
        this.nestedResultInfos = Collections.unmodifiableList(parseResult.nestedResultInfos);
        this.createdEventInfos = Collections.unmodifiableMap(parseResult.createdEventInfos.stream().collect(Collectors.groupingBy(CreatedEventInfo::getClazz)));
    }

    private static ParseResult parse(Class<?> clazz) {
        ResultEntity resultEntity = clazz.getAnnotation(ResultEntity.class);
        Objects.requireNonNull(resultEntity);
        ParseResult parseResult = new ParseResult();
        ResultInfo.parseResultEntity(parseResult, clazz, resultEntity);
        return parseResult;
    }

    private static void parseResultEntity(ParseResult parseResult, Class<?> clazz, ResultEntity resultEntity) {
        if (clazz.isAnnotationPresent(CreatedEvent.class)) {
            parseResult.createdEventInfos.add(new CreatedEventInfo(clazz, clazz.getAnnotation(CreatedEvent.class)));
        }
        TableInfo resultEntityTableInfo = resultEntity.value().isAnnotationPresent(Table.class) ? Tables.get(resultEntity.value()) : null;
        int tableCount = 0;
        if (Objects.nonNull(resultEntityTableInfo)) {
            tableCount = ResultInfo.createPrefix(resultEntity.value(), resultEntity.storey(), parseResult.tablePrefixes, 0);
        } else if (resultEntity.value() != Void.TYPE && resultEntity.value() != Void.class) {
            throw new NotTableClassException(resultEntity.value());
        }
        List<Field> fieldList = FieldUtil.getFields(clazz);
        for (Field field : fieldList) {
            String tableFieldName;
            TableInfo tableInfo;
            int storey;
            Class entity;
            if (field.isAnnotationPresent(ResultField.class)) {
                ResultField resultField = field.getAnnotation(ResultField.class);
                parseResult.resultFieldInfos.add(new ResultFieldInfo(clazz, field, resultField));
                continue;
            }
            if (field.isAnnotationPresent(Fetch.class)) {
                tableCount = ResultInfo.parseFetch(parseResult, resultEntityTableInfo, parseResult.resultFieldInfos, clazz, field, tableCount);
                continue;
            }
            if (field.isAnnotationPresent(PutValue.class)) {
                tableCount = ResultInfo.parsePutValue(parseResult, resultEntityTableInfo, parseResult.resultFieldInfos, clazz, field, tableCount);
                continue;
            }
            if (field.isAnnotationPresent(PutEnumValue.class)) {
                tableCount = ResultInfo.parsePutEnumValue(parseResult, resultEntityTableInfo, parseResult.resultFieldInfos, clazz, field, tableCount);
                continue;
            }
            if (field.isAnnotationPresent(NestedResultEntity.class)) {
                NestedResultEntity nestedResultEntity = field.getAnnotation(NestedResultEntity.class);
                NestedResultInfo nestedResultInfo = new NestedResultInfo(clazz, field, nestedResultEntity, new ArrayList<ResultFieldInfo>(), new ArrayList<NestedResultInfo>());
                parseResult.nestedResultInfos.add(nestedResultInfo);
                tableCount = ResultInfo.parseNestedResultEntity(parseResult, nestedResultInfo, field, nestedResultEntity, tableCount);
                continue;
            }
            if (Objects.isNull(resultEntityTableInfo)) {
                throw new RuntimeException("the class:" + clazz + "'s @ResultEntity not set correct value");
            }
            if (field.isAnnotationPresent(ResultEntityField.class)) {
                ResultEntityField resultEntityField = field.getAnnotation(ResultEntityField.class);
                if (resultEntityField.target() != Void.class) {
                    entity = resultEntityField.target();
                    storey = resultEntityField.storey();
                    tableInfo = Tables.get(entity);
                    if (Objects.isNull(tableInfo)) {
                        throw new NotTableClassException(entity);
                    }
                } else {
                    if (resultEntity.storey() != resultEntityField.storey()) {
                        throw new RuntimeException(" class: no config ?, the field:" + field.getName() + " config @ResultEntityField(storey) error");
                    }
                    entity = resultEntity.value();
                    storey = resultEntity.storey();
                    tableInfo = resultEntityTableInfo;
                }
                if ((tableFieldName = resultEntityField.property()).isEmpty()) {
                    tableFieldName = field.getName();
                }
            } else {
                tableInfo = resultEntityTableInfo;
                entity = resultEntity.value();
                storey = resultEntity.storey();
                tableFieldName = field.getName();
            }
            TableFieldInfo tableFieldInfo = tableInfo.getFieldInfo(tableFieldName);
            if (Objects.isNull(tableFieldInfo)) {
                throw new NotTableFieldException(entity, tableFieldName);
            }
            if (resultEntity.value() != entity || resultEntity.storey() != storey) {
                tableCount = ResultInfo.createPrefix(entity, storey, parseResult.tablePrefixes, tableCount);
            }
            String tablePrefix = ResultInfo.getTablePrefix(parseResult.tablePrefixes, entity, storey);
            parseResult.resultFieldInfos.add(new ResultTableFieldInfo(clazz, storey, tablePrefix, tableInfo, tableFieldInfo, field));
        }
    }

    private static int parseNestedResultEntity(ParseResult parseResult, NestedResultInfo nestedResultInfo, Field sourceField, NestedResultEntity nestedResultEntity, int tableCount) {
        TableInfo tableInfo;
        boolean fieldTypeIsEntity;
        List<Class<?>> types;
        tableCount = ResultInfo.createPrefix(nestedResultEntity.target(), nestedResultEntity.storey(), parseResult.tablePrefixes, tableCount);
        Class<?> targetType = nestedResultInfo.getFieldInfo().getTypeClass();
        if (Collection.class.isAssignableFrom(targetType) && Objects.nonNull(types = GenericUtil.getGeneric(nestedResultInfo.getField().getGenericType())) && !types.isEmpty()) {
            targetType = types.get(0);
        }
        if (!(fieldTypeIsEntity = targetType.isAnnotationPresent(Table.class)) && targetType.isAnnotationPresent(CreatedEvent.class)) {
            parseResult.createdEventInfos.add(new CreatedEventInfo(targetType, targetType.getAnnotation(CreatedEvent.class)));
        }
        if (Objects.isNull(tableInfo = Tables.get(nestedResultEntity.target()))) {
            throw new NotTableClassException(nestedResultEntity.target());
        }
        for (Field field : FieldUtil.getFields(targetType)) {
            if (field.isAnnotationPresent(ResultField.class)) {
                ResultField resultField = field.getAnnotation(ResultField.class);
                nestedResultInfo.getResultFieldInfos().add(new ResultFieldInfo(targetType, field, resultField));
                continue;
            }
            if (field.isAnnotationPresent(Fetch.class)) {
                FieldInfo fieldInfo = new FieldInfo(targetType, sourceField);
                Class<?> fetchType = fieldInfo.getFinalClass();
                tableCount = ResultInfo.parseFetch(parseResult, tableInfo, nestedResultInfo.getResultFieldInfos(), fetchType, field, tableCount);
                continue;
            }
            if (field.isAnnotationPresent(ResultEntityField.class)) {
                TableFieldInfo tableFieldInfo;
                ResultEntityField resultEntityField = field.getAnnotation(ResultEntityField.class);
                if (resultEntityField.target() == Void.class) {
                    throw new RuntimeException(" class:" + field.getDeclaringClass() + ", the field:" + field.getName() + " config @ResultEntityField error");
                }
                Class entity = resultEntityField.target();
                int storey = resultEntityField.storey();
                tableInfo = Tables.get(entity);
                if (Objects.isNull(tableInfo)) {
                    throw new NotTableClassException(entity);
                }
                String tableFieldName = resultEntityField.property();
                if (tableFieldName.isEmpty()) {
                    tableFieldName = field.getName();
                }
                if (Objects.isNull(tableFieldInfo = tableInfo.getFieldInfo(tableFieldName))) {
                    throw new NotTableFieldException(entity, tableFieldName);
                }
                tableCount = ResultInfo.createPrefix(entity, storey, parseResult.tablePrefixes, tableCount);
                String tablePrefix = ResultInfo.getTablePrefix(parseResult.tablePrefixes, entity, storey);
                nestedResultInfo.getResultFieldInfos().add(new ResultTableFieldInfo(targetType, storey, tablePrefix, tableInfo, tableFieldInfo, field));
                continue;
            }
            if (field.isAnnotationPresent(NestedResultEntity.class)) {
                NestedResultEntity newNestedResultEntity = field.getAnnotation(NestedResultEntity.class);
                NestedResultInfo newNestedResultInfo = new NestedResultInfo(targetType, field, newNestedResultEntity, new ArrayList<ResultFieldInfo>(), new ArrayList<NestedResultInfo>());
                nestedResultInfo.getNestedResultInfos().add(newNestedResultInfo);
                tableCount = ResultInfo.parseNestedResultEntity(parseResult, newNestedResultInfo, field, newNestedResultEntity, tableCount);
                continue;
            }
            if (field.isAnnotationPresent(PutValue.class)) {
                tableCount = ResultInfo.parsePutValue(parseResult, tableInfo, parseResult.resultFieldInfos, targetType, field, tableCount);
                continue;
            }
            if (field.isAnnotationPresent(PutEnumValue.class)) {
                tableCount = ResultInfo.parsePutEnumValue(parseResult, tableInfo, parseResult.resultFieldInfos, targetType, field, tableCount);
                continue;
            }
            String targetFieldName = field.getName();
            NestedResultEntityField nestedResultEntityField = field.getAnnotation(NestedResultEntityField.class);
            if (Objects.nonNull(nestedResultEntityField)) {
                targetFieldName = nestedResultEntityField.value();
            }
            TableFieldInfo tableFieldInfo = tableInfo.getFieldInfo(targetFieldName);
            if (Objects.isNull(nestedResultEntityField) && fieldTypeIsEntity && !tableFieldInfo.getTableFieldAnnotation().select()) continue;
            if (Objects.isNull(tableFieldInfo)) {
                throw new NotTableFieldException(nestedResultEntity.target(), field.getName());
            }
            String tablePrefix = ResultInfo.getTablePrefix(parseResult.tablePrefixes, nestedResultEntity.target(), nestedResultEntity.storey());
            nestedResultInfo.getResultFieldInfos().add(new ResultTableFieldInfo(targetType, nestedResultEntity.storey(), tablePrefix, tableInfo, tableFieldInfo, field));
        }
        return tableCount;
    }

    private static RuntimeException buildException(Class clazz, Field field, String annotationName, String annotationPropertyName, String message) {
        return new RuntimeException(clazz.getName() + "." + field.getName() + " " + annotationName + "  config error,the " + annotationPropertyName + ":" + message);
    }

    private static int parseFetch(ParseResult parseResult, TableInfo currentTableInfo, List<ResultFieldInfo> resultFieldInfos, Class<?> clazz, Field field, int tableCount) {
        FieldInfo fieldInfo;
        Class<?> returnType;
        Fetch fetch = field.getAnnotation(Fetch.class);
        String valueColumn = fetch.column();
        TypeHandler<?> valueTypeHandler = null;
        if ("".equals(valueColumn)) {
            TableFieldInfo fetchFieldInfo;
            TableInfo fetchTableInfo;
            if (fetch.source() != Void.class) {
                if (!fetch.source().isAnnotationPresent(Table.class)) {
                    throw new RuntimeException(clazz.getName() + "->" + field.getName() + " fetch config error,the source: " + fetch.source().getName() + " is not a entity");
                }
                fetchTableInfo = Tables.get(fetch.source());
                fetchFieldInfo = fetchTableInfo.getFieldInfo(fetch.property());
            } else {
                fetchTableInfo = currentTableInfo;
                fetchFieldInfo = fetchTableInfo.getFieldInfo(fetch.property());
            }
            if (Objects.isNull(fetchFieldInfo)) {
                throw new RuntimeException(clazz.getName() + "->" + field.getName() + " fetch config error,the property: " + fetch.property() + " is not a entity field");
            }
            valueTypeHandler = fetchFieldInfo.getTypeHandler();
            tableCount = ResultInfo.createPrefix(fetchTableInfo.getType(), fetch.storey(), parseResult.tablePrefixes, tableCount);
            String tablePrefix = ResultInfo.getTablePrefix(parseResult.tablePrefixes, fetchTableInfo.getType(), fetch.storey());
            resultFieldInfos.add(new ResultTableFieldInfo(false, clazz, fetch.storey(), tablePrefix, fetchTableInfo, fetchFieldInfo, field));
            valueColumn = tablePrefix + fetchFieldInfo.getColumnName();
        }
        if (!(returnType = (fieldInfo = new FieldInfo(clazz, field)).getFinalClass()).isAnnotationPresent(Table.class) && returnType.isAnnotationPresent(CreatedEvent.class)) {
            parseResult.createdEventInfos.add(new CreatedEventInfo(returnType, returnType.getAnnotation(CreatedEvent.class)));
        }
        parseResult.fetchInfoMap.computeIfAbsent(clazz, key -> new ArrayList()).add(new FetchInfo(clazz, fieldInfo, fetch, returnType, valueColumn, valueTypeHandler));
        return tableCount;
    }

    private static int parsePutValue(ParseResult parseResult, TableInfo currentTableInfo, List<ResultFieldInfo> resultFieldInfos, Class clazz, Field field, int tableCount) {
        TableInfo fetchTableInfo;
        PutValue putValue = field.getAnnotation(PutValue.class);
        if (putValue.source() == Void.class) {
            fetchTableInfo = currentTableInfo;
        } else {
            if (!putValue.source().isAnnotationPresent(Table.class)) {
                throw new RuntimeException(clazz.getName() + "->" + field.getName() + " @PutValue config error,the source: " + putValue.source().getName() + " is not a entity");
            }
            fetchTableInfo = Tables.get(putValue.source());
        }
        String[] properties = putValue.property().split(",");
        String[] valuesColumn = new String[properties.length];
        Class[] valueTypes = new Class[properties.length];
        TypeHandler[] valuesTypeHandler = new TypeHandler[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            TableFieldInfo fetchFieldInfo = fetchTableInfo.getFieldInfo(putValue.property());
            if (Objects.isNull(fetchFieldInfo)) {
                throw new RuntimeException(clazz.getName() + "->" + field.getName() + " fetch config error,the property: " + putValue.property() + " is not a entity field");
            }
            tableCount = ResultInfo.createPrefix(fetchTableInfo.getType(), putValue.storey(), parseResult.tablePrefixes, tableCount);
            String tablePrefix = ResultInfo.getTablePrefix(parseResult.tablePrefixes, fetchTableInfo.getType(), putValue.storey());
            resultFieldInfos.add(new ResultTableFieldInfo(false, clazz, putValue.storey(), tablePrefix, fetchTableInfo, fetchFieldInfo, field));
            valuesColumn[i] = tablePrefix + fetchFieldInfo.getColumnName();
            valuesTypeHandler[i] = fetchFieldInfo.getTypeHandler();
            valueTypes[i] = fetchFieldInfo.getFieldInfo().getTypeClass();
        }
        parseResult.putValueInfoMap.computeIfAbsent(clazz, key -> new ArrayList()).add(new PutValueInfo(clazz, field, putValue, valueTypes, valuesColumn, valuesTypeHandler));
        return tableCount;
    }

    private static int parsePutEnumValue(ParseResult parseResult, TableInfo currentTableInfo, List<ResultFieldInfo> resultFieldInfos, Class clazz, Field field, int tableCount) {
        TableInfo fetchTableInfo;
        PutEnumValue putEnumValue = field.getAnnotation(PutEnumValue.class);
        if (putEnumValue.source() == Void.class) {
            fetchTableInfo = currentTableInfo;
        } else {
            if (!putEnumValue.source().isAnnotationPresent(Table.class)) {
                throw new RuntimeException(clazz.getName() + "->" + field.getName() + " @PutEnumValue config error,the source: " + putEnumValue.source().getName() + " is not a entity");
            }
            fetchTableInfo = Tables.get(putEnumValue.source());
        }
        TableFieldInfo fetchFieldInfo = fetchTableInfo.getFieldInfo(putEnumValue.property());
        if (Objects.isNull(fetchFieldInfo)) {
            throw new RuntimeException(clazz.getName() + "->" + field.getName() + " fetch config error,the property: " + putEnumValue.property() + " is not a entity field");
        }
        tableCount = ResultInfo.createPrefix(fetchTableInfo.getType(), putEnumValue.storey(), parseResult.tablePrefixes, tableCount);
        String tablePrefix = ResultInfo.getTablePrefix(parseResult.tablePrefixes, fetchTableInfo.getType(), putEnumValue.storey());
        resultFieldInfos.add(new ResultTableFieldInfo(false, clazz, putEnumValue.storey(), tablePrefix, fetchTableInfo, fetchFieldInfo, field));
        String valueColumn = tablePrefix + fetchFieldInfo.getColumnName();
        TypeHandler<?> valueTypeHandler = fetchFieldInfo.getTypeHandler();
        parseResult.putEnumValueInfoMap.computeIfAbsent(clazz, key -> new ArrayList()).add(new PutEnumValueInfo(field, putEnumValue, fetchFieldInfo.getFieldInfo().getTypeClass(), valueColumn, valueTypeHandler));
        return tableCount;
    }

    private static int createPrefix(Class entity, int storey, Map<Class, Map<Integer, String>> entityPrefixMap, int tableCount) {
        String prefix;
        if (Objects.nonNull(entity) && entity != Void.class && !ResultInfo.addPrefix(entityPrefixMap, entity, storey, prefix = ++tableCount == 1 ? "" : "x" + tableCount + "$")) {
            --tableCount;
        }
        return tableCount;
    }

    private static boolean addPrefix(Map<Class, Map<Integer, String>> entityPrefixMap, Class<?> entityType, int storey, String prefix) {
        Map prefixMap = entityPrefixMap.computeIfAbsent(entityType, key -> new HashMap());
        if (prefixMap.containsKey(storey)) {
            return false;
        }
        prefixMap.put(storey, prefix);
        return true;
    }

    private static String getTablePrefix(Map<Class, Map<Integer, String>> entityPrefixMap, Class<?> entity, int storey) {
        String prefix = entityPrefixMap.get(entity).get(storey);
        Objects.requireNonNull(prefix);
        return prefix;
    }

    public List<ResultFieldInfo> getResultFieldInfos() {
        return this.resultFieldInfos;
    }

    public List<NestedResultInfo> getNestedResultInfos() {
        return this.nestedResultInfos;
    }

    public Map<Class, List<FetchInfo>> getFetchInfoMap() {
        return this.fetchInfoMap;
    }

    public Map<Class, Map<Integer, String>> getTablePrefixes() {
        return this.tablePrefixes;
    }

    @Generated
    public Map<Class, List<PutValueInfo>> getPutValueInfoMap() {
        return this.putValueInfoMap;
    }

    @Generated
    public Map<Class, List<PutEnumValueInfo>> getPutEnumValueInfoMap() {
        return this.putEnumValueInfoMap;
    }

    @Generated
    public Map<Class, List<CreatedEventInfo>> getCreatedEventInfos() {
        return this.createdEventInfos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultInfo)) {
            return false;
        }
        ResultInfo other = (ResultInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Class, List<FetchInfo>> this$fetchInfoMap = this.getFetchInfoMap();
        Map<Class, List<FetchInfo>> other$fetchInfoMap = other.getFetchInfoMap();
        if (this$fetchInfoMap == null ? other$fetchInfoMap != null : !((Object)this$fetchInfoMap).equals(other$fetchInfoMap)) {
            return false;
        }
        Map<Class, List<PutValueInfo>> this$putValueInfoMap = this.getPutValueInfoMap();
        Map<Class, List<PutValueInfo>> other$putValueInfoMap = other.getPutValueInfoMap();
        if (this$putValueInfoMap == null ? other$putValueInfoMap != null : !((Object)this$putValueInfoMap).equals(other$putValueInfoMap)) {
            return false;
        }
        Map<Class, List<PutEnumValueInfo>> this$putEnumValueInfoMap = this.getPutEnumValueInfoMap();
        Map<Class, List<PutEnumValueInfo>> other$putEnumValueInfoMap = other.getPutEnumValueInfoMap();
        if (this$putEnumValueInfoMap == null ? other$putEnumValueInfoMap != null : !((Object)this$putEnumValueInfoMap).equals(other$putEnumValueInfoMap)) {
            return false;
        }
        List<ResultFieldInfo> this$resultFieldInfos = this.getResultFieldInfos();
        List<ResultFieldInfo> other$resultFieldInfos = other.getResultFieldInfos();
        if (this$resultFieldInfos == null ? other$resultFieldInfos != null : !((Object)this$resultFieldInfos).equals(other$resultFieldInfos)) {
            return false;
        }
        List<NestedResultInfo> this$nestedResultInfos = this.getNestedResultInfos();
        List<NestedResultInfo> other$nestedResultInfos = other.getNestedResultInfos();
        if (this$nestedResultInfos == null ? other$nestedResultInfos != null : !((Object)this$nestedResultInfos).equals(other$nestedResultInfos)) {
            return false;
        }
        Map<Class, Map<Integer, String>> this$tablePrefixes = this.getTablePrefixes();
        Map<Class, Map<Integer, String>> other$tablePrefixes = other.getTablePrefixes();
        if (this$tablePrefixes == null ? other$tablePrefixes != null : !((Object)this$tablePrefixes).equals(other$tablePrefixes)) {
            return false;
        }
        Map<Class, List<CreatedEventInfo>> this$createdEventInfos = this.getCreatedEventInfos();
        Map<Class, List<CreatedEventInfo>> other$createdEventInfos = other.getCreatedEventInfos();
        return !(this$createdEventInfos == null ? other$createdEventInfos != null : !((Object)this$createdEventInfos).equals(other$createdEventInfos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResultInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Class, List<FetchInfo>> $fetchInfoMap = this.getFetchInfoMap();
        result = result * 59 + ($fetchInfoMap == null ? 43 : ((Object)$fetchInfoMap).hashCode());
        Map<Class, List<PutValueInfo>> $putValueInfoMap = this.getPutValueInfoMap();
        result = result * 59 + ($putValueInfoMap == null ? 43 : ((Object)$putValueInfoMap).hashCode());
        Map<Class, List<PutEnumValueInfo>> $putEnumValueInfoMap = this.getPutEnumValueInfoMap();
        result = result * 59 + ($putEnumValueInfoMap == null ? 43 : ((Object)$putEnumValueInfoMap).hashCode());
        List<ResultFieldInfo> $resultFieldInfos = this.getResultFieldInfos();
        result = result * 59 + ($resultFieldInfos == null ? 43 : ((Object)$resultFieldInfos).hashCode());
        List<NestedResultInfo> $nestedResultInfos = this.getNestedResultInfos();
        result = result * 59 + ($nestedResultInfos == null ? 43 : ((Object)$nestedResultInfos).hashCode());
        Map<Class, Map<Integer, String>> $tablePrefixes = this.getTablePrefixes();
        result = result * 59 + ($tablePrefixes == null ? 43 : ((Object)$tablePrefixes).hashCode());
        Map<Class, List<CreatedEventInfo>> $createdEventInfos = this.getCreatedEventInfos();
        result = result * 59 + ($createdEventInfos == null ? 43 : ((Object)$createdEventInfos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResultInfo(fetchInfoMap=" + this.getFetchInfoMap() + ", putValueInfoMap=" + this.getPutValueInfoMap() + ", putEnumValueInfoMap=" + this.getPutEnumValueInfoMap() + ", resultFieldInfos=" + this.getResultFieldInfos() + ", nestedResultInfos=" + this.getNestedResultInfos() + ", tablePrefixes=" + this.getTablePrefixes() + ", createdEventInfos=" + this.getCreatedEventInfos() + ")";
    }

    static class ParseResult {
        public final Map<Class, List<FetchInfo>> fetchInfoMap = new HashMap<Class, List<FetchInfo>>();
        public final List<ResultFieldInfo> resultFieldInfos = new ArrayList<ResultFieldInfo>();
        public final List<NestedResultInfo> nestedResultInfos = new ArrayList<NestedResultInfo>();
        public final Map<Class, Map<Integer, String>> tablePrefixes = new HashMap<Class, Map<Integer, String>>();
        public final Map<Class, List<PutValueInfo>> putValueInfoMap = new HashMap<Class, List<PutValueInfo>>();
        public final Map<Class, List<PutEnumValueInfo>> putEnumValueInfoMap = new HashMap<Class, List<PutEnumValueInfo>>();
        public final List<CreatedEventInfo> createdEventInfos = new ArrayList<CreatedEventInfo>();

        ParseResult() {
        }
    }
}

