/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.db.reflect;

import cn.xbatis.core.db.reflect.FieldInfo;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.db.annotations.ModelEntityField;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Objects;
import org.apache.ibatis.reflection.invoker.GetFieldInvoker;
import org.apache.ibatis.reflection.invoker.SetFieldInvoker;

public class ModelFieldInfo {
    private final TableFieldInfo tableFieldInfo;
    private final Field field;
    private final FieldInfo fieldInfo;
    private final GetFieldInvoker readFieldInvoker;
    private final SetFieldInvoker writeFieldInvoker;

    public ModelFieldInfo(Class entity, Class model, Field field) {
        TableInfo tableInfo = Tables.get(entity);
        String entityFieldName = field.getName();
        if (field.isAnnotationPresent(ModelEntityField.class)) {
            ModelEntityField modelEntityField = field.getAnnotation(ModelEntityField.class);
            entityFieldName = modelEntityField.value();
        }
        this.tableFieldInfo = tableInfo.getFieldInfo(entityFieldName);
        if (Objects.isNull(this.tableFieldInfo)) {
            throw new RuntimeException(MessageFormat.format("unable match field {0} in class {1} ,The field {2} can''t found in entity class {3}", field.getName(), model.getName(), entityFieldName, entity.getName()));
        }
        this.field = field;
        this.fieldInfo = new FieldInfo(model, field);
        this.readFieldInvoker = new GetFieldInvoker(field);
        this.writeFieldInvoker = new SetFieldInvoker(field);
    }

    public Object getValue(Object object) {
        try {
            return this.readFieldInvoker.invoke(object, null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public TableFieldInfo getTableFieldInfo() {
        return this.tableFieldInfo;
    }

    public Field getField() {
        return this.field;
    }

    public GetFieldInvoker getReadFieldInvoker() {
        return this.readFieldInvoker;
    }

    public SetFieldInvoker getWriteFieldInvoker() {
        return this.writeFieldInvoker;
    }

    public FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }
}

