/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.db.reflect;

import cn.xbatis.core.XbatisGlobalConfig;
import cn.xbatis.core.db.reflect.FieldInfo;
import cn.xbatis.core.db.reflect.ResultFieldInfo;
import cn.xbatis.core.db.reflect.ResultInfo;
import cn.xbatis.core.db.reflect.ResultInfos;
import cn.xbatis.core.db.reflect.ResultTableFieldInfo;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.annotations.Fetch;
import cn.xbatis.db.annotations.ResultEntity;
import cn.xbatis.db.annotations.Table;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.ibatis.reflection.invoker.GetFieldInvoker;
import org.apache.ibatis.reflection.invoker.SetFieldInvoker;
import org.apache.ibatis.type.TypeHandler;

public class FetchInfo {
    private final FieldInfo fieldInfo;
    private final Fetch fetch;
    private final String valueColumn;
    private final TypeHandler<?> valueTypeHandler;
    private final TableInfo middleTableInfo;
    private final TableFieldInfo middleSourceTableFieldInfo;
    private final TableFieldInfo middleTargetTableFieldInfo;
    private final TableInfo targetTableInfo;
    private final TableFieldInfo targetTableFieldInfo;
    private final String targetSelect;
    private final String targetOrderBy;
    private final String otherConditions;
    private final SetFieldInvoker writeFieldInvoker;
    private final boolean multiple;
    private final Class<?> returnType;
    private final boolean singleFetch;
    private final boolean group;
    private final boolean sourceTargetMatchFieldInReturnType;
    private final Field sourceTargetMatchField;
    private final GetFieldInvoker sourceTargetMatchFieldGetter;
    private final Object nullFillValue;

    public FetchInfo(Class clazz, FieldInfo fieldInfo, Fetch fetch, Class returnType, String valueColumn, TypeHandler<?> valueTypeHandler) {
        this.fieldInfo = fieldInfo;
        this.fetch = fetch;
        this.writeFieldInvoker = new SetFieldInvoker(fieldInfo.getField());
        this.valueColumn = valueColumn;
        this.valueTypeHandler = valueTypeHandler;
        Object[] objs = FetchInfo.parseMiddle(clazz, fieldInfo.getField(), fetch);
        this.middleTableInfo = (TableInfo)objs[0];
        this.middleSourceTableFieldInfo = (TableFieldInfo)objs[1];
        this.middleTargetTableFieldInfo = (TableFieldInfo)objs[2];
        objs = FetchInfo.parseTarget(clazz, fieldInfo.getField(), fetch);
        this.targetTableInfo = (TableInfo)objs[0];
        this.targetTableFieldInfo = (TableFieldInfo)objs[1];
        this.targetSelect = FetchInfo.parseDynamicColumn(clazz, fieldInfo.getField(), this.middleTableInfo, this.targetTableInfo, "@Fetch", "targetSelectProperty", fetch.targetSelectProperty());
        this.targetOrderBy = FetchInfo.parseOrderByColumn(clazz, fieldInfo.getField(), this.middleTableInfo, this.targetTableInfo, "@Fetch", "orderBy", fetch.orderBy());
        String otherConditions = FetchInfo.parseDynamicColumn(clazz, fieldInfo.getField(), this.middleTableInfo, this.targetTableInfo, "@Fetch", "otherConditions", fetch.otherConditions());
        this.multiple = Collection.class.isAssignableFrom(this.fieldInfo.getTypeClass());
        this.returnType = returnType;
        this.otherConditions = otherConditions;
        this.singleFetch = fetch.limit() >= 1;
        this.group = this.targetSelect != null && this.targetSelect.contains("(");
        objs = FetchInfo.parseSourceTargetMatchField(fetch, clazz, returnType, fieldInfo, this.targetTableInfo, this.targetTableFieldInfo);
        this.sourceTargetMatchFieldInReturnType = (Boolean)objs[0];
        this.sourceTargetMatchField = (Field)objs[1];
        this.sourceTargetMatchFieldGetter = this.sourceTargetMatchField != null ? new GetFieldInvoker(this.sourceTargetMatchField) : null;
        this.nullFillValue = fetch.nullFillValue().isEmpty() || fetch.nullFillValue().contains("{") ? null : TypeConvertUtil.convert(fetch.nullFillValue(), this.fieldInfo.getTypeClass());
    }

    private static RuntimeException buildException(Class clazz, Field field, String annotationName, String annotationPropertyName, String message) {
        return new RuntimeException(clazz.getName() + "." + field.getName() + " " + annotationName + "  config error,the " + annotationPropertyName + ":" + message);
    }

    private static Object[] parseMiddle(Class clazz, Field field, Fetch fetch) {
        if (fetch.middle() != Void.class) {
            if ("".equals(fetch.middleSourceProperty())) {
                throw FetchInfo.buildException(clazz, field, "@Fetch", "middleSourceProperty", "can't be empty");
            }
            if ("".equals(fetch.middleTargetProperty())) {
                throw FetchInfo.buildException(clazz, field, "@Fetch", "middleTargetProperty", "can't be empty");
            }
        }
        if (!("".equals(fetch.middleSourceProperty()) && "".equals(fetch.middleTargetProperty()) || fetch.middle() != Void.class)) {
            throw FetchInfo.buildException(clazz, field, "@Fetch", "middle", "need set");
        }
        if (fetch.middle() != Void.class && !fetch.middle().isAnnotationPresent(Table.class)) {
            throw FetchInfo.buildException(clazz, field, "@Fetch", "middle", fetch.middle().getName() + " is not a entity");
        }
        TableInfo middleTableInfo = null;
        TableFieldInfo middleSourceTableFieldInfo = null;
        TableFieldInfo middleTargetTableFieldInfo = null;
        if (fetch.middle() != Void.class) {
            middleTableInfo = Tables.get(fetch.middle());
            middleSourceTableFieldInfo = middleTableInfo.getFieldInfo(fetch.middleSourceProperty());
            if (Objects.isNull(middleSourceTableFieldInfo)) {
                throw FetchInfo.buildException(clazz, field, "@Fetch", "middleSourceProperty", fetch.middleSourceProperty() + " is not a entity field");
            }
            middleTargetTableFieldInfo = middleTableInfo.getFieldInfo(fetch.middleTargetProperty());
            if (Objects.isNull(middleTargetTableFieldInfo)) {
                throw FetchInfo.buildException(clazz, field, "@Fetch", "middleTargetProperty", fetch.middleTargetProperty() + " is not a entity field");
            }
        }
        return new Object[]{middleTableInfo, middleSourceTableFieldInfo, middleTargetTableFieldInfo};
    }

    private static Object[] parseTarget(Class clazz, Field field, Fetch fetch) {
        if ("".equals(fetch.targetProperty())) {
            throw FetchInfo.buildException(clazz, field, "@Fetch", "targetProperty", "can't be empty");
        }
        if (!fetch.target().isAnnotationPresent(Table.class)) {
            throw FetchInfo.buildException(clazz, field, "@Fetch", "target", fetch.target().getName() + " is not a entity");
        }
        TableInfo targetTableInfo = Tables.get(fetch.target());
        TableFieldInfo targetTableFieldInfo = targetTableInfo.getFieldInfo(fetch.targetProperty());
        if (Objects.isNull(targetTableFieldInfo)) {
            throw FetchInfo.buildException(clazz, field, "@Fetch", "targetProperty", fetch.targetProperty() + " is not a entity field");
        }
        return new Object[]{targetTableInfo, targetTableFieldInfo};
    }

    private static Object[] parseSourceTargetMatchField(Fetch fetch, Class clazz, Class returnType, FieldInfo fieldInfo, TableInfo targetTableInfo, TableFieldInfo targetTableFieldInfo) {
        boolean sourceTargetMatchFieldInReturnType = false;
        Field sourceTargetMatchField = null;
        if (fetch.middle() != Void.class) {
            return new Object[]{false, null};
        }
        if (returnType.isAnnotationPresent(ResultEntity.class)) {
            ResultInfo resultInfo = ResultInfos.get(returnType);
            Optional<Object> eqFieldOptional = Optional.empty();
            for (ResultFieldInfo item : resultInfo.getResultFieldInfos()) {
                ResultTableFieldInfo resultTableFieldInfo;
                if (!(item instanceof ResultTableFieldInfo) || (resultTableFieldInfo = (ResultTableFieldInfo)item).getField().isAnnotationPresent(Fetch.class) || resultTableFieldInfo.getTableFieldInfo().getField() != targetTableFieldInfo.getField()) continue;
                Field itemField = item.getField();
                eqFieldOptional = Optional.of(itemField);
                break;
            }
            if (eqFieldOptional.isPresent()) {
                sourceTargetMatchField = (Field)eqFieldOptional.get();
            }
        } else if (returnType.isAnnotationPresent(Table.class)) {
            if (returnType != targetTableInfo.getType()) {
                throw new RuntimeException(clazz.getName() + "->" + fieldInfo.getField().getName() + " fetch config error,the type can't be" + returnType.getName());
            }
            sourceTargetMatchField = targetTableFieldInfo.getField();
        }
        sourceTargetMatchFieldInReturnType = sourceTargetMatchField != null;
        return new Object[]{sourceTargetMatchFieldInReturnType, sourceTargetMatchField};
    }

    private static String parseOrderByColumn(Class clazz, Field field, TableInfo middleTableInfo, TableInfo targetTableInfo, String annotationName, String annotationPropertyName, String annotationValue) {
        String value = annotationValue.trim();
        if (value.isEmpty()) {
            return null;
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            return FetchInfo.parseDynamicColumn(clazz, field, middleTableInfo, targetTableInfo, annotationName, annotationPropertyName, value);
        }
        StringBuilder orderByJoin = new StringBuilder();
        String[] strs = value.split(",");
        for (int i = 0; i < strs.length; ++i) {
            String tableAliasName;
            TableInfo tableInfo;
            String str = strs[i];
            String[] ss = str.trim().split(" ");
            if (ss.length > 2) {
                throw FetchInfo.buildException(clazz, field, annotationName, annotationPropertyName, "format error");
            }
            String[] arr = ss[0].split("\\.");
            String property = arr[arr.length - 1];
            if ("".equals(property)) {
                throw FetchInfo.buildException(clazz, field, annotationName, annotationPropertyName, "format error");
            }
            if (arr.length == 2) {
                if (!arr[0].equals("middle") && !arr[0].equals("target")) {
                    throw FetchInfo.buildException(clazz, field, annotationName, annotationPropertyName, "format error, table alias just can be middle or target");
                }
                tableInfo = arr[0].equals("middle") ? middleTableInfo : targetTableInfo;
                tableAliasName = arr[0];
            } else {
                tableInfo = targetTableInfo;
                tableAliasName = middleTableInfo != null ? "target" : "t";
            }
            TableFieldInfo tableFieldInfo = tableInfo.getFieldInfo(property);
            if (Objects.isNull(tableFieldInfo)) {
                throw FetchInfo.buildException(clazz, field, annotationName, annotationPropertyName, " the field:" + property + " is not entity field");
            }
            if (i != 0) {
                orderByJoin.append(",");
            }
            orderByJoin.append(tableAliasName).append(".");
            orderByJoin.append(tableFieldInfo.getColumnName()).append(" ").append(ss[1]);
        }
        return orderByJoin.toString();
    }

    private static String parseDynamicColumn(Class clazz, Field field, TableInfo middleTableInfo, TableInfo targetTableInfo, String annotationName, String annotationPropertyName, String annotationValue) {
        String value = annotationValue.trim();
        if (value.isEmpty()) {
            return null;
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            StringBuilder builder = new StringBuilder();
            int startIndex = 1;
            while (true) {
                String tableAliasName;
                TableInfo tableInfo;
                int start;
                if ((start = value.indexOf("{", startIndex)) == -1) {
                    if (builder.length() == 0 && value.length() <= 2) {
                        throw FetchInfo.buildException(clazz, field, annotationName, annotationPropertyName, "format error");
                    }
                    builder.append(value, startIndex, value.length() - 1);
                    return builder.toString();
                }
                int end = value.indexOf("}", start);
                if (end == -1) {
                    throw FetchInfo.buildException(clazz, field, annotationName, annotationPropertyName, "format error");
                }
                String property = value.substring(start + 1, end);
                String[] arr = property.split("\\.");
                if (arr.length > 2) {
                    throw FetchInfo.buildException(clazz, field, annotationName, annotationPropertyName, "format error");
                }
                if (arr.length == 2) {
                    if (!arr[0].equals("middle") && !arr[0].equals("target")) {
                        throw FetchInfo.buildException(clazz, field, annotationName, annotationPropertyName, "format error, table alias just can be middle or target");
                    }
                    tableInfo = arr[0].equals("middle") ? middleTableInfo : targetTableInfo;
                    tableAliasName = arr[0];
                } else {
                    tableInfo = targetTableInfo;
                    tableAliasName = middleTableInfo != null ? "target" : "t";
                }
                property = arr[arr.length - 1];
                TableFieldInfo tableFieldInfo = tableInfo.getFieldInfo(property);
                if (Objects.isNull(tableFieldInfo)) {
                    throw FetchInfo.buildException(clazz, field, annotationName, annotationPropertyName, property + " is not a entity field");
                }
                builder.append(value, startIndex, start);
                builder.append(tableAliasName).append(".");
                builder.append(tableFieldInfo.getColumnName());
                startIndex = end + 1;
            }
        }
        StringBuilder columns = new StringBuilder();
        String[] strs = value.split(",");
        for (int i = 0; i < strs.length; ++i) {
            String tableAliasName;
            TableInfo tableInfo;
            String property = strs[i].trim();
            if ("".equals(property)) {
                throw FetchInfo.buildException(clazz, field, annotationName, annotationPropertyName, "format error");
            }
            String[] arr = property.split("\\.");
            property = arr[arr.length - 1];
            if (arr.length == 2) {
                if (!arr[0].equals("middle") && !arr[0].equals("target")) {
                    throw FetchInfo.buildException(clazz, field, annotationName, annotationPropertyName, "format error, table alias just can be middle or target");
                }
                tableInfo = arr[0].equals("middle") ? middleTableInfo : targetTableInfo;
                tableAliasName = arr[0];
            } else {
                tableInfo = targetTableInfo;
                tableAliasName = middleTableInfo != null ? "target" : "t";
            }
            TableFieldInfo tableFieldInfo = tableInfo.getFieldInfo(property);
            if (Objects.isNull(tableFieldInfo)) {
                throw FetchInfo.buildException(clazz, field, annotationName, annotationPropertyName, " the field:" + property + " is not entity field");
            }
            if (i != 0) {
                columns.append(",");
            }
            columns.append(tableAliasName).append(".");
            columns.append(tableFieldInfo.getColumnName());
        }
        return columns.toString();
    }

    public void setValue(Object object, Object value, Map<String, Object> defaultValueContext) {
        if (value == null) {
            if (this.fetch.nullFillValue().isEmpty()) {
                return;
            }
            value = this.nullFillValue != null ? this.nullFillValue : XbatisGlobalConfig.getDefaultValue(this.getFieldInfo().getClazz(), this.getFieldInfo().getTypeClass(), this.fetch.nullFillValue(), defaultValueContext);
        }
        try {
            this.writeFieldInvoker.invoke(object, new Object[]{value});
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    @Generated
    public Fetch getFetch() {
        return this.fetch;
    }

    @Generated
    public String getValueColumn() {
        return this.valueColumn;
    }

    @Generated
    public TypeHandler<?> getValueTypeHandler() {
        return this.valueTypeHandler;
    }

    @Generated
    public TableInfo getMiddleTableInfo() {
        return this.middleTableInfo;
    }

    @Generated
    public TableFieldInfo getMiddleSourceTableFieldInfo() {
        return this.middleSourceTableFieldInfo;
    }

    @Generated
    public TableFieldInfo getMiddleTargetTableFieldInfo() {
        return this.middleTargetTableFieldInfo;
    }

    @Generated
    public TableInfo getTargetTableInfo() {
        return this.targetTableInfo;
    }

    @Generated
    public TableFieldInfo getTargetTableFieldInfo() {
        return this.targetTableFieldInfo;
    }

    @Generated
    public String getTargetSelect() {
        return this.targetSelect;
    }

    @Generated
    public String getTargetOrderBy() {
        return this.targetOrderBy;
    }

    @Generated
    public String getOtherConditions() {
        return this.otherConditions;
    }

    @Generated
    public SetFieldInvoker getWriteFieldInvoker() {
        return this.writeFieldInvoker;
    }

    @Generated
    public boolean isMultiple() {
        return this.multiple;
    }

    @Generated
    public Class<?> getReturnType() {
        return this.returnType;
    }

    @Generated
    public boolean isSingleFetch() {
        return this.singleFetch;
    }

    @Generated
    public boolean isGroup() {
        return this.group;
    }

    @Generated
    public boolean isSourceTargetMatchFieldInReturnType() {
        return this.sourceTargetMatchFieldInReturnType;
    }

    @Generated
    public Field getSourceTargetMatchField() {
        return this.sourceTargetMatchField;
    }

    @Generated
    public GetFieldInvoker getSourceTargetMatchFieldGetter() {
        return this.sourceTargetMatchFieldGetter;
    }

    @Generated
    public Object getNullFillValue() {
        return this.nullFillValue;
    }

    @Generated
    public String toString() {
        return "FetchInfo(fieldInfo=" + this.getFieldInfo() + ", fetch=" + this.getFetch() + ", valueColumn=" + this.getValueColumn() + ", valueTypeHandler=" + this.getValueTypeHandler() + ", middleTableInfo=" + this.getMiddleTableInfo() + ", middleSourceTableFieldInfo=" + this.getMiddleSourceTableFieldInfo() + ", middleTargetTableFieldInfo=" + this.getMiddleTargetTableFieldInfo() + ", targetTableInfo=" + this.getTargetTableInfo() + ", targetTableFieldInfo=" + this.getTargetTableFieldInfo() + ", targetSelect=" + this.getTargetSelect() + ", targetOrderBy=" + this.getTargetOrderBy() + ", otherConditions=" + this.getOtherConditions() + ", writeFieldInvoker=" + this.getWriteFieldInvoker() + ", multiple=" + this.isMultiple() + ", returnType=" + this.getReturnType() + ", singleFetch=" + this.isSingleFetch() + ", group=" + this.isGroup() + ", sourceTargetMatchFieldInReturnType=" + this.isSourceTargetMatchFieldInReturnType() + ", sourceTargetMatchField=" + this.getSourceTargetMatchField() + ", sourceTargetMatchFieldGetter=" + this.getSourceTargetMatchFieldGetter() + ", nullFillValue=" + this.getNullFillValue() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FetchInfo)) {
            return false;
        }
        FetchInfo other = (FetchInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMultiple() != other.isMultiple()) {
            return false;
        }
        if (this.isSingleFetch() != other.isSingleFetch()) {
            return false;
        }
        if (this.isGroup() != other.isGroup()) {
            return false;
        }
        if (this.isSourceTargetMatchFieldInReturnType() != other.isSourceTargetMatchFieldInReturnType()) {
            return false;
        }
        FieldInfo this$fieldInfo = this.getFieldInfo();
        FieldInfo other$fieldInfo = other.getFieldInfo();
        if (this$fieldInfo == null ? other$fieldInfo != null : !((Object)this$fieldInfo).equals(other$fieldInfo)) {
            return false;
        }
        Fetch this$fetch = this.getFetch();
        Fetch other$fetch = other.getFetch();
        if (this$fetch == null ? other$fetch != null : !this$fetch.equals(other$fetch)) {
            return false;
        }
        String this$valueColumn = this.getValueColumn();
        String other$valueColumn = other.getValueColumn();
        if (this$valueColumn == null ? other$valueColumn != null : !this$valueColumn.equals(other$valueColumn)) {
            return false;
        }
        TypeHandler<?> this$valueTypeHandler = this.getValueTypeHandler();
        TypeHandler<?> other$valueTypeHandler = other.getValueTypeHandler();
        if (this$valueTypeHandler == null ? other$valueTypeHandler != null : !this$valueTypeHandler.equals(other$valueTypeHandler)) {
            return false;
        }
        TableInfo this$middleTableInfo = this.getMiddleTableInfo();
        TableInfo other$middleTableInfo = other.getMiddleTableInfo();
        if (this$middleTableInfo == null ? other$middleTableInfo != null : !this$middleTableInfo.equals(other$middleTableInfo)) {
            return false;
        }
        TableFieldInfo this$middleSourceTableFieldInfo = this.getMiddleSourceTableFieldInfo();
        TableFieldInfo other$middleSourceTableFieldInfo = other.getMiddleSourceTableFieldInfo();
        if (this$middleSourceTableFieldInfo == null ? other$middleSourceTableFieldInfo != null : !this$middleSourceTableFieldInfo.equals(other$middleSourceTableFieldInfo)) {
            return false;
        }
        TableFieldInfo this$middleTargetTableFieldInfo = this.getMiddleTargetTableFieldInfo();
        TableFieldInfo other$middleTargetTableFieldInfo = other.getMiddleTargetTableFieldInfo();
        if (this$middleTargetTableFieldInfo == null ? other$middleTargetTableFieldInfo != null : !this$middleTargetTableFieldInfo.equals(other$middleTargetTableFieldInfo)) {
            return false;
        }
        TableInfo this$targetTableInfo = this.getTargetTableInfo();
        TableInfo other$targetTableInfo = other.getTargetTableInfo();
        if (this$targetTableInfo == null ? other$targetTableInfo != null : !this$targetTableInfo.equals(other$targetTableInfo)) {
            return false;
        }
        TableFieldInfo this$targetTableFieldInfo = this.getTargetTableFieldInfo();
        TableFieldInfo other$targetTableFieldInfo = other.getTargetTableFieldInfo();
        if (this$targetTableFieldInfo == null ? other$targetTableFieldInfo != null : !this$targetTableFieldInfo.equals(other$targetTableFieldInfo)) {
            return false;
        }
        String this$targetSelect = this.getTargetSelect();
        String other$targetSelect = other.getTargetSelect();
        if (this$targetSelect == null ? other$targetSelect != null : !this$targetSelect.equals(other$targetSelect)) {
            return false;
        }
        String this$targetOrderBy = this.getTargetOrderBy();
        String other$targetOrderBy = other.getTargetOrderBy();
        if (this$targetOrderBy == null ? other$targetOrderBy != null : !this$targetOrderBy.equals(other$targetOrderBy)) {
            return false;
        }
        String this$otherConditions = this.getOtherConditions();
        String other$otherConditions = other.getOtherConditions();
        if (this$otherConditions == null ? other$otherConditions != null : !this$otherConditions.equals(other$otherConditions)) {
            return false;
        }
        SetFieldInvoker this$writeFieldInvoker = this.getWriteFieldInvoker();
        SetFieldInvoker other$writeFieldInvoker = other.getWriteFieldInvoker();
        if (this$writeFieldInvoker == null ? other$writeFieldInvoker != null : !this$writeFieldInvoker.equals(other$writeFieldInvoker)) {
            return false;
        }
        Class<?> this$returnType = this.getReturnType();
        Class<?> other$returnType = other.getReturnType();
        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
            return false;
        }
        Field this$sourceTargetMatchField = this.getSourceTargetMatchField();
        Field other$sourceTargetMatchField = other.getSourceTargetMatchField();
        if (this$sourceTargetMatchField == null ? other$sourceTargetMatchField != null : !((Object)this$sourceTargetMatchField).equals(other$sourceTargetMatchField)) {
            return false;
        }
        GetFieldInvoker this$sourceTargetMatchFieldGetter = this.getSourceTargetMatchFieldGetter();
        GetFieldInvoker other$sourceTargetMatchFieldGetter = other.getSourceTargetMatchFieldGetter();
        if (this$sourceTargetMatchFieldGetter == null ? other$sourceTargetMatchFieldGetter != null : !this$sourceTargetMatchFieldGetter.equals(other$sourceTargetMatchFieldGetter)) {
            return false;
        }
        Object this$nullFillValue = this.getNullFillValue();
        Object other$nullFillValue = other.getNullFillValue();
        return !(this$nullFillValue == null ? other$nullFillValue != null : !this$nullFillValue.equals(other$nullFillValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FetchInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMultiple() ? 79 : 97);
        result = result * 59 + (this.isSingleFetch() ? 79 : 97);
        result = result * 59 + (this.isGroup() ? 79 : 97);
        result = result * 59 + (this.isSourceTargetMatchFieldInReturnType() ? 79 : 97);
        FieldInfo $fieldInfo = this.getFieldInfo();
        result = result * 59 + ($fieldInfo == null ? 43 : ((Object)$fieldInfo).hashCode());
        Fetch $fetch = this.getFetch();
        result = result * 59 + ($fetch == null ? 43 : $fetch.hashCode());
        String $valueColumn = this.getValueColumn();
        result = result * 59 + ($valueColumn == null ? 43 : $valueColumn.hashCode());
        TypeHandler<?> $valueTypeHandler = this.getValueTypeHandler();
        result = result * 59 + ($valueTypeHandler == null ? 43 : $valueTypeHandler.hashCode());
        TableInfo $middleTableInfo = this.getMiddleTableInfo();
        result = result * 59 + ($middleTableInfo == null ? 43 : $middleTableInfo.hashCode());
        TableFieldInfo $middleSourceTableFieldInfo = this.getMiddleSourceTableFieldInfo();
        result = result * 59 + ($middleSourceTableFieldInfo == null ? 43 : $middleSourceTableFieldInfo.hashCode());
        TableFieldInfo $middleTargetTableFieldInfo = this.getMiddleTargetTableFieldInfo();
        result = result * 59 + ($middleTargetTableFieldInfo == null ? 43 : $middleTargetTableFieldInfo.hashCode());
        TableInfo $targetTableInfo = this.getTargetTableInfo();
        result = result * 59 + ($targetTableInfo == null ? 43 : $targetTableInfo.hashCode());
        TableFieldInfo $targetTableFieldInfo = this.getTargetTableFieldInfo();
        result = result * 59 + ($targetTableFieldInfo == null ? 43 : $targetTableFieldInfo.hashCode());
        String $targetSelect = this.getTargetSelect();
        result = result * 59 + ($targetSelect == null ? 43 : $targetSelect.hashCode());
        String $targetOrderBy = this.getTargetOrderBy();
        result = result * 59 + ($targetOrderBy == null ? 43 : $targetOrderBy.hashCode());
        String $otherConditions = this.getOtherConditions();
        result = result * 59 + ($otherConditions == null ? 43 : $otherConditions.hashCode());
        SetFieldInvoker $writeFieldInvoker = this.getWriteFieldInvoker();
        result = result * 59 + ($writeFieldInvoker == null ? 43 : $writeFieldInvoker.hashCode());
        Class<?> $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        Field $sourceTargetMatchField = this.getSourceTargetMatchField();
        result = result * 59 + ($sourceTargetMatchField == null ? 43 : ((Object)$sourceTargetMatchField).hashCode());
        GetFieldInvoker $sourceTargetMatchFieldGetter = this.getSourceTargetMatchFieldGetter();
        result = result * 59 + ($sourceTargetMatchFieldGetter == null ? 43 : $sourceTargetMatchFieldGetter.hashCode());
        Object $nullFillValue = this.getNullFillValue();
        result = result * 59 + ($nullFillValue == null ? 43 : $nullFillValue.hashCode());
        return result;
    }
}

