/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.db.reflect;

import cn.xbatis.core.db.reflect.ConditionItem;
import cn.xbatis.core.db.reflect.ConditionItemGroup;
import cn.xbatis.core.db.reflect.ConditionsItem;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.core.sql.ObjectConditionLifeCycle;
import cn.xbatis.core.util.FieldUtil;
import cn.xbatis.db.Logic;
import cn.xbatis.db.annotations.Condition;
import cn.xbatis.db.annotations.ConditionGroup;
import cn.xbatis.db.annotations.ConditionTarget;
import cn.xbatis.db.annotations.Conditions;
import db.sql.api.impl.cmd.struct.ConditionChain;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConditionInfo {
    private final List<ConditionItemGroup> conditionItemGroups;

    /*
     * WARNING - void declaration
     */
    public ConditionInfo(Class<?> clazz) {
        void var13_16;
        ConditionGroup[] conditionItem;
        Logic logic;
        Class targetTable;
        List<Field> fieldList = FieldUtil.getFields(clazz);
        ArrayList<Object> conditionList = new ArrayList<Object>(fieldList.size());
        if (clazz.isAnnotationPresent(ConditionTarget.class)) {
            ConditionTarget conditionTarget = clazz.getAnnotation(ConditionTarget.class);
            targetTable = conditionTarget.value();
            logic = conditionTarget.logic();
        } else {
            targetTable = clazz;
            logic = Logic.AND;
        }
        HashMap tableInfoMap = new HashMap();
        for (Field field : fieldList) {
            Conditions conditions = field.getAnnotation(Conditions.class);
            if (conditions != null) {
                ArrayList<ConditionItem> subList = new ArrayList<ConditionItem>();
                for (Condition condition : conditions.value()) {
                    ConditionItem conditionItem2 = this.parseConditionAnnotation(field, condition, targetTable, tableInfoMap);
                    if (conditionItem2 == null) continue;
                    subList.add(conditionItem2);
                }
                if (subList.isEmpty()) continue;
                ConditionsItem conditionsItem = new ConditionsItem(field, conditions, subList);
                conditionList.add(conditionsItem);
                continue;
            }
            Condition condition = field.getAnnotation(Condition.class);
            conditionItem = this.parseConditionAnnotation(field, condition, targetTable, tableInfoMap);
            if (conditionItem == null) continue;
            conditionList.add(conditionItem);
        }
        Map<String, Object> conditionItemMap = conditionList.stream().collect(Collectors.toMap(i -> {
            if (i instanceof ConditionItem) {
                return ((ConditionItem)i).getField().getName();
            }
            return ((ConditionsItem)i).getField().getName();
        }, i -> i));
        ConditionGroup[] conditionGroups = (ConditionGroup[])clazz.getAnnotationsByType(ConditionGroup.class);
        HashMap<ConditionGroup, ConditionItemGroup> conditionItemGroupMap = new HashMap<ConditionGroup, ConditionItemGroup>();
        HashSet<String> usedConditionFields = new HashSet<String>();
        conditionItem = conditionGroups;
        int n = conditionItem.length;
        boolean bl = false;
        while (var13_16 < n) {
            ConditionGroup key = conditionItem[var13_16];
            ConditionItemGroup group = conditionItemGroupMap.computeIfAbsent(key, i -> new ConditionItemGroup(false, logic, key.logic(), new ArrayList<Object>()));
            for (String field : key.value()) {
                if (!conditionItemMap.containsKey(field)) {
                    throw new RuntimeException("class " + clazz + " have no field: " + field);
                }
                group.getConditionItems().add(conditionItemMap.get(field));
                usedConditionFields.add(field);
            }
            ++var13_16;
        }
        ArrayList<ConditionItemGroup> itemGroups = new ArrayList<ConditionItemGroup>();
        for (Object e : conditionList) {
            String fieldName = e instanceof ConditionItem ? ((ConditionItem)e).getField().getName() : ((ConditionsItem)e).getField().getName();
            if (usedConditionFields.contains(fieldName)) continue;
            itemGroups.add(new ConditionItemGroup(true, logic, null, Collections.singletonList(e)));
        }
        conditionItemGroupMap.entrySet().stream().forEach(entry -> itemGroups.add((ConditionItemGroup)entry.getValue()));
        this.conditionItemGroups = itemGroups;
    }

    private ConditionItem parseConditionAnnotation(Field field, Condition condition, Class<?> targetTable, Map<Class<?>, TableInfo> tableInfoMap) {
        TableFieldInfo tableFieldInfo;
        if (condition != null && condition.value() == Condition.Type.IGNORE) {
            return null;
        }
        TableInfo tableInfo = condition == null ? tableInfoMap.computeIfAbsent(targetTable, k -> Tables.get(targetTable)) : (condition.target() == Void.class ? tableInfoMap.computeIfAbsent(targetTable, k -> Tables.get(targetTable)) : tableInfoMap.computeIfAbsent(targetTable, k -> Tables.get(condition.target())));
        String property = field.getName();
        if (condition != null && !condition.property().isEmpty()) {
            property = condition.property();
        }
        if ((tableFieldInfo = tableInfo.getFieldInfo(property)) == null) {
            throw new RuntimeException("can not find entity property " + property + " in entity class " + tableInfo.getType());
        }
        return new ConditionItem(field, tableFieldInfo, condition);
    }

    public void appendCondition(ConditionChain conditionChain, Object target) {
        if (target == null) {
            return;
        }
        if (target instanceof ObjectConditionLifeCycle) {
            ObjectConditionLifeCycle objectConditionLifeCycle = (ObjectConditionLifeCycle)target;
            objectConditionLifeCycle.beforeBuildCondition();
        }
        this.conditionItemGroups.stream().forEach(i -> i.appendCondition(conditionChain, target));
    }
}

