/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core;

import cn.xbatis.core.logicDelete.LogicDeleteSwitch;
import cn.xbatis.core.mybatis.mapper.BasicMapper;
import cn.xbatis.core.mybatis.mapper.intercept.MethodInterceptor;
import cn.xbatis.core.sql.SQLBuilder;
import cn.xbatis.core.sql.XbatisSQLBuilder;
import cn.xbatis.core.sql.executor.BaseUpdate;
import cn.xbatis.core.sql.listener.ForeignKeySQLListener;
import cn.xbatis.core.sql.listener.LogicDeleteSQLListener;
import cn.xbatis.core.sql.listener.TenantSQLListener;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.listener.OnInsertListener;
import cn.xbatis.listener.OnUpdateListener;
import db.sql.api.DbType;
import db.sql.api.cmd.listener.SQLListener;
import db.sql.api.impl.paging.IPagingProcessor;
import db.sql.api.impl.paging.PagingProcessorFactory;
import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public final class XbatisGlobalConfig {
    private static final Map<String, Object> CACHE = new ConcurrentHashMap<String, Object>();
    private static final String COLUMN_UNDERLINE = "columnUnderline";
    private static final String TABLE_UNDERLINE = "tableUnderline";
    private static final String DEFAULT_BATCH_SIZE = "defaultBatchSize";
    private static final String SQL_BUILDER = "SQLBuilder";
    private static final String LOGIC_DELETE_SWITCH = "logicDeleteSwitch";
    private static final String LOGIC_DELETE_INTERCEPTOR = "logicDeleteInterceptor";
    private static final String DYNAMIC_VALUE_MANAGER = "dynamicValueManager";
    private static final String SINGLE_MAPPER_CLASS = "singleMapperClass";
    private static final String GLOBAL_ON_INSERT_LISTENER = "globalOnInsertListener";
    private static final String GLOBAL_ON_UPDATE_LISTENER = "globalOnUpdateListener";
    private static final List<SQLListener> SQL_LISTENERS = new ArrayList<SQLListener>();
    private static final List<MethodInterceptor> MAPPER_METHOD_INTERCEPTORS = new ArrayList<MethodInterceptor>();
    private static final Object NULL = new Object();
    private static volatile DbType DEFAULT_DB_TYPE;

    private XbatisGlobalConfig() {
    }

    public static void onInit() {
        XbatisGlobalConfig.setDynamicValue("{BLANK}", (source, type) -> {
            if (type == String.class) {
                return "";
            }
            if (type.isArray()) {
                return Array.newInstance(type, 0);
            }
            if (List.class.isAssignableFrom((Class<?>)type)) {
                return Collections.EMPTY_LIST;
            }
            if (Set.class.isAssignableFrom((Class<?>)type)) {
                return Collections.EMPTY_SET;
            }
            if (Map.class.isAssignableFrom((Class<?>)type)) {
                return Collections.EMPTY_MAP;
            }
            throw new RuntimeException("Inconsistent types\uff1a" + type);
        });
        XbatisGlobalConfig.setDynamicValue("{NOW}", (source, type) -> {
            if (type == LocalDateTime.class) {
                return LocalDateTime.now();
            }
            if (type == LocalDate.class) {
                return LocalDate.now();
            }
            if (type == LocalTime.class) {
                return LocalTime.now();
            }
            if (type == Date.class) {
                return new Date();
            }
            if (type == Long.class) {
                return System.currentTimeMillis();
            }
            if (type == Integer.class) {
                return (int)(System.currentTimeMillis() / 1000L);
            }
            if (type == String.class) {
                return LocalDate.now().toString();
            }
            throw new RuntimeException("Inconsistent types\uff1a" + type);
        });
        XbatisGlobalConfig.setDynamicValue("{TODAY}", (source, type) -> {
            if (type == LocalDate.class) {
                return LocalDate.now();
            }
            if (type == String.class) {
                return LocalDate.now().toString();
            }
            if (type == LocalDate[].class) {
                return new LocalDate[]{LocalDate.now(), LocalDate.now()};
            }
            if (type == LocalDateTime[].class) {
                return new LocalDateTime[]{LocalDate.now().atStartOfDay(), LocalDate.now().atStartOfDay().plusDays(1L).minusNanos(1L)};
            }
            if (type == Long[].class) {
                long time = LocalDate.now().toEpochDay();
                return new Long[]{time, time + TimeUnit.DAYS.toMillis(1L) - 1L};
            }
            if (type == String[].class) {
                String today = LocalDate.now().toString();
                return new String[]{today, today + "23:59:59"};
            }
            if (type == List.class) {
                ArrayList<LocalDateTime> list = new ArrayList<LocalDateTime>();
                list.add(LocalDate.now().atStartOfDay());
                list.add(LocalDate.now().atStartOfDay().plusDays(1L).minusNanos(1L));
                return list;
            }
            throw new RuntimeException("Inconsistent types\uff1a" + type);
        });
    }

    public static DbType getDefaultDbType() {
        return DEFAULT_DB_TYPE;
    }

    public static void setDefaultDbType(DbType defaultDbType) {
        DEFAULT_DB_TYPE = defaultDbType;
    }

    public static boolean isColumnUnderline() {
        return (Boolean)CACHE.computeIfAbsent(COLUMN_UNDERLINE, key -> true);
    }

    public static void setColumnUnderline(boolean bool) {
        CACHE.putIfAbsent(COLUMN_UNDERLINE, bool);
    }

    public static boolean isTableUnderline() {
        return (Boolean)CACHE.computeIfAbsent(TABLE_UNDERLINE, key -> true);
    }

    public static void setTableUnderline(boolean bool) {
        CACHE.putIfAbsent(TABLE_UNDERLINE, bool);
    }

    public static int getDefaultBatchSize() {
        return (Integer)CACHE.computeIfAbsent(DEFAULT_BATCH_SIZE, key -> 1000);
    }

    public static void setDefaultBatchSize(int defaultBatchSize) {
        if (defaultBatchSize < 1) {
            throw new RuntimeException("defaultBatchSize can't less 1");
        }
        CACHE.put(DEFAULT_BATCH_SIZE, defaultBatchSize);
    }

    public static SQLBuilder getSQLBuilder() {
        return (SQLBuilder)CACHE.computeIfAbsent(SQL_BUILDER, key -> new XbatisSQLBuilder());
    }

    public static void setSQLBuilder(SQLBuilder sqlBuilder) {
        CACHE.put(SQL_BUILDER, sqlBuilder);
    }

    public static boolean isLogicDeleteSwitchOpen() {
        Boolean state = LogicDeleteSwitch.getState();
        if (state != null) {
            return state;
        }
        return (Boolean)CACHE.computeIfAbsent(LOGIC_DELETE_SWITCH, key -> true);
    }

    public static BiConsumer<Class<?>, BaseUpdate<?>> getLogicDeleteInterceptor() {
        return (BiConsumer)CACHE.get(LOGIC_DELETE_INTERCEPTOR);
    }

    public static void setLogicDeleteInterceptor(BiConsumer<Class<?>, BaseUpdate<?>> interceptor) {
        CACHE.putIfAbsent(LOGIC_DELETE_INTERCEPTOR, interceptor);
    }

    public static void setLogicDeleteSwitch(boolean bool) {
        CACHE.putIfAbsent(LOGIC_DELETE_SWITCH, bool);
    }

    public static boolean isDynamicValueKeyFormat(String key) {
        return key.startsWith("{") && key.endsWith("}");
    }

    public static void setDynamicValue(String key, BiFunction<Class<?>, Class<?>, Object> f) {
        if (!XbatisGlobalConfig.isDynamicValueKeyFormat(key)) {
            key = "{" + key + "}";
        }
        ((Map)CACHE.get(DYNAMIC_VALUE_MANAGER)).computeIfAbsent(key, mapKey -> f);
    }

    public static void checkDynamicValueKey(String key) {
        if (!XbatisGlobalConfig.isDynamicValueKeyFormat(key)) {
            throw new RuntimeException("key must start with '{' and end with '}'");
        }
    }

    @Deprecated
    public static void setDefaultValue(String key, BiFunction<Class<?>, Class<?>, Object> f) {
        XbatisGlobalConfig.setDynamicValue(key, f);
    }

    public static <T> T getDefaultValue(Class<?> clazz, Class<T> type, String key) {
        if (!XbatisGlobalConfig.isDynamicValueKeyFormat(key)) {
            return TypeConvertUtil.convert(key, type);
        }
        return XbatisGlobalConfig.getDynamicValue(clazz, type, key);
    }

    public static <T> T getDefaultValue(Class<?> clazz, Class<T> type, String key, Map<String, Object> context) {
        if (!XbatisGlobalConfig.isDynamicValueKeyFormat(key)) {
            return TypeConvertUtil.convert(key, type);
        }
        return XbatisGlobalConfig.getDynamicValue(clazz, type, key, context);
    }

    public static <T> T getDynamicValue(Class<?> clazz, Class<T> type, String key) {
        Map map;
        BiFunction f;
        if (!XbatisGlobalConfig.isDynamicValueKeyFormat(key)) {
            key = "{" + key + "}";
        }
        if ((f = (BiFunction)(map = (Map)CACHE.get(DYNAMIC_VALUE_MANAGER)).get(key)) == null) {
            throw new RuntimeException("default value key:  " + key + " not set");
        }
        return (T)f.apply(clazz, type);
    }

    public static <T> T getDynamicValue(Class<?> clazz, Class<T> type, String key, Map<String, Object> context) {
        Object obj;
        if (context == null) {
            return XbatisGlobalConfig.getDynamicValue(clazz, type, key);
        }
        if (!XbatisGlobalConfig.isDynamicValueKeyFormat(key)) {
            key = "{" + key + "}";
        }
        if ((obj = context.get(key)) == null) {
            obj = XbatisGlobalConfig.getDynamicValue(clazz, type, key);
            if (obj == null) {
                obj = NULL;
            }
            context.put(key, obj);
        }
        if (obj == null || obj == NULL) {
            return null;
        }
        return (T)obj;
    }

    public static Class<? extends BasicMapper> getSingleMapperClass() {
        return (Class)CACHE.computeIfAbsent(SINGLE_MAPPER_CLASS, key -> BasicMapper.class);
    }

    public static void setSingleMapperClass(Class<? extends BasicMapper> singleMapperClass) {
        CACHE.putIfAbsent(SINGLE_MAPPER_CLASS, singleMapperClass);
    }

    public static void addSQLListener(SQLListener sqlListener) {
        SQL_LISTENERS.add(sqlListener);
    }

    public static <T extends SQLListener> void removeSQLListener(Class<T> type) {
        Iterator<SQLListener> iterator = SQL_LISTENERS.iterator();
        while (iterator.hasNext()) {
            if (!type.isAssignableFrom(iterator.next().getClass())) continue;
            iterator.remove();
        }
    }

    public static List<SQLListener> getSQLListeners() {
        return Collections.unmodifiableList(SQL_LISTENERS);
    }

    public static void setPagingProcessor(DbType dbType, IPagingProcessor pagingProcessor) {
        PagingProcessorFactory.setProcessor((DbType)dbType, (IPagingProcessor)pagingProcessor);
    }

    public static IPagingProcessor getPagingProcessor(DbType dbType) {
        return PagingProcessorFactory.getProcessor((DbType)dbType);
    }

    public static void addMapperMethodInterceptor(MethodInterceptor methodInterceptor) {
        MAPPER_METHOD_INTERCEPTORS.add(methodInterceptor);
    }

    public static <T extends MethodInterceptor> void removeMapperMethodInterceptor(Class<T> type) {
        Iterator<MethodInterceptor> iterator = MAPPER_METHOD_INTERCEPTORS.iterator();
        while (iterator.hasNext()) {
            if (!type.isAssignableFrom(iterator.next().getClass())) continue;
            iterator.remove();
        }
    }

    public static List<MethodInterceptor> getMapperMethodInterceptors() {
        return Collections.unmodifiableList(MAPPER_METHOD_INTERCEPTORS);
    }

    public static OnInsertListener getGlobalOnInsertListener() {
        Object listener = CACHE.computeIfAbsent(GLOBAL_ON_INSERT_LISTENER, k -> NULL);
        if (listener == NULL) {
            return null;
        }
        return (OnInsertListener)listener;
    }

    public static void setGlobalOnInsertListener(OnInsertListener<?> listener) {
        CACHE.putIfAbsent(GLOBAL_ON_INSERT_LISTENER, listener);
    }

    public static OnUpdateListener<?> getGlobalOnUpdateListener() {
        Object listener = CACHE.computeIfAbsent(GLOBAL_ON_UPDATE_LISTENER, k -> NULL);
        if (listener == NULL) {
            return null;
        }
        return (OnUpdateListener)listener;
    }

    public static void setGlobalOnUpdateListener(OnUpdateListener<?> listener) {
        CACHE.putIfAbsent(GLOBAL_ON_UPDATE_LISTENER, listener);
    }

    static {
        SQL_LISTENERS.add(new ForeignKeySQLListener());
        SQL_LISTENERS.add(new TenantSQLListener());
        SQL_LISTENERS.add(new LogicDeleteSQLListener());
        CACHE.put(DYNAMIC_VALUE_MANAGER, new ConcurrentHashMap());
    }
}

