/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.util;

import java.util.List;
import java.util.Objects;

public final class NamingUtil {
    private static boolean isBlank(String str) {
        if (Objects.isNull(str)) {
            return true;
        }
        return "".equals(str);
    }

    public static String camelToUnderline(String name) {
        if (NamingUtil.isBlank(name)) {
            return name;
        }
        int length = name.length();
        StringBuilder sb = new StringBuilder(length + length / 4);
        for (char c : name.toCharArray()) {
            char lower = Character.toLowerCase(c);
            if (lower != c && sb.length() > 0) {
                sb.append('_');
            }
            sb.append(lower);
        }
        return sb.toString();
    }

    public static String underlineToCamel(String name) {
        if (NamingUtil.isBlank(name)) {
            return name;
        }
        int length = name.length();
        StringBuilder sb = new StringBuilder(length);
        boolean matchedUnderline = false;
        for (char c : name.toCharArray()) {
            if (matchedUnderline) {
                if (c == '_') continue;
                sb.append(Character.toUpperCase(c));
                matchedUnderline = false;
                continue;
            }
            boolean bl = matchedUnderline = c == '_';
            if (matchedUnderline) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String firstToLower(String name) {
        if (NamingUtil.isBlank(name)) {
            return name;
        }
        char first = name.charAt(0);
        if (Character.isLowerCase(first)) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(first);
        return new String(chars);
    }

    public static String firstToUpperCase(String name) {
        if (NamingUtil.isBlank(name)) {
            return name;
        }
        char first = name.charAt(0);
        if (Character.isUpperCase(first)) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(first);
        return new String(chars);
    }

    public static String removePrefix(String original, List<String> prefixes) {
        if (prefixes == null || prefixes.isEmpty()) {
            return original;
        }
        for (String prefix : prefixes) {
            String target = NamingUtil.removePrefix(original, prefix);
            if (Objects.equals(target, original)) continue;
            return target;
        }
        return original;
    }

    public static String removePrefix(String original, String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return original;
        }
        if (original.startsWith(prefix)) {
            return original.substring(prefix.length());
        }
        return original;
    }

    public static void main(String[] args) {
        System.out.println(NamingUtil.camelToUnderline("UserTable"));
        System.out.println(NamingUtil.camelToUnderline("user_table"));
        System.out.println(NamingUtil.camelToUnderline("User_table"));
        System.out.println(NamingUtil.underlineToCamel("UserTable"));
        System.out.println(NamingUtil.underlineToCamel("user_table"));
        System.out.println(NamingUtil.underlineToCamel("User_table"));
    }
}

