/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.sql.util;

import cn.xbatis.core.db.reflect.NestedResultInfo;
import cn.xbatis.core.db.reflect.ResultFieldInfo;
import cn.xbatis.core.db.reflect.ResultInfo;
import cn.xbatis.core.db.reflect.ResultInfos;
import cn.xbatis.core.db.reflect.ResultTableFieldInfo;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.db.annotations.ResultEntity;
import cn.xbatis.db.annotations.Table;
import db.sql.api.Cmd;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.executor.AbstractQuery;
import java.util.ArrayList;
import java.util.List;

public final class SelectClassUtil {
    private static void buildSelect(AbstractQuery query, List<ResultFieldInfo> resultFieldInfos, List<Cmd> cmdList) {
        resultFieldInfos.stream().filter(item -> item instanceof ResultTableFieldInfo).forEach(item -> {
            ResultTableFieldInfo resultTableFieldInfo = (ResultTableFieldInfo)item;
            TableField tableField = query.$().field(resultTableFieldInfo.getTableInfo().getType(), resultTableFieldInfo.getTableFieldInfo().getField().getName(), resultTableFieldInfo.getStorey());
            if (!cmdList.contains(tableField)) {
                cmdList.add((Cmd)tableField);
            }
        });
    }

    private static void buildNestedSelect(AbstractQuery query, List<NestedResultInfo> nestedResultInfos, List<Cmd> cmdList) {
        nestedResultInfos.forEach(item -> {
            SelectClassUtil.buildSelect(query, item.getResultFieldInfos(), cmdList);
            SelectClassUtil.buildNestedSelect(query, item.getNestedResultInfos(), cmdList);
        });
    }

    private static List<Cmd> buildSelect(AbstractQuery query, Class clazz, int storey, List<Cmd> cmdList) {
        if (clazz.isAnnotationPresent(ResultEntity.class)) {
            ResultInfo resultInfo = ResultInfos.get(clazz);
            SelectClassUtil.buildSelect(query, resultInfo.getResultFieldInfos(), cmdList);
            SelectClassUtil.buildNestedSelect(query, resultInfo.getNestedResultInfos(), cmdList);
        } else if (clazz.isAnnotationPresent(Table.class)) {
            TableInfo tableInfo = Tables.get(clazz);
            for (int i = 0; i < tableInfo.getFieldSize(); ++i) {
                TableFieldInfo tableFieldInfo = tableInfo.getTableFieldInfos().get(i);
                if (!tableFieldInfo.getTableFieldAnnotation().select()) continue;
                cmdList.add((Cmd)query.$().field(clazz, tableFieldInfo.getField().getName(), storey));
            }
        }
        return cmdList;
    }

    public static boolean select(AbstractQuery query, Class clazz) {
        return SelectClassUtil.select(query, clazz, 1);
    }

    public static boolean select(AbstractQuery query, Class clazz, int storey) {
        ArrayList<Cmd> list = new ArrayList<Cmd>();
        query.select(SelectClassUtil.buildSelect(query, clazz, storey, list));
        return !list.isEmpty();
    }

    public static void select(AbstractQuery query, int storey, Class[] entities) {
        ArrayList<Cmd> list = new ArrayList<Cmd>();
        for (Class entity : entities) {
            SelectClassUtil.buildSelect(query, entity, storey, list);
        }
        query.select(list);
    }
}

