/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.provider;

import cn.xbatis.core.function.ThreeFunction;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdCountFromQueryContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdCountQueryContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdDeleteContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdInsertContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdQueryContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdUpdateContext;
import cn.xbatis.core.mybatis.provider.MybatisSQLProvider;
import cn.xbatis.core.util.DbTypeUtil;
import db.sql.api.DbType;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;

public class SQLCmdSqlSource
implements SqlSource {
    private static final Map<String, ThreeFunction<Object, ProviderContext, DbType, String>> SQL_GENERATOR_FUN_MAP = new HashMap<String, ThreeFunction<Object, ProviderContext, DbType, String>>();
    private final Configuration configuration;
    private final Method providerMethod;
    private final ProviderContext providerContext;
    private DbType dbType;

    public SQLCmdSqlSource(Configuration configuration, Method providerMethod, ProviderContext providerContext) {
        this.configuration = configuration;
        this.providerMethod = providerMethod;
        this.providerContext = providerContext;
    }

    public BoundSql getBoundSql(Object parameterObject) {
        String methodName = this.providerMethod.getName();
        ThreeFunction<Object, ProviderContext, DbType, String> sqlGenerator = SQL_GENERATOR_FUN_MAP.get(methodName);
        if (Objects.isNull(sqlGenerator)) {
            throw new RuntimeException("Unadapted: Unknown SQL method: " + methodName);
        }
        String sql = sqlGenerator.apply(parameterObject, this.providerContext, this.getDbType());
        return new BoundSql(this.configuration, sql, Collections.emptyList(), parameterObject);
    }

    public DbType getDbType() {
        if (Objects.isNull(this.dbType)) {
            this.dbType = DbTypeUtil.getDbType(this.configuration);
        }
        return this.dbType;
    }

    static {
        SQL_GENERATOR_FUN_MAP.put("cmdQuery", (context, providerContext, dbType) -> MybatisSQLProvider.cmdQuery((SQLCmdQueryContext)context, providerContext, dbType));
        SQL_GENERATOR_FUN_MAP.put("getCmdQuery", (context, providerContext, dbType) -> MybatisSQLProvider.getCmdQuery((SQLCmdQueryContext)context, providerContext, dbType));
        SQL_GENERATOR_FUN_MAP.put("getByIdCmdQuery", (context, providerContext, dbType) -> MybatisSQLProvider.getByIdCmdQuery((SQLCmdQueryContext)context, providerContext, dbType));
        SQL_GENERATOR_FUN_MAP.put("cmdCount", (context, providerContext, dbType) -> MybatisSQLProvider.cmdCount((SQLCmdCountQueryContext)context, providerContext, dbType));
        SQL_GENERATOR_FUN_MAP.put("countFromQuery", (context, providerContext, dbType) -> MybatisSQLProvider.countFromQuery((SQLCmdCountFromQueryContext)context, providerContext, dbType));
        SQL_GENERATOR_FUN_MAP.put("update", (context, providerContext, dbType) -> MybatisSQLProvider.update((SQLCmdUpdateContext)context, providerContext, dbType));
        SQL_GENERATOR_FUN_MAP.put("delete", (context, providerContext, dbType) -> MybatisSQLProvider.delete((SQLCmdDeleteContext)context, providerContext, dbType));
        SQL_GENERATOR_FUN_MAP.put("save", (context, providerContext, dbType) -> MybatisSQLProvider.save((SQLCmdInsertContext)context, providerContext, dbType));
    }
}

