/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.mappers.utils;

import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.logicDelete.LogicDeleteUtil;
import cn.xbatis.core.mybatis.mapper.BasicMapper;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveOrUpdateStrategy;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveStrategy;
import cn.xbatis.core.mybatis.mapper.context.strategy.UpdateStrategy;
import cn.xbatis.core.mybatis.mapper.mappers.utils.SaveMethodUtil;
import cn.xbatis.core.mybatis.mapper.mappers.utils.UpdateMethodUtil;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.Query;
import cn.xbatis.core.sql.util.WhereUtil;
import cn.xbatis.core.util.TableInfoUtil;
import db.sql.api.Cmd;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.struct.Where;
import java.util.Collection;
import java.util.Objects;

public class SaveOrUpdateMethodUtil {
    public static <T> int saveOrUpdate(BasicMapper basicMapper, TableInfo tableInfo, T entity, SaveOrUpdateStrategy saveOrUpdateStrategy) {
        Class<?> entityType = entity.getClass();
        boolean checkById = true;
        if (saveOrUpdateStrategy.getOn() != null) {
            checkById = false;
        }
        Where checkWhere = WhereUtil.create(tableInfo);
        if (checkById) {
            Object id;
            if (tableInfo.getIdFieldInfos().isEmpty()) {
                throw new RuntimeException(entityType.getName() + " has no id");
            }
            try {
                id = tableInfo.getIdFieldInfos().get(0).getReadFieldInvoker().invoke(entity, null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (Objects.isNull(id)) {
                SaveStrategy saveStrategy = new SaveStrategy().allFieldSave(saveOrUpdateStrategy.isAllField()).forceFields(saveOrUpdateStrategy.getForceFields());
                return SaveMethodUtil.save(basicMapper, tableInfo, entity, saveStrategy);
            }
            WhereUtil.appendIdWhereWithEntity(checkWhere, tableInfo, entity);
        } else {
            saveOrUpdateStrategy.getOn().accept(checkWhere);
        }
        Query query = new Query(checkWhere);
        ((MybatisCmdFactory)query.$()).cacheTableInfo(tableInfo);
        Table table = query.$(entityType);
        if (saveOrUpdateStrategy.isIgnoreLogicDeleteWhenCheck()) {
            LogicDeleteUtil.execute(false, () -> ((Query)query.from((IDataset)table)).returnType(entityType));
        } else {
            ((Query)query.from((IDataset)table)).returnType(entityType);
        }
        for (String c : tableInfo.getIdColumnNames()) {
            query.select((Cmd)table.$(c));
        }
        Object obj = basicMapper.get(query);
        if (obj == null) {
            SaveStrategy saveStrategy = new SaveStrategy().allFieldSave(saveOrUpdateStrategy.isAllField()).forceFields(saveOrUpdateStrategy.getForceFields());
            return SaveMethodUtil.save(basicMapper, tableInfo, entity, saveStrategy);
        }
        UpdateStrategy updateStrategy = new UpdateStrategy();
        if (tableInfo.getIdFieldInfos().isEmpty()) {
            updateStrategy.on(query.$where());
        } else {
            tableInfo.getIdFieldInfos().stream().forEach(item -> TableInfoUtil.setValue(item, entity, TableInfoUtil.getEntityFieldValue(item, obj)));
        }
        updateStrategy.allFieldUpdate(saveOrUpdateStrategy.isAllField()).forceFields(saveOrUpdateStrategy.getForceFields());
        return UpdateMethodUtil.update(basicMapper, tableInfo, entity, updateStrategy);
    }

    public static <T> int saveOrUpdate(BasicMapper basicMapper, TableInfo tableInfo, Collection<T> list, SaveOrUpdateStrategy saveOrUpdateStrategy) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return 0;
        }
        int cnt = 0;
        for (T entity : list) {
            cnt += SaveOrUpdateMethodUtil.saveOrUpdate(basicMapper, tableInfo, entity, saveOrUpdateStrategy);
        }
        return cnt;
    }
}

