/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.mybatis.mapper.context.EntityInsertCreateUtil;
import cn.xbatis.core.mybatis.mapper.context.IdUtil;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdInsertContext;
import cn.xbatis.core.mybatis.mapper.context.SetIdMethod;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveStrategy;
import cn.xbatis.core.sql.executor.BaseInsert;
import db.sql.api.DbType;
import java.util.Objects;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;

public class EntityInsertContext<T>
extends SQLCmdInsertContext<BaseInsert, T>
implements SetIdMethod {
    private final BaseInsert<?> insert;
    private final T entity;
    private final TableInfo tableInfo;
    private final SaveStrategy strategy;
    private final boolean idHasValue;

    public EntityInsertContext(BaseInsert<?> insert, TableInfo tableInfo, T entity, SaveStrategy strategy) {
        this.insert = insert;
        this.entity = entity;
        this.strategy = strategy;
        this.entityType = entity.getClass();
        this.tableInfo = tableInfo;
        this.idHasValue = IdUtil.isIdExists(entity, tableInfo.getIdFieldInfo());
    }

    @Override
    public void init(DbType dbType) {
        super.init(dbType);
        if (Objects.isNull(this.execution)) {
            this.execution = this.createCmd(dbType);
        }
    }

    private BaseInsert createCmd(DbType dbType) {
        return EntityInsertCreateUtil.create(this.insert, this.tableInfo, this.entity, this.strategy, dbType);
    }

    @Override
    public void setId(Object id, int index) {
        IdUtil.setId(this.entity, this.tableInfo.getSingleIdFieldInfo(true), id);
    }

    @Override
    public boolean idHasValue() {
        return this.idHasValue;
    }

    @Override
    public int getInsertSize() {
        return 1;
    }

    @Override
    public Object getInsertData(int index) {
        return this.entity;
    }

    @Override
    public TypeHandler<?> getIdTypeHandler(Configuration configuration) {
        TypeHandler<?> typeHandler;
        if (Objects.nonNull(this.tableInfo.getIdFieldInfo()) && Objects.isNull(typeHandler = this.tableInfo.getIdFieldInfo().getTypeHandler())) {
            return configuration.getTypeHandlerRegistry().getTypeHandler(this.tableInfo.getIdFieldInfo().getFieldInfo().getTypeClass());
        }
        return null;
    }

    @Override
    public String getIdColumnName() {
        return this.tableInfo.getIdFieldInfo().getColumnName();
    }
}

