/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.mybatis.mapper.context.SQLCmdContext;
import cn.xbatis.core.mybatis.provider.MybatisSqlBuilderContext;
import db.sql.api.DbType;
import db.sql.api.SQLMode;
import db.sql.api.SqlBuilderContext;
import db.sql.api.impl.cmd.executor.Executor;
import db.sql.api.impl.tookit.SQLOptimizeUtils;
import java.util.List;
import java.util.Objects;

public abstract class BaseSQLCmdContext<E extends Executor>
implements SQLCmdContext<E> {
    protected MybatisSqlBuilderContext sqlBuilderContext;
    protected String sql;
    protected E execution;
    private DbType dbType;

    public BaseSQLCmdContext() {
    }

    public BaseSQLCmdContext(E execution) {
        this.execution = execution;
    }

    @Override
    public E getExecution() {
        return this.execution;
    }

    @Override
    public void init(DbType dbType) {
        this.dbType = dbType;
    }

    @Override
    public String sql(DbType dbType) {
        if (Objects.nonNull(this.sql)) {
            return this.sql;
        }
        this.sqlBuilderContext = new MybatisSqlBuilderContext(dbType, SQLMode.PREPARED);
        this.sql = this.getExecution().sql(null, null, (SqlBuilderContext)this.sqlBuilderContext, new StringBuilder(SQLOptimizeUtils.getStringBuilderCapacity((List)this.getExecution().cmds()))).toString();
        return this.sql;
    }

    @Override
    public Object[] getParameters() {
        return this.sqlBuilderContext.getParams();
    }

    public DbType getDbType() {
        return this.dbType;
    }
}

