/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper;

import cn.xbatis.core.function.ThreeFunction;
import cn.xbatis.core.mybatis.mapper.BaseMapper;
import cn.xbatis.core.mybatis.mapper.DbRunner;
import cn.xbatis.core.mybatis.mapper.context.MapKeySQLCmdQueryContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdCountFromQueryContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdCountQueryContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdDeleteContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdInsertContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdQueryContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdUpdateContext;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.CountBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.CursorBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.DeleteBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.ExistsBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.GetBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.ListBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.MapWithKeyBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.PagingBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.SaveBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.SaveModelBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.SaveOrUpdateBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.SaveOrUpdateModelBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.UpdateBasicMapper;
import cn.xbatis.core.mybatis.mapper.mappers.basicMapper.UpdateModelBasicMapper;
import cn.xbatis.core.mybatis.provider.TablePrefixUtil;
import cn.xbatis.core.sql.executor.BaseDelete;
import cn.xbatis.core.sql.executor.BaseInsert;
import cn.xbatis.core.sql.executor.BaseQuery;
import cn.xbatis.core.sql.executor.BaseUpdate;
import cn.xbatis.page.IPager;
import cn.xbatis.page.PageUtil;
import cn.xbatis.page.PagerField;
import db.sql.api.DbType;
import db.sql.api.impl.cmd.executor.SelectorCall;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

@Mapper
public interface BasicMapper
extends BaseMapper,
GetBasicMapper,
ExistsBasicMapper,
CountBasicMapper,
ListBasicMapper,
CursorBasicMapper,
PagingBasicMapper,
MapWithKeyBasicMapper,
SaveBasicMapper,
SaveOrUpdateBasicMapper,
SaveModelBasicMapper,
SaveOrUpdateModelBasicMapper,
UpdateBasicMapper,
UpdateModelBasicMapper,
DeleteBasicMapper,
DbRunner {
    public DbType getCurrentDbType();

    public <R> R dbAdapt(Consumer<SelectorCall<R>> var1);

    @Override
    default public BasicMapper getBasicMapper() {
        return this;
    }

    public <R> R withSqlSession(Function<SqlSession, R> var1);

    public <R> R withSqlSession(String var1, BiFunction<String, SqlSession, R> var2);

    public <R, PARAMS> R withSqlSession(String var1, PARAMS var2, ThreeFunction<String, PARAMS, SqlSession, R> var3);

    public <R> R withSqlSession(Class var1, String var2, BiFunction<String, SqlSession, R> var3);

    public <R, PARAMS> R withSqlSession(Class var1, String var2, PARAMS var3, ThreeFunction<String, PARAMS, SqlSession, R> var4);

    @Override
    default public <T> T get(BaseQuery<? extends BaseQuery, T> query) {
        return (T)this.$get(new SQLCmdQueryContext(query), new RowBounds(0, 2));
    }

    @Override
    default public boolean exists(BaseQuery<? extends BaseQuery, ?> query) {
        if (Objects.isNull(query.getSelect())) {
            query.select1();
        }
        query.dbAdapt((q, selector) -> selector.when(DbType.SQL_SERVER, () -> {
            query.getSelect().top(1);
            query.removeLimit();
        }).otherwise(() -> query.limit(1)));
        query.setReturnType(Integer.class);
        Integer obj = (Integer)this.get(query);
        return Objects.nonNull(obj) && obj >= 1;
    }

    @Override
    default public int save(BaseInsert<?> insert) {
        return this.$save(new SQLCmdInsertContext(insert));
    }

    @Override
    default public int update(BaseUpdate<?> update) {
        return this.$update(new SQLCmdUpdateContext(update));
    }

    @Override
    default public int delete(BaseDelete<?> delete) {
        return this.$delete(new SQLCmdDeleteContext(delete));
    }

    @Override
    default public <T> List<T> list(BaseQuery<? extends BaseQuery, T> query) {
        return this.$list(new SQLCmdQueryContext(query));
    }

    @Override
    default public <T> Cursor<T> cursor(BaseQuery<? extends BaseQuery, T> query) {
        return this.$cursor(new SQLCmdQueryContext(query));
    }

    @Override
    default public Integer count(BaseQuery<? extends BaseQuery, ?> query) {
        query.setReturnType(Integer.class);
        return this.$count(new SQLCmdCountQueryContext(query));
    }

    @Override
    default public <T, P extends IPager<T>> P paging(BaseQuery<? extends BaseQuery, T> query, P pager) {
        Boolean executeCount = (Boolean)pager.get(PagerField.IS_EXECUTE_COUNT);
        Integer size = (Integer)pager.get(PagerField.SIZE);
        if (executeCount.booleanValue() && size > -1) {
            Class returnType = query.getReturnType();
            TablePrefixUtil.prefixMapping(query, returnType);
            query.setReturnType(Integer.class);
            Integer count = this.$countFromQuery(new SQLCmdCountFromQueryContext(query));
            query.setReturnType(returnType);
            Integer total = Optional.of(count).orElse(0);
            pager.set(PagerField.TOTAL, (Object)total);
            if (total < 1) {
                pager.set(PagerField.RESULTS, Collections.emptyList());
                return pager;
            }
        }
        Integer number = (Integer)pager.get(PagerField.NUMBER);
        query.limit(PageUtil.getOffset((int)number, (int)size), size);
        List<T> list = this.list(query);
        pager.set(PagerField.RESULTS, list);
        if (executeCount.booleanValue() && size < 0) {
            pager.set(PagerField.TOTAL, (Object)list.size());
        }
        return pager;
    }

    @Override
    default public <K, V> Map<K, V> mapWithKey(String mapKey, BaseQuery<? extends BaseQuery, V> query) {
        return this.$mapWithKey(new MapKeySQLCmdQueryContext(mapKey, query));
    }
}

