/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.executor.resultset;

import cn.xbatis.core.db.reflect.CreatedEventInfo;
import cn.xbatis.core.db.reflect.FetchInfo;
import cn.xbatis.core.db.reflect.PutEnumValueInfo;
import cn.xbatis.core.db.reflect.PutValueInfo;
import cn.xbatis.core.db.reflect.ResultInfo;
import cn.xbatis.core.db.reflect.ResultInfos;
import cn.xbatis.core.mybatis.executor.BasicMapperThreadLocalUtil;
import cn.xbatis.core.mybatis.executor.resultset.DefaultResultSetHandler;
import cn.xbatis.core.mybatis.executor.resultset.FetchKeyValue;
import cn.xbatis.core.mybatis.executor.resultset.FetchObject;
import cn.xbatis.core.mybatis.mapper.BasicMapper;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdQueryContext;
import cn.xbatis.core.sql.executor.BaseQuery;
import cn.xbatis.core.sql.executor.Query;
import cn.xbatis.core.util.CreatedEventUtil;
import cn.xbatis.core.util.PutEnumValueUtil;
import cn.xbatis.core.util.PutValueUtil;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.annotations.ResultEntity;
import db.sql.api.Cmd;
import db.sql.api.cmd.basic.IOrderByDirection;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.Column;
import db.sql.api.impl.cmd.basic.OrderByDirection;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.impl.cmd.struct.query.Select;
import db.sql.api.impl.tookit.OptimizeOptions;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetWrapper;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.util.MapUtil;

public class MybatisDefaultResultSetHandler
extends DefaultResultSetHandler {
    private final Map<FetchInfo, Map<Object, List<Object>>> singleFetchCache = new HashMap<FetchInfo, Map<Object, List<Object>>>();
    private final Map<Method, Map> createdEventContextMap = new HashMap<Method, Map>();
    private BasicMapper basicMapper;
    private Map<FetchInfo, List<FetchObject>> needFetchValuesMap;
    private Map<Class, List<FetchInfo>> fetchInfosMap;
    private Map<String, Consumer<Where>> fetchFilters;
    private Map<String, Boolean> fetchEnables;
    private Consumer onRowEvent;
    private Class<?> returnType;
    private Map<Class, List<PutEnumValueInfo>> putEnumValueInfoMap;
    private Map<Class, List<PutValueInfo>> putValueInfoMap;
    private Map<String, Object> putValueSessionCache;
    private Map<Class, List<CreatedEventInfo>> createdEventInfos;

    public MybatisDefaultResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler<?> resultHandler, BoundSql boundSql, RowBounds rowBounds) {
        super(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds);
        if (mappedStatement.getResultMaps().size() == 1) {
            Class returnType = ((ResultMap)mappedStatement.getResultMaps().get(0)).getType();
            if (returnType.isAnnotationPresent(ResultEntity.class)) {
                ResultInfo resultInfo = ResultInfos.get(returnType);
                this.fetchInfosMap = resultInfo.getFetchInfoMap();
                if (Objects.nonNull(this.fetchInfosMap) && !this.fetchInfosMap.isEmpty()) {
                    this.needFetchValuesMap = new HashMap<FetchInfo, List<FetchObject>>();
                    this.basicMapper = BasicMapperThreadLocalUtil.get();
                }
                if (boundSql.getParameterObject() instanceof SQLCmdQueryContext) {
                    BaseQuery baseQuery = (BaseQuery)((SQLCmdQueryContext)boundSql.getParameterObject()).getExecution();
                    this.fetchFilters = baseQuery.getFetchFilters();
                    this.fetchEnables = baseQuery.getFetchEnables();
                    this.putEnumValueInfoMap = resultInfo.getPutEnumValueInfoMap();
                    this.putValueInfoMap = resultInfo.getPutValueInfoMap();
                    this.createdEventInfos = resultInfo.getCreatedEventInfos();
                }
            }
            if (boundSql.getParameterObject() instanceof SQLCmdQueryContext) {
                BaseQuery baseQuery = (BaseQuery)((SQLCmdQueryContext)boundSql.getParameterObject()).getExecution();
                this.onRowEvent = baseQuery.getOnRowEvent();
                this.returnType = baseQuery.getReturnType();
            }
        }
    }

    private void onRowEvent(Object rowValue) {
        if (Objects.isNull(this.onRowEvent)) {
            return;
        }
        if (Objects.isNull(rowValue)) {
            return;
        }
        if (!rowValue.getClass().isAssignableFrom(this.returnType)) {
            return;
        }
        this.onRowEvent.accept(rowValue);
    }

    private void putEnumValue(Object rowValue, ResultSet resultSet) {
        if (Objects.isNull(this.putEnumValueInfoMap)) {
            return;
        }
        if (Objects.isNull(rowValue)) {
            return;
        }
        List<PutEnumValueInfo> putEnumValueInfos = this.putEnumValueInfoMap.get(rowValue.getClass());
        if (Objects.isNull(putEnumValueInfos) || putEnumValueInfos.isEmpty()) {
            return;
        }
        putEnumValueInfos.forEach(item -> {
            Object codeValue;
            try {
                TypeHandler typeHandler = item.getValueTypeHandler();
                if (Objects.isNull(typeHandler)) {
                    typeHandler = this.mappedStatement.getConfiguration().getTypeHandlerRegistry().getTypeHandler(item.getValueType());
                }
                codeValue = Objects.nonNull(typeHandler) ? typeHandler.getResult(resultSet, item.getValueColumn()) : resultSet.getObject(item.getValueColumn());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            Object targetValue = PutEnumValueUtil.getEnumValue(codeValue, item);
            if (Objects.isNull(targetValue)) {
                return;
            }
            try {
                item.getWriteFieldInvoker().invoke(rowValue, new Object[]{targetValue});
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Map<String, Object> getPutValueSessionCache() {
        if (this.putValueSessionCache == null) {
            this.putValueSessionCache = new HashMap<String, Object>();
        }
        return this.putValueSessionCache;
    }

    private void putValue(Object rowValue, ResultSet resultSet) {
        if (Objects.isNull(this.putValueInfoMap)) {
            return;
        }
        if (Objects.isNull(rowValue)) {
            return;
        }
        List<PutValueInfo> putValueInfos = this.putValueInfoMap.get(rowValue.getClass());
        if (Objects.isNull(putValueInfos) || putValueInfos.isEmpty()) {
            return;
        }
        putValueInfos.forEach(item -> {
            Object[] values = new Object[item.getValuesColumn().length];
            for (int i = 0; i < item.getValuesColumn().length; ++i) {
                try {
                    TypeHandler typeHandler = item.getValuesTypeHandler()[i];
                    if (Objects.isNull(typeHandler)) {
                        typeHandler = this.mappedStatement.getConfiguration().getTypeHandlerRegistry().getTypeHandler(item.getValueTypes()[i]);
                    }
                    if (Objects.nonNull(typeHandler)) {
                        values[i] = typeHandler.getResult(resultSet, item.getValuesColumn()[i]);
                        continue;
                    }
                    values[i] = resultSet.getObject(item.getValuesColumn()[i]);
                    continue;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            Object targetValue = PutValueUtil.getPutValue(values, item, this.getPutValueSessionCache());
            if (Objects.isNull(targetValue)) {
                return;
            }
            try {
                item.getWriteFieldInvoker().invoke(rowValue, new Object[]{targetValue});
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void onCreatedEvent(Object rowValue) {
        if (Objects.isNull(this.createdEventInfos) || this.createdEventInfos.isEmpty()) {
            return;
        }
        if (Objects.isNull(rowValue)) {
            return;
        }
        List<CreatedEventInfo> list = this.createdEventInfos.get(rowValue.getClass());
        if (Objects.isNull(list) || list.isEmpty()) {
            return;
        }
        Map context = null;
        for (CreatedEventInfo item : this.createdEventInfos.get(rowValue.getClass())) {
            context = item.isHasContextParam() && Objects.isNull(context) ? this.createdEventContextMap.computeIfAbsent(item.getMethod(), k -> new HashMap()) : null;
            CreatedEventUtil.onCreated(rowValue, context, item);
        }
    }

    @Override
    protected Object getRowValue(ResultSetWrapper rsw, ResultMap resultMap, String columnPrefix) throws SQLException {
        Object rowValue = super.getRowValue(rsw, resultMap, columnPrefix);
        rowValue = this.loadFetchValue(resultMap.getType(), rowValue, rsw.getResultSet());
        this.putEnumValue(rowValue, rsw.getResultSet());
        this.putValue(rowValue, rsw.getResultSet());
        this.onRowEvent(rowValue);
        this.onCreatedEvent(rowValue);
        return rowValue;
    }

    @Override
    protected Object getRowValue(ResultSetWrapper rsw, ResultMap resultMap, CacheKey combinedKey, String columnPrefix, Object partialObject) throws SQLException {
        Object rowValue = super.getRowValue(rsw, resultMap, combinedKey, columnPrefix, partialObject);
        rowValue = this.loadFetchValue(resultMap.getType(), rowValue, rsw.getResultSet());
        this.putEnumValue(rowValue, rsw.getResultSet());
        this.putValue(rowValue, rsw.getResultSet());
        this.onRowEvent(rowValue);
        this.onCreatedEvent(rowValue);
        return rowValue;
    }

    @Override
    public void handleRowValues(ResultSetWrapper rsw, ResultMap resultMap, ResultHandler<?> resultHandler, RowBounds rowBounds, ResultMapping parentMapping) throws SQLException {
        super.handleRowValues(rsw, resultMap, resultHandler, rowBounds, parentMapping);
        this.handleFetch();
    }

    public Object loadFetchValue(Class<?> resultType, Object rowValue, ResultSet resultSet) {
        if (Objects.isNull(this.fetchInfosMap) || this.fetchInfosMap.isEmpty()) {
            return rowValue;
        }
        List<FetchInfo> fetchInfos = this.fetchInfosMap.get(resultType);
        if (Objects.isNull(fetchInfos) || fetchInfos.isEmpty()) {
            return rowValue;
        }
        for (FetchInfo fetchInfo : fetchInfos) {
            Object onValue;
            String fetchKey = fetchInfo.getFieldInfo().getClazz().getName() + "." + fetchInfo.getField().getName();
            Boolean fetchEnable = Objects.isNull(this.fetchEnables) || !this.fetchEnables.containsKey(fetchKey) || this.fetchEnables.get(fetchKey) != false;
            if (!(fetchEnable = Boolean.valueOf(fetchEnable == null || fetchEnable != false)).booleanValue()) {
                if (fetchInfo.getFieldInfo().getTypeClass().isAssignableFrom(Collections.class)) {
                    try {
                        fetchInfo.getWriteFieldInvoker().invoke(rowValue, new Object[]{new ArrayList()});
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                return rowValue;
            }
            try {
                if (Objects.nonNull(fetchInfo.getValueTypeHandler())) {
                    onValue = fetchInfo.getValueTypeHandler().getResult(resultSet, fetchInfo.getValueColumn());
                } else {
                    onValue = resultSet.getObject(fetchInfo.getValueColumn());
                    if (!(onValue instanceof Number)) {
                        onValue = resultSet.getString(fetchInfo.getValueColumn());
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            if (Objects.isNull(onValue)) continue;
            if (Objects.isNull(rowValue)) {
                rowValue = this.configuration.getObjectFactory().create(resultType);
            }
            if (!fetchInfo.getFetch().forceUseIn() && (fetchInfo.getFetch().limit() > 0 || Objects.nonNull(fetchInfo.getTargetSelectColumn()) && fetchInfo.getTargetSelectColumn().contains("("))) {
                this.singleConditionFetch(rowValue, fetchInfo, onValue);
                continue;
            }
            ((List)MapUtil.computeIfAbsent(this.needFetchValuesMap, (Object)fetchInfo, key -> new ArrayList())).add(new FetchObject(onValue, onValue.toString(), rowValue));
        }
        return rowValue;
    }

    public void handleFetch() {
        if (Objects.isNull(this.needFetchValuesMap) || this.needFetchValuesMap.isEmpty()) {
            return;
        }
        for (Map.Entry<FetchInfo, List<FetchObject>> entry : this.needFetchValuesMap.entrySet()) {
            FetchInfo fetchInfo = entry.getKey();
            List<FetchObject> fetchObjects = entry.getValue();
            List<Object> list = this.fetchData(fetchInfo, fetchObjects.stream().map(item -> item.getSourceKey()).distinct().collect(Collectors.toList()), false);
            this.fillFetchData(fetchInfo, fetchObjects, list);
        }
    }

    private List<Object> fetchData(FetchInfo fetchInfo, Query<Object> query, List<Serializable> queryValueList) {
        if (queryValueList.isEmpty()) {
            return Collections.emptyList();
        }
        if (Objects.nonNull(query.$where().getConditionChain())) {
            query.$where().getConditionChain().getConditionBlocks().clear();
        }
        query.from(fetchInfo.getFetch().target(), table -> {
            if (queryValueList.size() == 1) {
                if (fetchInfo.getFetch().limit() > 0) {
                    query.limit(fetchInfo.getFetch().limit());
                }
                query.eq(table.$(fetchInfo.getTargetMatchColumn()), queryValueList.get(0));
            } else {
                query.in(table.$(fetchInfo.getTargetMatchColumn()), queryValueList);
            }
        });
        String fetchKey = fetchInfo.getFieldInfo().getClazz().getName() + "." + fetchInfo.getField().getName();
        boolean hasFetchFilter = !Objects.isNull(this.fetchFilters) && this.fetchFilters.containsKey(fetchKey);
        query.setFetchEnables(this.fetchEnables);
        query.setFetchFilters(this.fetchFilters);
        if (hasFetchFilter) {
            this.fetchFilters.get(fetchKey).accept(query.$where());
        }
        query.optimizeOptions(OptimizeOptions::disableAll);
        if (Objects.nonNull(fetchInfo.getOtherConditions()) && !"".equals(fetchInfo.getOtherConditions())) {
            query.and(q -> Methods.cTpl((String)fetchInfo.getOtherConditions(), (Object[])new Object[0]));
        }
        return this.basicMapper.list(query);
    }

    public void fillFetchData(FetchInfo fetchInfo, List<FetchObject> values, List<Object> fetchData) {
        if (Objects.isNull(fetchData) || fetchData.isEmpty()) {
            values.stream().forEach(i -> this.setValue(i.getValue(), null, fetchInfo));
            return;
        }
        HashMap map = new HashMap();
        fetchData.forEach(item -> {
            List conditionValues;
            Object eqValue;
            try {
                eqValue = Objects.nonNull(fetchInfo.getEqGetFieldInvoker()) ? fetchInfo.getEqGetFieldInvoker().invoke(item, null) : (fetchInfo.isUseResultFetchKeyValue() ? ((FetchKeyValue)item).getKey() : item);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (Objects.nonNull(eqValue) && !(conditionValues = (List)MapUtil.computeIfAbsent((Map)map, (Object)eqValue.toString(), key -> new ArrayList())).contains(item)) {
                conditionValues.add(item);
            }
        });
        values.forEach(item -> {
            List matchValues = (List)map.get(item.getMatchKey());
            this.setValue(item.getValue(), matchValues, fetchInfo);
        });
    }

    protected List<Object> fetchData(FetchInfo fetchInfo, List conditionList, boolean single) {
        if (conditionList.isEmpty()) {
            return Collections.emptyList();
        }
        int batchSize = 100;
        ArrayList<Serializable> queryValueList = new ArrayList<Serializable>(100);
        Query<Object> query = Query.create().returnType(fetchInfo.getReturnType());
        if (Objects.isNull(fetchInfo.getTargetSelectColumn()) || "".equals(fetchInfo.getTargetSelectColumn())) {
            query.select(fetchInfo.getReturnType());
            Select select = query.getSelect();
            HashSet selectColumns = new HashSet();
            if (select != null && select.getSelectField() != null) {
                List selectFields = select.getSelectField();
                selectFields.stream().forEach(item -> {
                    if (item instanceof TableField) {
                        selectColumns.add(((TableField)item).getName());
                    }
                });
            }
            if (!selectColumns.contains(fetchInfo.getTargetMatchColumn())) {
                query.select((Cmd)new Column(fetchInfo.getTargetMatchColumn()));
            }
        } else if (!single && fetchInfo.isUseResultFetchKeyValue()) {
            query.setReturnType(FetchKeyValue.class);
            query.select((Cmd)new Column(fetchInfo.getTargetMatchColumn()).as(FetchKeyValue::getKey));
            query.select((Cmd)new Column(fetchInfo.getTargetSelectColumn()).as(FetchKeyValue::getValue));
        } else if (!fetchInfo.getTargetSelectColumn().contains("(")) {
            query.select((Cmd)new Column(fetchInfo.getTargetSelectColumn()));
            query.select((Cmd)new Column(fetchInfo.getTargetMatchColumn()));
        } else {
            query.select((Cmd)new Column(fetchInfo.getTargetSelectColumn()));
        }
        if (Objects.nonNull(fetchInfo.getOrderBy()) && !"".equals(fetchInfo.getOrderBy())) {
            query.orderBy((IOrderByDirection)OrderByDirection.NONE, fetchInfo.getOrderBy());
        }
        if (Objects.nonNull(fetchInfo.getGroupBy()) && !"".equals(fetchInfo.getGroupBy())) {
            query.groupBy(fetchInfo.getGroupBy());
        }
        ArrayList<Object> resultList = new ArrayList<Object>(conditionList.size());
        int size = conditionList.size();
        for (int i = 0; i < size; ++i) {
            queryValueList.add((Serializable)conditionList.get(i));
            if (i == 0 || i % batchSize != 0) continue;
            resultList.addAll(this.fetchData(fetchInfo, query, queryValueList));
        }
        if (size == 1 || (size - 1) % batchSize != 0) {
            List<Object> list = this.fetchData(fetchInfo, query, queryValueList);
            if (resultList.isEmpty()) {
                return list;
            }
            resultList.addAll(list);
        }
        return resultList;
    }

    public void singleConditionFetch(Object rowValue, FetchInfo fetchInfo, Object onValue) {
        List list = Objects.nonNull(onValue) ? this.singleFetchCache.computeIfAbsent(fetchInfo, key -> new HashMap()).computeIfAbsent(onValue, key2 -> this.fetchData(fetchInfo, Collections.singletonList(onValue), true)) : new ArrayList();
        this.setValue(rowValue, list, fetchInfo);
    }

    protected void setValue(Object rowValue, List<?> matchValues, FetchInfo fetchInfo) {
        if (fetchInfo.isMultiple()) {
            ArrayList arrayList = matchValues = Objects.isNull(matchValues) ? new ArrayList() : matchValues;
            if (matchValues.isEmpty()) {
                fetchInfo.setValue(rowValue, matchValues);
                return;
            }
            if (fetchInfo.isUseResultFetchKeyValue() && matchValues.get(0) instanceof FetchKeyValue) {
                matchValues = matchValues.stream().map(m -> TypeConvertUtil.convert(m.getValue(), fetchInfo.getFieldInfo().getFinalClass())).collect(Collectors.toList());
            }
            fetchInfo.setValue(rowValue, matchValues);
        } else {
            if (Objects.isNull(matchValues) || matchValues.isEmpty()) {
                fetchInfo.setValue(rowValue, null);
                return;
            }
            if (matchValues.size() > 1 && !fetchInfo.getFetch().multiValueErrorIgnore()) {
                throw new TooManyResultsException("fetch action found more than 1 record");
            }
            Object value = fetchInfo.isUseResultFetchKeyValue() && matchValues.get(0) instanceof FetchKeyValue ? matchValues.stream().map(m -> TypeConvertUtil.convert(m.getValue(), fetchInfo.getFieldInfo().getFinalClass())).findFirst().get() : matchValues.get(0);
            fetchInfo.setValue(rowValue, value);
        }
    }
}

