/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.configuration;

import cn.xbatis.core.XbatisConfig;
import cn.xbatis.core.db.reflect.FieldInfo;
import cn.xbatis.core.exception.NotTableClassException;
import cn.xbatis.core.mybatis.configuration.BasicMapperProxyFactory;
import cn.xbatis.core.mybatis.configuration.MybatisLanguageDriver;
import cn.xbatis.core.mybatis.configuration.MybatisMapperProxyFactory;
import cn.xbatis.core.mybatis.executor.DynamicsMappedStatement;
import cn.xbatis.core.mybatis.executor.MappedStatementUtil;
import cn.xbatis.core.mybatis.executor.MybatisExecutor;
import cn.xbatis.core.mybatis.executor.PreparedParameterContext;
import cn.xbatis.core.mybatis.executor.PreparedParameterHandler;
import cn.xbatis.core.mybatis.executor.resultset.MybatisDefaultResultSetHandler;
import cn.xbatis.core.mybatis.executor.statement.MybatisRoutingStatementHandler;
import cn.xbatis.core.mybatis.mapper.BasicMapper;
import cn.xbatis.core.mybatis.mapper.MybatisMapper;
import cn.xbatis.core.mybatis.mapping.ResultMapUtils;
import cn.xbatis.core.mybatis.typeHandler.EnumTypeHandler;
import cn.xbatis.core.mybatis.typeHandler.MybatisTypeHandlerUtil;
import cn.xbatis.core.util.GenericUtil;
import cn.xbatis.db.annotations.Table;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.executor.BatchExecutor;
import org.apache.ibatis.executor.CachingExecutor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ReuseExecutor;
import org.apache.ibatis.executor.SimpleExecutor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class MybatisConfiguration
extends Configuration {
    public MybatisConfiguration() {
        this.init();
    }

    public MybatisConfiguration(Environment environment) {
        super(environment);
        this.init();
    }

    private void init() {
        this.setDefaultScriptingLanguage(MybatisLanguageDriver.class);
        this.setDefaultEnumTypeHandler(EnumTypeHandler.class);
    }

    public void printBanner() {
        try (BufferedReader reader = new BufferedReader(Resources.getResourceAsReader((String)"xbatis.banner"));){
            String line;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StatementHandler newStatementHandler(Executor executor, MappedStatement mappedStatement, Object parameterObject, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        mappedStatement = DynamicsMappedStatement.wrapMappedStatement(mappedStatement, parameterObject);
        MybatisRoutingStatementHandler statementHandler = new MybatisRoutingStatementHandler(executor, mappedStatement, parameterObject, rowBounds, resultHandler, boundSql);
        return (StatementHandler)this.interceptorChain.pluginAll((Object)statementHandler);
    }

    public ParameterHandler newParameterHandler(MappedStatement ms, Object parameterObject, BoundSql boundSql) {
        if (parameterObject instanceof PreparedParameterContext && !ms.getId().endsWith("!selectKey")) {
            return (ParameterHandler)this.interceptorChain.pluginAll((Object)new PreparedParameterHandler(this, (PreparedParameterContext)parameterObject));
        }
        return super.newParameterHandler(ms, parameterObject, boundSql);
    }

    public ResultSetHandler newResultSetHandler(Executor executor, MappedStatement mappedStatement, RowBounds rowBounds, ParameterHandler parameterHandler, ResultHandler resultHandler, BoundSql boundSql) {
        MybatisDefaultResultSetHandler resultSetHandler = new MybatisDefaultResultSetHandler(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds);
        return (ResultSetHandler)this.interceptorChain.pluginAll((Object)resultSetHandler);
    }

    public void addMappedStatement(MappedStatement ms) {
        super.addMappedStatement(MappedStatementUtil.wrap(ms));
    }

    private <T> void addBasicMapper(Class<T> type) {
        super.addMapper(type);
        if (this.mapperRegistry.hasMapper(type)) {
            MetaObject msMetaObject = this.newMetaObject(this.mapperRegistry);
            Map knownMappers = (Map)msMetaObject.getValue("knownMappers");
            knownMappers.put(type, new BasicMapperProxyFactory<T>(type));
        }
    }

    private void clearResultMap() {
        String removeIdPrefix3;
        boolean checkPrefix3;
        Iterator it = this.resultMaps.entrySet().iterator();
        String removeIdPrefix1 = "$";
        String removeIdPrefix2 = BasicMapper.class.getName() + ".$";
        boolean bl = checkPrefix3 = !removeIdPrefix2.equals(removeIdPrefix3 = XbatisConfig.getSingleMapperClass().getName() + ".$");
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ResultMap resultMap = (ResultMap)entry.getValue();
            if (resultMap.getType() != Object.class && resultMap.getType() != Integer.class && resultMap.getType() != Map.class) continue;
            if (resultMap.getId().startsWith(removeIdPrefix1) || resultMap.getId().startsWith(removeIdPrefix2)) {
                it.remove();
                continue;
            }
            if (!checkPrefix3 || !resultMap.getId().startsWith(removeIdPrefix3)) continue;
            it.remove();
        }
    }

    public <T> void addMapper(Class<T> type) {
        if (XbatisConfig.getSingleMapperClass() == BasicMapper.class && !this.hasMapper(BasicMapper.class)) {
            this.addBasicMapper(BasicMapper.class);
            this.clearResultMap();
            if (type == BasicMapper.class) {
                return;
            }
        }
        if (BasicMapper.class.isAssignableFrom(type) && type != BasicMapper.class) {
            this.addBasicMapper(type);
            this.clearResultMap();
            return;
        }
        if (MybatisMapper.class.isAssignableFrom(type)) {
            List<Class<?>> list = GenericUtil.getGenericInterfaceClass(type);
            Optional<Class> entityOptional = list.stream().filter(item -> item.isAnnotationPresent(Table.class)).findFirst();
            if (!entityOptional.isPresent()) {
                if (list.size() != 1) {
                    throw new RuntimeException(type + " did not add a generic");
                }
                throw new NotTableClassException(list.get(0));
            }
            ResultMapUtils.getResultMap(this, entityOptional.get());
        }
        super.addMapper(type);
        if (MybatisMapper.class.isAssignableFrom(type) && this.mapperRegistry.hasMapper(type)) {
            MetaObject msMetaObject = this.newMetaObject(this.mapperRegistry);
            Map knownMappers = (Map)msMetaObject.getValue("knownMappers");
            knownMappers.put(type, new MybatisMapperProxyFactory<T>(type));
        }
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        return (T)super.getMapper(type, sqlSession);
    }

    public ResultMapping buildResultMapping(boolean id, FieldInfo fieldInfo, String columnName, JdbcType jdbcType, Class<? extends TypeHandler<?>> typeHandlerClass) {
        ResultMapping.Builder resultMappingBuilder = new ResultMapping.Builder((Configuration)this, fieldInfo.getField().getName()).column(columnName).javaType(fieldInfo.getTypeClass()).jdbcType(jdbcType).typeHandler(MybatisTypeHandlerUtil.getTypeHandler(this, fieldInfo, typeHandlerClass, jdbcType));
        if (id) {
            resultMappingBuilder.flags(Collections.singletonList(ResultFlag.ID));
        }
        return resultMappingBuilder.build();
    }

    public Executor newExecutor(Transaction transaction, ExecutorType executorType) {
        ExecutorType executorType2 = executorType = executorType == null ? this.defaultExecutorType : executorType;
        Object executor = ExecutorType.BATCH == executorType ? new BatchExecutor((Configuration)this, transaction) : (ExecutorType.REUSE == executorType ? new ReuseExecutor((Configuration)this, transaction) : new SimpleExecutor((Configuration)this, transaction));
        executor = new MybatisExecutor((Executor)executor);
        if (this.cacheEnabled) {
            executor = new CachingExecutor((Executor)executor);
        }
        return (Executor)this.interceptorChain.pluginAll(executor);
    }
}

