/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.configuration;

import cn.xbatis.core.XbatisConfig;
import cn.xbatis.core.function.ThreeFunction;
import cn.xbatis.core.mybatis.executor.BasicMapperThreadLocalUtil;
import cn.xbatis.core.mybatis.mapper.BasicMapper;
import cn.xbatis.core.mybatis.mapper.MybatisMapper;
import cn.xbatis.core.mybatis.mapper.context.MapKeySQLCmdQueryContext;
import cn.xbatis.core.sql.executor.Query;
import cn.xbatis.core.sql.executor.Where;
import cn.xbatis.core.util.DbTypeUtil;
import cn.xbatis.db.annotations.Paging;
import cn.xbatis.page.IPager;
import cn.xbatis.page.PagerField;
import db.sql.api.DbType;
import db.sql.api.impl.cmd.executor.DbSelectorCall;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.binding.MapperProxy;
import org.apache.ibatis.reflection.ParamNameResolver;
import org.apache.ibatis.session.SqlSession;

public class BaseMapperProxy<T>
extends MapperProxy<T> {
    public static final String MAP_WITH_KEY_METHOD_NAME = "$mapWithKey";
    public static final String DB_ADAPT_METHOD_NAME = "dbAdapt";
    public static final String CURRENT_DB_TYPE_METHOD_NAME = "getCurrentDbType";
    public static final String WITH_SQL_SESSION_METHOD_NAME = "withSqlSession";
    protected final SqlSession sqlSession;
    protected final Class<T> mapperInterface;
    private volatile DbType dbType;

    public BaseMapperProxy(SqlSession sqlSession, Class<T> mapperInterface, Map methodCache) {
        super(sqlSession, mapperInterface, methodCache);
        this.sqlSession = sqlSession;
        this.mapperInterface = mapperInterface;
    }

    private DbType getDbType() {
        if (Objects.isNull(this.dbType)) {
            this.dbType = DbTypeUtil.getDbType(this.sqlSession.getConfiguration());
        }
        return this.dbType;
    }

    protected boolean setBasicMapperToThreadLocal(Object proxy) {
        if (proxy instanceof BasicMapper) {
            BasicMapperThreadLocalUtil.set(proxy);
            return true;
        }
        if (proxy instanceof MybatisMapper) {
            BasicMapperThreadLocalUtil.set(() -> ((MybatisMapper)proxy).getBasicMapper());
            return true;
        }
        return false;
    }

    private void wrapperParams(Method method, Object[] args) {
        if (Objects.isNull(args) || args.length == 0) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            Param param;
            Parameter[] parameters;
            Object arg = args[i];
            if (arg != null && arg instanceof Where) {
                parameters = method.getParameters();
                param = parameters[i].getAnnotation(Param.class);
                Where where = (Where)((Object)arg);
                if (param != null) {
                    where.setMybatisParamName(param.value());
                } else if (args.length > 1) {
                    where.setMybatisParamName("param" + (i + 1));
                }
                where.setDbType(this.getDbType());
                continue;
            }
            if (arg == null || !(arg instanceof Query)) continue;
            parameters = method.getParameters();
            param = parameters[i].getAnnotation(Param.class);
            Query query = (Query)arg;
            if (param != null) {
                query.setMybatisParamName(param.value());
            } else if (args.length > 1) {
                query.setMybatisParamName("param" + (i + 1));
            }
            query.setDbType(this.getDbType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.isDefault()) {
            return super.invoke(proxy, method, args);
        }
        boolean isSetBasicMapperToThreadLocal = false;
        try {
            isSetBasicMapperToThreadLocal = this.setBasicMapperToThreadLocal(proxy);
            if (method.getName().equals(DB_ADAPT_METHOD_NAME)) {
                Consumer consumer = (Consumer)args[0];
                DbSelectorCall dbSelector = new DbSelectorCall();
                consumer.accept(dbSelector);
                Object object = dbSelector.dbExecute(this.getDbType());
                return object;
            }
            if (method.getName().equals(MAP_WITH_KEY_METHOD_NAME)) {
                this.wrapperParams(method, args);
                Map consumer = this.mapWithKey(method, args);
                return consumer;
            }
            if (method.isAnnotationPresent(Paging.class)) {
                this.wrapperParams(method, args);
                IPager<?> consumer = this.paging(method, args);
                return consumer;
            }
            if (method.getName().equals(CURRENT_DB_TYPE_METHOD_NAME)) {
                DbType consumer = this.getDbType();
                return consumer;
            }
            if (method.getName().equals(WITH_SQL_SESSION_METHOD_NAME)) {
                String statement;
                this.wrapperParams(method, args);
                if (args.length == 1) {
                    Function function = (Function)args[0];
                    Object dbSelector = function.apply(this.sqlSession);
                    return dbSelector;
                }
                if (args.length == 4) {
                    statement = XbatisConfig.getSingleMapperClass().getName() + "." + ((Class)args[0]).getSimpleName() + ":" + args[1];
                } else if (args[0] instanceof String) {
                    statement = (String)args[0];
                    if (statement.startsWith(".")) {
                        statement = XbatisConfig.getSingleMapperClass().getName() + statement;
                    }
                } else {
                    statement = XbatisConfig.getSingleMapperClass().getName() + "." + ((Class)args[0]).getSimpleName() + ":" + args[1];
                }
                if (args.length == 2) {
                    BiFunction function = (BiFunction)args[1];
                    Object r = function.apply(statement, this.sqlSession);
                    return r;
                }
                if (args.length == 3) {
                    if (args[0] instanceof String) {
                        ThreeFunction function = (ThreeFunction)args[2];
                        Object r = function.apply(statement, args[1], this.sqlSession);
                        return r;
                    }
                    BiFunction function = (BiFunction)args[2];
                    Object r = function.apply(statement, this.sqlSession);
                    return r;
                }
                if (args.length == 4) {
                    ThreeFunction function = (ThreeFunction)args[3];
                    Object r = function.apply(statement, args[2], this.sqlSession);
                    return r;
                }
                throw new RuntimeException("NOT SUPPORTED");
            }
            this.wrapperParams(method, args);
            Object object = super.invoke(proxy, method, args);
            return object;
        }
        finally {
            if (isSetBasicMapperToThreadLocal) {
                BasicMapperThreadLocalUtil.clear();
            }
        }
    }

    private <K, V> Map<K, V> mapWithKey(Method method, Object[] args) {
        MapKeySQLCmdQueryContext queryContext = (MapKeySQLCmdQueryContext)args[0];
        String statementId = this.mapperInterface.getName() + "." + method.getName();
        return this.sqlSession.selectMap(statementId, (Object)queryContext, queryContext.getKey());
    }

    private IPager<?> paging(Method method, Object[] args) {
        ParamNameResolver paramNameResolver = new ParamNameResolver(this.sqlSession.getConfiguration(), method);
        Object params = paramNameResolver.getNamedParams(args);
        String statementId = this.mapperInterface.getName() + "." + method.getName();
        IPager pager = (IPager)args[0];
        Boolean executeCount = (Boolean)pager.get(PagerField.IS_EXECUTE_COUNT);
        Integer size = (Integer)pager.get(PagerField.SIZE);
        Integer count = null;
        List list = executeCount.booleanValue() && size > -1 ? ((count = Integer.valueOf(Objects.isNull(count = (Integer)this.sqlSession.selectOne(statementId + "&count", params)) ? 0 : count)) == 0 ? new ArrayList() : this.sqlSession.selectList(statementId + "&list", params)) : this.sqlSession.selectList(statementId + "&list", params);
        if (executeCount.booleanValue() && size < 0) {
            count = list.size();
        }
        pager.set(PagerField.RESULTS, (Object)list);
        pager.set(PagerField.TOTAL, (Object)count);
        return pager;
    }
}

