/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.db.reflect;

import cn.xbatis.core.XbatisConfig;
import cn.xbatis.core.db.reflect.ForeignInfo;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.logicDelete.LogicDeleteUtil;
import cn.xbatis.core.util.FieldUtil;
import cn.xbatis.core.util.TableInfoUtil;
import cn.xbatis.db.annotations.ForeignKey;
import cn.xbatis.db.annotations.LogicDelete;
import cn.xbatis.db.annotations.SplitTable;
import cn.xbatis.db.annotations.Table;
import cn.xbatis.db.annotations.TableSplitter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class TableInfo {
    private final Class<?> type;
    private final String schema;
    private final String tableName;
    private final String schemaAndTableName;
    private final List<TableFieldInfo> tableFieldInfos;
    private final int fieldSize;
    private final List<TableFieldInfo> idFieldInfos;
    private final String[] idColumnNames;
    private final boolean hasMultiId;
    private final TableFieldInfo idFieldInfo;
    private final boolean isSplitTable;
    private final TableSplitter tableSplitter;
    private final TableFieldInfo versionFieldInfo;
    private final TableFieldInfo tenantIdFieldInfo;
    private final TableFieldInfo logicDeleteFieldInfo;
    private final Map<Class<?>, ForeignInfo> foreignInfoMap;
    private final Map<String, TableFieldInfo> tableFieldInfoMap;
    private final boolean hasIgnoreField;

    public TableInfo(Class<?> entity) {
        String deleteTimeFieldName;
        this.type = entity;
        Table table = entity.getAnnotation(Table.class);
        this.schema = table.schema();
        SplitTable splitTable = entity.getAnnotation(SplitTable.class);
        boolean bl = this.isSplitTable = splitTable != null;
        if (this.isSplitTable) {
            try {
                this.tableSplitter = (TableSplitter)splitTable.value().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.tableSplitter = null;
        }
        this.tableName = TableInfoUtil.getTableName(entity);
        this.schemaAndTableName = this.schema == null || "".equals(this.schema) ? this.tableName : this.schema + "." + this.tableName;
        TableFieldInfo idFieldInfo = null;
        TableFieldInfo versionFieldInfo = null;
        TableFieldInfo tenantIdFieldInfo = null;
        TableFieldInfo logicDeleteFieldInfo = null;
        ArrayList<TableFieldInfo> tableFieldInfos = new ArrayList<TableFieldInfo>();
        HashMap<String, TableFieldInfo> tableFieldInfoMap = new HashMap<String, TableFieldInfo>();
        HashMap<Class, ForeignInfo> foreignInfoMap = new HashMap<Class, ForeignInfo>();
        boolean hasMutilId = false;
        ArrayList<TableFieldInfo> idFieldInfos = new ArrayList<TableFieldInfo>(6);
        List<Field> fieldList = FieldUtil.getFields(entity);
        for (Field field : fieldList) {
            TableFieldInfo tableFieldInfo = new TableFieldInfo(entity, table, field);
            tableFieldInfos.add(tableFieldInfo);
            tableFieldInfoMap.put(field.getName(), tableFieldInfo);
            if (field.isAnnotationPresent(ForeignKey.class)) {
                ForeignKey foreignKey = field.getAnnotation(ForeignKey.class);
                foreignInfoMap.put(foreignKey.value(), new ForeignInfo(foreignKey.value(), tableFieldInfo));
            }
            if (tableFieldInfo.isTableId()) {
                idFieldInfos.add(tableFieldInfo);
                if (Objects.isNull(idFieldInfo)) {
                    idFieldInfo = tableFieldInfo;
                } else {
                    idFieldInfo = null;
                    hasMutilId = true;
                }
            }
            if (tableFieldInfo.isVersion()) {
                if (versionFieldInfo != null) {
                    throw new RuntimeException("Entity " + entity.getName() + " has multi @Version");
                }
                versionFieldInfo = tableFieldInfo;
            }
            if (tableFieldInfo.isTenantId()) {
                if (tenantIdFieldInfo != null) {
                    throw new RuntimeException("Entity " + entity.getName() + " has multi @TenantId");
                }
                tenantIdFieldInfo = tableFieldInfo;
            }
            if (!tableFieldInfo.isLogicDelete()) continue;
            if (logicDeleteFieldInfo != null) {
                throw new RuntimeException("Entity " + entity.getName() + " has multi @LogicDelete");
            }
            logicDeleteFieldInfo = tableFieldInfo;
            LogicDelete logicDeleteAnnotation = field.getAnnotation(LogicDelete.class);
            if (!XbatisConfig.isDynamicValueKeyFormat(logicDeleteAnnotation.beforeValue())) continue;
            throw new RuntimeException("the @LogicDelete of Entity " + entity.getName() + " has config error,the beforeValue can't be dynamic key");
        }
        this.tableFieldInfos = Collections.unmodifiableList(tableFieldInfos);
        this.fieldSize = this.tableFieldInfos.size();
        this.hasMultiId = hasMutilId;
        this.idFieldInfos = Collections.unmodifiableList(idFieldInfos);
        this.idColumnNames = idFieldInfos.stream().filter(item -> item.isTableId()).map(item -> item.getColumnName()).collect(Collectors.toList()).toArray(new String[0]);
        this.idFieldInfo = idFieldInfo;
        this.versionFieldInfo = versionFieldInfo;
        this.tenantIdFieldInfo = tenantIdFieldInfo;
        this.logicDeleteFieldInfo = logicDeleteFieldInfo;
        this.tableFieldInfoMap = Collections.unmodifiableMap(tableFieldInfoMap);
        this.foreignInfoMap = Collections.unmodifiableMap(foreignInfoMap);
        if (Objects.nonNull(this.logicDeleteFieldInfo) && !"".equals(deleteTimeFieldName = this.logicDeleteFieldInfo.getLogicDeleteAnnotation().deleteTimeField())) {
            LogicDeleteUtil.getLogicDeleteTimeValue(this);
        }
        this.hasIgnoreField = tableFieldInfos.stream().anyMatch(item -> !item.getTableFieldAnnotation().select());
        if (this.isSplitTable) {
            long splitTableSize = tableFieldInfos.stream().filter(i -> i.isTableSplitKey()).count();
            if (splitTableSize == 0L) {
                throw new RuntimeException("Entity " + entity.getName() + " has no @TableSplitKey");
            }
            if (splitTableSize != 1L) {
                throw new RuntimeException("Entity " + entity.getName() + " has multi @TableSplitKey");
            }
        }
    }

    public final TableFieldInfo getFieldInfo(String property) {
        return this.tableFieldInfoMap.get(property);
    }

    public final TableFieldInfo getFieldInfoByColumnName(String columnName) {
        return this.tableFieldInfos.stream().filter(item -> item.getColumnName().equals(columnName)).findFirst().orElse(null);
    }

    public final ForeignInfo getForeignInfo(Class<?> entityClass) {
        return this.foreignInfoMap.get(entityClass);
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaAndTableName() {
        return this.schemaAndTableName;
    }

    public Map<Class<?>, ForeignInfo> getForeignInfoMap() {
        return this.foreignInfoMap;
    }

    public Map<String, TableFieldInfo> getTableFieldInfoMap() {
        return this.tableFieldInfoMap;
    }

    public List<TableFieldInfo> getTableFieldInfos() {
        return this.tableFieldInfos;
    }

    public int getFieldSize() {
        return this.fieldSize;
    }

    public TableFieldInfo getVersionFieldInfo() {
        return this.versionFieldInfo;
    }

    public TableFieldInfo getTenantIdFieldInfo() {
        return this.tenantIdFieldInfo;
    }

    public TableFieldInfo getLogicDeleteFieldInfo() {
        return this.logicDeleteFieldInfo;
    }

    public boolean isHasIgnoreField() {
        return this.hasIgnoreField;
    }

    public boolean isHasMultiId() {
        return this.hasMultiId;
    }

    public List<TableFieldInfo> getIdFieldInfos() {
        return this.idFieldInfos;
    }

    public TableFieldInfo getSingleIdFieldInfo(boolean throwException) {
        if (throwException && Objects.isNull(this.idFieldInfo)) {
            throw new RuntimeException("Entity:" + this.type + " has multi ID or non-single ID.");
        }
        return this.idFieldInfo;
    }

    public TableFieldInfo getIdFieldInfo() {
        return this.idFieldInfo;
    }

    public String[] getIdColumnNames() {
        return this.idColumnNames;
    }

    public boolean isSplitTable() {
        return this.isSplitTable;
    }

    public TableSplitter getTableSplitter() {
        return this.tableSplitter;
    }
}

