/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.db.reflect;

import cn.xbatis.core.db.reflect.ModelFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.core.exception.NotTableClassException;
import cn.xbatis.core.util.FieldUtil;
import cn.xbatis.core.util.GenericUtil;
import cn.xbatis.db.annotations.Table;
import db.sql.api.impl.tookit.Objects;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModelInfo {
    private final Class<?> type;
    private final Class<?> entityType;
    private final TableInfo tableInfo;
    private final List<ModelFieldInfo> modelFieldInfos;
    private final Map<String, ModelFieldInfo> modelFieldInfoMap;
    private final int fieldSize;
    private final List<ModelFieldInfo> idFieldInfos;
    private final ModelFieldInfo versionFieldInfo;
    private final ModelFieldInfo logicDeleteFieldInfo;
    private final ModelFieldInfo tenantIdFieldInfo;
    private final ModelFieldInfo idFieldInfo;

    public ModelInfo(Class<?> model) {
        Class entity;
        this.type = model;
        this.entityType = entity = GenericUtil.getGenericInterfaceClass(model).stream().filter(item -> item.isAnnotationPresent(Table.class)).findFirst().orElseThrow(() -> new RuntimeException(MessageFormat.format("class {0} have no generic type", model.getName())));
        try {
            this.tableInfo = Tables.get(entity);
        }
        catch (NotTableClassException e) {
            throw new RuntimeException(MessageFormat.format("unable match model class {0} , the generic class {1} is not a entity", model.getName(), entity.getName()));
        }
        List modelFieldInfos = FieldUtil.getFields(model).stream().map(field -> new ModelFieldInfo(entity, model, (Field)field)).collect(Collectors.toList());
        this.modelFieldInfoMap = modelFieldInfos.stream().collect(Collectors.toMap(item -> item.getField().getName(), account -> account));
        this.idFieldInfos = modelFieldInfos.stream().filter(item -> item.getTableFieldInfo().isTableId()).collect(Collectors.toList());
        this.idFieldInfo = this.idFieldInfos.size() == 1 ? this.idFieldInfos.get(0) : null;
        this.versionFieldInfo = modelFieldInfos.stream().filter(item -> item.getTableFieldInfo().isVersion()).findFirst().orElse(null);
        this.tenantIdFieldInfo = modelFieldInfos.stream().filter(item -> item.getTableFieldInfo().isTenantId()).findFirst().orElse(null);
        this.logicDeleteFieldInfo = modelFieldInfos.stream().filter(item -> item.getTableFieldInfo().isLogicDelete()).findFirst().orElse(null);
        this.modelFieldInfos = Collections.unmodifiableList(modelFieldInfos);
        this.fieldSize = this.modelFieldInfos.size();
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public ModelFieldInfo getVersionFieldInfo() {
        return this.versionFieldInfo;
    }

    public ModelFieldInfo getLogicDeleteFieldInfo() {
        return this.logicDeleteFieldInfo;
    }

    public ModelFieldInfo getTenantIdFieldInfo() {
        return this.tenantIdFieldInfo;
    }

    public List<ModelFieldInfo> getModelFieldInfos() {
        return this.modelFieldInfos;
    }

    public List<ModelFieldInfo> getIdFieldInfos() {
        return this.idFieldInfos;
    }

    public final ModelFieldInfo getFieldInfo(String property) {
        return this.modelFieldInfoMap.get(property);
    }

    public int getFieldSize() {
        return this.fieldSize;
    }

    public ModelFieldInfo getSingleIdFieldInfo(boolean throwException) {
        if (throwException && Objects.isNull((Object)this.idFieldInfo)) {
            throw new RuntimeException("Model:" + this.type + " has multi ID or non-single ID.");
        }
        return this.idFieldInfo;
    }

    public ModelFieldInfo getIdFieldInfo() {
        return this.idFieldInfo;
    }
}

