/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.db.reflect;

import cn.xbatis.core.XbatisConfig;
import cn.xbatis.core.db.reflect.FieldInfo;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.annotations.Condition;
import db.sql.api.Cmd;
import db.sql.api.cmd.LikeMode;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.struct.ConditionChain;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import lombok.Generated;

public class ConditionItem {
    private final Field field;
    private final TableFieldInfo tableFieldInfo;
    private final Condition.Type type;
    private final int storey;
    private final LikeMode likeMode;
    private final Condition annotation;
    private final Object defaultValue;

    public ConditionItem(Field field, TableFieldInfo tableFieldInfo, Condition annotation) {
        field.setAccessible(true);
        this.field = field;
        this.tableFieldInfo = tableFieldInfo;
        this.annotation = annotation;
        if (annotation == null) {
            this.type = Condition.Type.EQ;
            this.storey = 1;
            this.likeMode = null;
        } else {
            this.type = annotation.value();
            this.storey = annotation.storey();
            this.likeMode = LikeMode.valueOf((String)annotation.likeMode().name());
        }
        this.defaultValue = annotation != null ? (annotation.defaultValue().isEmpty() ? null : (!annotation.defaultValue().contains("{") ? TypeConvertUtil.convert(annotation.defaultValue(), field.getType()) : null)) : null;
    }

    private Date toEndDayTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    private Object toEndDayTime(Object param) {
        String p;
        if (param == null) {
            return null;
        }
        if (param instanceof LocalDate) {
            return ((LocalDate)param).atStartOfDay().plusDays(1L).minusNanos(1L);
        }
        if (param instanceof Date) {
            return this.toEndDayTime((Date)param);
        }
        if (param instanceof Long) {
            return this.toEndDayTime(new Date((Long)param));
        }
        if (param instanceof LocalDateTime) {
            return ((LocalDateTime)param).toLocalDate().atStartOfDay().plusDays(1L).minusNanos(1L);
        }
        if (param instanceof String && (p = (String)param).length() == 10) {
            return p + " 23:59:59";
        }
        return param;
    }

    private Object getDefaultValue(Object target) {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        if (this.annotation != null && this.annotation.defaultValue().contains("{")) {
            return XbatisConfig.getDefaultValue(target.getClass(), this.field.getType(), this.annotation.defaultValue());
        }
        return null;
    }

    public void appendCondition(ConditionChain conditionChain, Object target) {
        Object value;
        try {
            value = this.field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (value == null) {
            value = this.getDefaultValue(target);
        } else if (value instanceof String && ((String)value).isEmpty()) {
            value = this.getDefaultValue(target);
        } else if (value instanceof Collection && ((Collection)value).isEmpty()) {
            value = this.getDefaultValue(target);
        } else if (value instanceof Object[] && ((Object[])value).length < 1) {
            value = this.getDefaultValue(target);
        }
        if (value == null) {
            return;
        }
        CmdFactory cmdFactory = conditionChain.getConditionFactory().getCmdFactory();
        FieldInfo fieldInfo = this.tableFieldInfo.getFieldInfo();
        TableField tableField = cmdFactory.field(fieldInfo.getClazz(), fieldInfo.getField().getName(), this.storey);
        switch (this.type) {
            case EQ: {
                conditionChain.eq((Cmd)tableField, value);
                break;
            }
            case NE: {
                conditionChain.ne((Cmd)tableField, value);
                break;
            }
            case IN: {
                if (value instanceof Collection) {
                    conditionChain.in((Cmd)tableField, (Collection)value);
                    break;
                }
                conditionChain.in((Cmd)tableField, new Serializable[]{(Object[])value});
                break;
            }
            case LT: {
                conditionChain.lt((Cmd)tableField, value);
                break;
            }
            case LTE: {
                conditionChain.lte((Cmd)tableField, this.annotation != null && this.annotation.toEndDayTime() ? this.toEndDayTime(value) : value);
                break;
            }
            case GT: {
                conditionChain.gt((Cmd)tableField, value);
                break;
            }
            case GTE: {
                conditionChain.gte((Cmd)tableField, value);
                break;
            }
            case LIKE: {
                if (!(value instanceof String)) {
                    throw new RuntimeException("Like value must be String");
                }
                conditionChain.like(this.likeMode, (Cmd)tableField, (String)value);
                break;
            }
            case NOT_LIKE: {
                if (!(value instanceof String)) {
                    throw new RuntimeException("Not like value must be String");
                }
                conditionChain.notLike(this.likeMode, (Cmd)tableField, (String)value);
                break;
            }
            case BETWEEN: {
                Object[] array;
                if (value instanceof Object[]) {
                    array = (Object[])value;
                } else if (value instanceof Collection) {
                    Collection list = (Collection)value;
                    array = list.toArray();
                } else {
                    throw new RuntimeException("Not support type : " + value.getClass());
                }
                conditionChain.between((Cmd)tableField, array[0], this.annotation != null && this.annotation.toEndDayTime() ? this.toEndDayTime(array[1]) : array[1]);
                break;
            }
        }
    }

    @Generated
    public Field getField() {
        return this.field;
    }

    @Generated
    public TableFieldInfo getTableFieldInfo() {
        return this.tableFieldInfo;
    }

    @Generated
    public Condition.Type getType() {
        return this.type;
    }

    @Generated
    public int getStorey() {
        return this.storey;
    }

    @Generated
    public LikeMode getLikeMode() {
        return this.likeMode;
    }

    @Generated
    public Condition getAnnotation() {
        return this.annotation;
    }

    @Generated
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionItem)) {
            return false;
        }
        ConditionItem other = (ConditionItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStorey() != other.getStorey()) {
            return false;
        }
        Field this$field = this.getField();
        Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        TableFieldInfo this$tableFieldInfo = this.getTableFieldInfo();
        TableFieldInfo other$tableFieldInfo = other.getTableFieldInfo();
        if (this$tableFieldInfo == null ? other$tableFieldInfo != null : !this$tableFieldInfo.equals(other$tableFieldInfo)) {
            return false;
        }
        Condition.Type this$type = this.getType();
        Condition.Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        LikeMode this$likeMode = this.getLikeMode();
        LikeMode other$likeMode = other.getLikeMode();
        if (this$likeMode == null ? other$likeMode != null : !this$likeMode.equals(other$likeMode)) {
            return false;
        }
        Condition this$annotation = this.getAnnotation();
        Condition other$annotation = other.getAnnotation();
        if (this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConditionItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStorey();
        Field $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        TableFieldInfo $tableFieldInfo = this.getTableFieldInfo();
        result = result * 59 + ($tableFieldInfo == null ? 43 : $tableFieldInfo.hashCode());
        Condition.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        LikeMode $likeMode = this.getLikeMode();
        result = result * 59 + ($likeMode == null ? 43 : $likeMode.hashCode());
        Condition $annotation = this.getAnnotation();
        result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConditionItem(field=" + this.getField() + ", tableFieldInfo=" + this.getTableFieldInfo() + ", type=" + this.getType() + ", storey=" + this.getStorey() + ", likeMode=" + this.getLikeMode() + ", annotation=" + this.getAnnotation() + ", defaultValue=" + this.getDefaultValue() + ")";
    }
}

