/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.db.reflect;

import cn.xbatis.core.db.reflect.ConditionItem;
import cn.xbatis.core.db.reflect.ConditionItemGroup;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.core.sql.ObjectConditionLifeCycle;
import cn.xbatis.core.util.FieldUtil;
import cn.xbatis.db.Logic;
import cn.xbatis.db.annotations.Condition;
import cn.xbatis.db.annotations.ConditionGroup;
import cn.xbatis.db.annotations.ConditionTarget;
import db.sql.api.impl.cmd.struct.ConditionChain;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConditionInfo {
    private final List<ConditionItemGroup> conditionItemGroups;

    /*
     * WARNING - void declaration
     */
    public ConditionInfo(Class<?> clazz) {
        Logic logic;
        Class targetTable;
        List<Field> fieldList = FieldUtil.getFields(clazz);
        ArrayList<ConditionItem> conditions = new ArrayList<ConditionItem>(fieldList.size());
        if (clazz.isAnnotationPresent(ConditionTarget.class)) {
            ConditionTarget conditionTarget = clazz.getAnnotation(ConditionTarget.class);
            targetTable = conditionTarget.value();
            logic = conditionTarget.logic();
        } else {
            targetTable = clazz;
            logic = Logic.AND;
        }
        HashMap<Class, TableInfo> tableInfoMap = new HashMap<Class, TableInfo>();
        for (Field field : fieldList) {
            void var11_11;
            TableFieldInfo tableFieldInfo;
            Condition condition = field.getAnnotation(Condition.class);
            if (condition != null && condition.value() == Condition.Type.IGNORE) continue;
            TableInfo tableInfo = condition == null ? tableInfoMap.computeIfAbsent(targetTable, k -> Tables.get(targetTable)) : (condition.target() == Void.class ? tableInfoMap.computeIfAbsent(targetTable, k -> Tables.get(targetTable)) : tableInfoMap.computeIfAbsent(targetTable, k -> Tables.get(condition.target())));
            String string = field.getName();
            if (condition != null && !condition.property().isEmpty()) {
                String string2 = condition.property();
            }
            if ((tableFieldInfo = tableInfo.getFieldInfo((String)var11_11)) == null) {
                throw new RuntimeException("can not find entity property " + (String)var11_11 + " in entity class " + tableInfo.getType());
            }
            conditions.add(new ConditionItem(field, tableFieldInfo, condition));
        }
        Map<String, ConditionItem> conditionItemMap = conditions.stream().collect(Collectors.toMap(i -> i.getField().getName(), i -> i));
        ConditionGroup[] conditionGroups = (ConditionGroup[])clazz.getAnnotationsByType(ConditionGroup.class);
        HashMap<ConditionGroup, ConditionItemGroup> conditionItemGroupMap = new HashMap<ConditionGroup, ConditionItemGroup>();
        HashSet<String> usedConditionFields = new HashSet<String>();
        for (ConditionGroup key : conditionGroups) {
            ConditionItemGroup group = conditionItemGroupMap.computeIfAbsent(key, i -> new ConditionItemGroup(false, logic, key.logic(), new ArrayList<ConditionItem>()));
            for (String field : key.value()) {
                if (!conditionItemMap.containsKey(field)) {
                    throw new RuntimeException("class " + clazz + " have no field: " + field);
                }
                group.getConditionItems().add(conditionItemMap.get(field));
                usedConditionFields.add(field);
            }
        }
        ArrayList<ConditionItemGroup> arrayList = new ArrayList<ConditionItemGroup>();
        for (ConditionItem i2 : conditions) {
            if (usedConditionFields.contains(i2.getField().getName())) continue;
            arrayList.add(new ConditionItemGroup(true, logic, null, i2));
        }
        conditionItemGroupMap.entrySet().stream().forEach(entry -> itemGroups.add((ConditionItemGroup)entry.getValue()));
        this.conditionItemGroups = arrayList;
    }

    public void appendCondition(ConditionChain conditionChain, Object target) {
        if (target == null) {
            return;
        }
        if (target instanceof ObjectConditionLifeCycle) {
            ObjectConditionLifeCycle objectConditionLifeCycle = (ObjectConditionLifeCycle)target;
            objectConditionLifeCycle.beforeBuildCondition();
        }
        this.conditionItemGroups.stream().forEach(i -> i.appendCondition(conditionChain, target));
    }
}

