/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.util;

import cn.xbatis.core.XbatisConfig;
import cn.xbatis.core.db.reflect.Default;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.core.exception.NotTableClassException;
import cn.xbatis.core.util.NamingUtil;
import cn.xbatis.db.annotations.Table;
import cn.xbatis.db.annotations.TableField;
import cn.xbatis.db.annotations.TableId;
import db.sql.api.DbType;
import db.sql.api.Getter;
import db.sql.api.tookit.LambdaUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Objects;

public final class TableInfoUtil {
    public static void setValue(TableFieldInfo tableFieldInfo, Object target, Object value) {
        try {
            tableFieldInfo.getWriteFieldInvoker().invoke(target, new Object[]{value});
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void checkId(TableInfo tableInfo) {
        tableInfo.getSingleIdFieldInfo(true);
    }

    public static Serializable getEntityIdValue(Object entity) {
        return TableInfoUtil.getEntityIdValue(Tables.get(entity.getClass()), entity, false);
    }

    public static Serializable getEntityIdValue(TableInfo tableInfo, Object entity) {
        return TableInfoUtil.getEntityIdValue(tableInfo, entity, true);
    }

    public static Serializable getEntityIdValue(TableInfo tableInfo, Object entity, boolean check) {
        if (check && entity.getClass() != tableInfo.getType()) {
            throw new RuntimeException("Not Supported");
        }
        TableInfoUtil.checkId(tableInfo);
        return (Serializable)TableInfoUtil.getEntityFieldValue(tableInfo.getSingleIdFieldInfo(true), entity);
    }

    public static Object getEntityFieldValue(TableFieldInfo tableFieldInfo, Object entity) {
        try {
            return tableFieldInfo.getReadFieldInvoker().invoke(entity, null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTableName(Class entity) {
        Table table = entity.getAnnotation(Table.class);
        String tableName = table.value();
        if ("".equals(tableName)) {
            tableName = entity.getSimpleName();
            if (XbatisConfig.isTableUnderline()) {
                tableName = NamingUtil.camelToUnderline(tableName);
            }
        }
        return tableName;
    }

    public static TableId getTableIdAnnotation(Field field, DbType dbType) {
        TableId[] tableIdAnnotations = (TableId[])field.getAnnotationsByType(TableId.class);
        if (tableIdAnnotations.length < 1) {
            return null;
        }
        TableId tableId = null;
        for (TableId item : tableIdAnnotations) {
            if (item.dbType() != dbType) continue;
            tableId = item;
            break;
        }
        if (Objects.isNull(tableId)) {
            tableId = tableIdAnnotations[0];
        }
        return tableId;
    }

    public static TableField getTableFieldAnnotation(Field field) {
        TableField tableFieldAnnotation = field.getAnnotation(TableField.class);
        if (Objects.isNull(tableFieldAnnotation)) {
            tableFieldAnnotation = Default.defaultTableFieldAnnotation();
        }
        return tableFieldAnnotation;
    }

    public static String getFieldColumnName(Table table, Field field) {
        TableField tableFieldAnnotation = TableInfoUtil.getTableFieldAnnotation(field);
        String columnName = tableFieldAnnotation.value();
        if ("".equals(columnName)) {
            columnName = field.getName();
            switch (table.columnNameRule()) {
                case IGNORE: {
                    if (!XbatisConfig.isColumnUnderline()) break;
                    columnName = NamingUtil.camelToUnderline(columnName);
                    break;
                }
                case UNDERLINE: {
                    columnName = NamingUtil.camelToUnderline(columnName);
                    break;
                }
            }
        }
        return columnName;
    }

    public static <E> String getColumnName(Getter<E> column) {
        TableInfo tableInfo;
        LambdaUtil.LambdaFieldInfo fieldInfo = LambdaUtil.getFieldInfo(column);
        Class entity = fieldInfo.getType();
        try {
            tableInfo = Tables.get(entity);
        }
        catch (NotTableClassException e) {
            throw new RuntimeException("class " + entity.getName() + " is not entity");
        }
        String filedName = fieldInfo.getName();
        TableFieldInfo tableFieldInfo = tableInfo.getFieldInfo(filedName);
        if (Objects.isNull(tableFieldInfo)) {
            throw new RuntimeException("property " + filedName + " is not a column");
        }
        return tableFieldInfo.getColumnName();
    }
}

