/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.util;

import cn.xbatis.core.XbatisConfig;
import cn.xbatis.core.db.reflect.ModelFieldInfo;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.util.ModelInfoUtil;
import cn.xbatis.core.util.TableInfoUtil;
import cn.xbatis.db.Model;
import db.sql.api.impl.tookit.Objects;

public class DefaultValueUtil {
    public static Object getAndSetDefaultValue(Object entity, TableFieldInfo tableFieldInfo) {
        Object value = DefaultValueUtil.getDefaultValue(tableFieldInfo, tableFieldInfo.getFieldInfo().getTypeClass());
        if (Objects.nonNull((Object)value)) {
            TableInfoUtil.setValue(tableFieldInfo, entity, value);
        }
        return value;
    }

    public static Object getAndSetUpdateDefaultValue(Object entity, TableFieldInfo tableFieldInfo) {
        Object value = DefaultValueUtil.getUpdateDefaultValue(tableFieldInfo, tableFieldInfo.getFieldInfo().getTypeClass());
        if (Objects.nonNull((Object)value)) {
            TableInfoUtil.setValue(tableFieldInfo, entity, value);
        }
        return value;
    }

    public static <M extends Model<T>, T> Object getAndSetDefaultValue(M model, ModelFieldInfo modelFieldInfo) {
        Object value = DefaultValueUtil.getDefaultValue(modelFieldInfo.getTableFieldInfo(), modelFieldInfo.getFieldInfo().getTypeClass());
        if (Objects.nonNull((Object)value)) {
            ModelInfoUtil.setValue(modelFieldInfo, model, value);
        }
        return value;
    }

    public static <M extends Model<T>, T> Object getAndSetUpdateDefaultValue(M model, ModelFieldInfo modelFieldInfo) {
        Object value = DefaultValueUtil.getUpdateDefaultValue(modelFieldInfo.getTableFieldInfo(), modelFieldInfo.getFieldInfo().getTypeClass());
        if (Objects.nonNull((Object)value)) {
            ModelInfoUtil.setValue(modelFieldInfo, model, value);
        }
        return value;
    }

    private static Object getDefaultValue(TableFieldInfo tableFieldInfo, Class<?> defaultValueType) {
        if ("".equals(tableFieldInfo.getTableFieldAnnotation().defaultValue())) {
            return null;
        }
        return XbatisConfig.getDefaultValue(tableFieldInfo.getFieldInfo().getClazz(), defaultValueType, tableFieldInfo.getTableFieldAnnotation().defaultValue());
    }

    private static Object getUpdateDefaultValue(TableFieldInfo tableFieldInfo, Class<?> defaultValueType) {
        if ("".equals(tableFieldInfo.getTableFieldAnnotation().updateDefaultValue())) {
            return null;
        }
        return XbatisConfig.getDefaultValue(tableFieldInfo.getFieldInfo().getClazz(), defaultValueType, tableFieldInfo.getTableFieldAnnotation().updateDefaultValue());
    }
}

