/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.sql;

import cn.xbatis.core.mybatis.mapper.context.MybatisParameter;
import cn.xbatis.core.sql.executor.MpTable;
import cn.xbatis.db.annotations.TableSplitter;
import db.sql.api.impl.cmd.basic.BasicValue;
import java.util.Collection;
import java.util.function.Supplier;

public class TableSplitUtil {
    private static Object getSplitValue(Object value, TableSplitter splitter) {
        if (value == null) {
            return null;
        }
        if (value instanceof BasicValue) {
            return TableSplitUtil.getSplitValue(((BasicValue)value).getValue(), splitter);
        }
        if (value instanceof MybatisParameter) {
            return TableSplitUtil.getSplitValue(((MybatisParameter)value).getValue(), splitter);
        }
        if (value instanceof Supplier) {
            return TableSplitUtil.getSplitValue(((Supplier)value).get(), splitter);
        }
        Object v = null;
        if (value.getClass().isArray()) {
            Object[] arr;
            for (Object o : arr = (Object[])value) {
                if (o == null || (v = TableSplitUtil.getSplitValue(o, splitter)) == null || !splitter.support(v.getClass())) continue;
                return v;
            }
        } else if (Collection.class.isAssignableFrom(value.getClass())) {
            Collection collection = (Collection)value;
            for (Object item : collection) {
                if (item == null || (v = TableSplitUtil.getSplitValue(item, splitter)) == null || !splitter.support(v.getClass())) continue;
                return v;
            }
        } else if (splitter.support(value.getClass())) {
            return value;
        }
        return v;
    }

    public static void splitHandle(MpTable mpTable, Object value) {
        if (value == null) {
            return;
        }
        TableSplitter splitter = mpTable.getTableInfo().getTableSplitter();
        Object v = TableSplitUtil.getSplitValue(value, splitter);
        if (v == null) {
            return;
        }
        mpTable.setName(splitter.split(mpTable.getName(), v));
    }
}

