/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.typeHandler;

import cn.xbatis.core.db.reflect.FieldInfo;
import cn.xbatis.core.mybatis.typeHandler.GenericTypeHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;

public final class MybatisTypeHandlerUtil {
    private static final Map<Class<? extends TypeHandler<?>>, Map<Type, Map<Class<?>, TypeHandler<?>>>> GENERIC_TYPE_HANDLERS = new ConcurrentHashMap();

    public static TypeHandler<?> createTypeHandler(FieldInfo fieldInfo, Class<? extends TypeHandler<?>> typeHandlerClass) {
        if (typeHandlerClass == UnknownTypeHandler.class) {
            return null;
        }
        try {
            Constructor<TypeHandler<?>> constructor = typeHandlerClass.getConstructor(Class.class, Type.class);
            return constructor.newInstance(fieldInfo.getTypeClass(), fieldInfo.getField().getGenericType());
        }
        catch (ReflectiveOperationException constructor) {
            try {
                Constructor<TypeHandler<?>> constructor2 = typeHandlerClass.getConstructor(Class.class);
                return constructor2.newInstance(fieldInfo.getTypeClass());
            }
            catch (ReflectiveOperationException constructor2) {
                try {
                    Constructor<TypeHandler<?>> constructor3 = typeHandlerClass.getConstructor(new Class[0]);
                    return constructor3.newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    ReflectiveOperationException exception = e;
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    public static TypeHandler<?> getTypeHandler(Configuration cfg, Class<?> type, Class<? extends TypeHandler<?>> typeHandlerClass) {
        TypeHandler typeHandler = cfg.getTypeHandlerRegistry().getMappingTypeHandler(typeHandlerClass);
        if (Objects.nonNull(typeHandler)) {
            return typeHandler;
        }
        typeHandler = cfg.getTypeHandlerRegistry().getInstance(type, typeHandlerClass);
        return typeHandler;
    }

    public static TypeHandler<?> getTypeHandler(Configuration cfg, FieldInfo fieldInfo, Class<? extends TypeHandler<?>> typeHandlerClass, JdbcType jdbcType) {
        TypeHandler typeHandler;
        if (GenericTypeHandler.class.isAssignableFrom(typeHandlerClass)) {
            return MybatisTypeHandlerUtil.getGenericTypeHandler(typeHandlerClass, fieldInfo.getTypeClass(), fieldInfo.getField().getGenericType());
        }
        if (typeHandlerClass == UnknownTypeHandler.class && Objects.nonNull(typeHandler = cfg.getTypeHandlerRegistry().getTypeHandler(fieldInfo.getTypeClass(), jdbcType))) {
            return typeHandler;
        }
        typeHandler = cfg.getTypeHandlerRegistry().getMappingTypeHandler(typeHandlerClass);
        if (Objects.nonNull(typeHandler)) {
            return typeHandler;
        }
        typeHandler = cfg.getTypeHandlerRegistry().getInstance(fieldInfo.getTypeClass(), typeHandlerClass);
        return typeHandler;
    }

    private static TypeHandler<?> getGenericTypeHandler(Class<? extends TypeHandler<?>> typeHandlerClass, Class<?> type, Type genericType) {
        return GENERIC_TYPE_HANDLERS.computeIfAbsent(typeHandlerClass, key -> new ConcurrentHashMap()).computeIfAbsent(genericType, key -> new ConcurrentHashMap()).computeIfAbsent(type, key -> MybatisTypeHandlerUtil.newGenericTypeHandler(typeHandlerClass, type, genericType));
    }

    private static TypeHandler<?> newGenericTypeHandler(Class<? extends TypeHandler<?>> typeHandlerClass, Class<?> type, Type genericType) {
        try {
            Constructor<TypeHandler<?>> constructor = typeHandlerClass.getConstructor(Class.class, Type.class);
            return constructor.newInstance(type, genericType);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

