/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.mappers;

import cn.xbatis.core.mybatis.mapper.context.strategy.SaveBatchStrategy;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveStrategy;
import cn.xbatis.core.mybatis.mapper.mappers.BaseMapper;
import cn.xbatis.core.mybatis.mapper.mappers.utils.SaveModelMethodUtil;
import cn.xbatis.core.sql.executor.Insert;
import cn.xbatis.db.Model;
import db.sql.api.Getter;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;

public interface SaveModelMapper<T>
extends BaseMapper<T> {
    default public <M extends Model<T>> int save(M model, Consumer<SaveStrategy<M>> consumer) {
        SaveStrategy strategy = new SaveStrategy();
        consumer.accept(strategy);
        return SaveModelMethodUtil.save(this.getBasicMapper(), model, strategy);
    }

    default public <M extends Model<T>> int save(M model) {
        return this.save(model, false);
    }

    default public <M extends Model<T>> int save(M model, boolean allFieldForce) {
        return this.save(model, (SaveStrategy<M> saveStrategy) -> saveStrategy.allFieldSave(allFieldForce));
    }

    default public <M extends Model<T>> int save(M model, Getter<M> ... forceFields) {
        return this.save(model, (SaveStrategy<M> saveStrategy) -> saveStrategy.forceFields(forceFields));
    }

    default public <M extends Model<T>> int saveModel(Collection<M> list, Consumer<SaveStrategy<M>> consumer) {
        SaveStrategy strategy = new SaveStrategy();
        consumer.accept(strategy);
        return SaveModelMethodUtil.saveList(this.getBasicMapper(), list, strategy);
    }

    default public <M extends Model<T>> int saveModel(Collection<M> list) {
        return this.saveModel(list, false);
    }

    default public <M extends Model<T>> int saveModel(Collection<M> list, boolean allFieldForce) {
        return this.saveModel(list, (SaveStrategy<M> saveStrategy) -> saveStrategy.allFieldSave(allFieldForce));
    }

    default public <M extends Model<T>> int saveModel(Collection<M> list, Getter<M> ... forceFields) {
        return this.saveModel(list, (SaveStrategy<M> saveStrategy) -> saveStrategy.forceFields(forceFields));
    }

    default public <M extends Model<T>> int saveModelBatch(Collection<M> list, Consumer<SaveBatchStrategy<M>> strategy) {
        SaveBatchStrategy saveBatchStrategy = new SaveBatchStrategy();
        strategy.accept(saveBatchStrategy);
        return SaveModelMethodUtil.saveBatch(this.getBasicMapper(), new Insert(), list, saveBatchStrategy);
    }

    default public <M extends Model<T>> int saveModelBatch(Collection<M> list) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return 0;
        }
        return SaveModelMethodUtil.saveBatch(this.getBasicMapper(), list);
    }

    default public <M extends Model<T>> int saveModelBatch(Collection<M> list, Getter<M> ... forceFields) {
        return this.saveModelBatch(list, (SaveBatchStrategy<M> saveBatchStrategy) -> saveBatchStrategy.forceFields(forceFields));
    }
}

